% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_error}
\alias{oxford_error}
\title{Error colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_error
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_error} provides the four error colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The 4 error colours are
\code{"status"} (defined as HEX #7dbc23),
\code{"warning"} (defined as HEX #bc9a23),
\code{"error"} (defined as HEX #be0f34), and
\code{"error_light"} (defined as HEX #fff0f3),
}
\examples{
oxford_error
unikn::seecol(oxford_error, main = "Uni Oxford error colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
