% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun_2.R
\name{grepal}
\alias{grepal}
\title{Get a vector of colors whose names match a regular expression}
\usage{
grepal(pattern, x = colors(), ignore_case = TRUE, plot = TRUE)
}
\arguments{
\item{pattern}{A regular expression 
(specified as a string/character object).}

\item{x}{A vector of R color names or a data frame of named colors
(i.e., whose names can be searched). 
Default: \code{x = colors()}.}

\item{ignore_case}{Should the case of pattern be ignored 
(passed to \code{ignore.case} of the \code{grep} function)?   
Default: \code{ignore_case = TRUE}.}

\item{plot}{Boolean: Plot the output (using \code{\link{seecol}})? 
Default: \code{plot = TRUE}.}
}
\description{
\code{grepal} returns a vector of colors whose names match a regular expression (regex).
}
\details{
By default, the \bold{base} R vector of named colors (i.e., \code{colors()}) is searched 
for names matching a \code{pattern} (which can be a simple string or regular expression). 

If \code{x} (i.e., the object to be searched) is provided, 
it is must be a vector of color names or a data frame of named color objects 
(i.e., a color palette). 

If \code{plot = TRUE}, \code{grepal} also visualizes the detected colors  
(by passing its result to \code{\link{seecol}}, as a side-effect).

This function facilitates searching colors by name and 
yields (a vector of) colors of similar color hue (provided 
that the color's hue is expressed in a color's name). 
Its name \code{grepal} is an abbreviation of \code{grep} and "pal".
}
\examples{
grepal("tan")

# With regular expressions:
some_grey  <- grepal("gr(a|e)y", plot = FALSE)
start_grey <- grepal("^gr(a|e)y", plot = FALSE)
only_grey  <- grepal("^gr(a|e)y$", plot = FALSE)

length(some_grey)
length(only_grey)

# With other color objects (df as x):
grepal("blau", x = pal_unikn)
grepal("SEE", x = pal_unikn_pref, ignore_case = FALSE)

# Applications:
seecol(grepal("white"), col_bg = "lightblue2", main = "See 'white' colors()")

olives  <- grepal("olive", plot = FALSE)
oranges <- grepal("orange", plot = FALSE)
seecol(list(olives, oranges), 
       pal_names = c("olives", "oranges"), 
       main = "Comparing olives and oranges")

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{shades_of}} to defining shades of a given color; 
\code{\link{ac}} for adjusting color transparency; 
\code{\link{pal_unikn}} for the default uni.kn color palette.

Other color functions: 
\code{\link{ac}()},
\code{\link{demopal}()},
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{shades_of}()},
\code{\link{simcol}()},
\code{\link{usecol}()}
}
\concept{color functions}
