% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_immunization.R
\name{get_immunization_date}
\alias{get_immunization_date}
\title{Construct Immunization Date}
\usage{
get_immunization_date(
  data_set,
  outcome_date_col,
  censoring_date_col,
  immunization_delay,
  vacc_date_col,
  end_cohort,
  take_first = FALSE
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{immunization_delay}{Characteristic time in days before the patient
is considered immune.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine dates.}

\item{end_cohort}{End date of the study.}

\item{take_first}{\code{FALSE}: takes the latest vaccine date. \code{TRUE}: takes the
earliest vaccine date.}
}
\value{
Immunization date
}
\description{
This function constructs the immunization date per individual
by searching for the vaccine dates that satisfy the condition:
\code{vacc_date_col + immunization_delay <= limit_date}, where
\code{limit_date} is defined following the hierarchy:
\code{censoring_date_col}, \code{outcome_date_col}, \code{end_cohort}. If a date is not
provided/found the function takes the next one in the hierarchy.
If several columns with vaccine dates are provided, the function selects
by default the closest vaccine date to \code{limit_date}. However, it can also
select the first vaccine date by setting \code{take_first = TRUE}.
}
\keyword{internal}
