% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e.R
\name{e}
\alias{e}
\title{e}
\usage{
e(o, p)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}
}
\value{
Nash-Sutcliffe modelling efficiency (E).
}
\description{
Calculates the Nash-Sutcliffe modelling efficiency (E) from observed and
predicted values.
}
\details{
Interpretation: a value of 1 means that all predicted values are
equal to the observed values. A value of 0 means that the predictions explain
as much of the variation in the observed values as the mean of the observed
values does. A negative value means that the predictions are less accurate
the mean of the observed values.
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 2, 4, 5, 6, 8, 7, 10)
e(o=obs, p=pred)

}
\references{
Nash, J. E., & Sutcliffe, J. V. (1970). River flow forecasting
through conceptual models part I. A discussion of principles. Journal of
hydrology, 10(3), 282-290.

Piikki K., Wetterlind J., Soderstrom M., Stenberg B. (2021). Perspectives
on validation in digital soil mapping of continuous attributes. A review.
Soil Use and Management. \doi{10.1111/sum.12694}

Wilks D. S. (2011) Statistical Methods in the Atmospheric 
Sciences, Academic  Press, Oxford, UK.
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
