% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_weights.R
\name{calculate_weights}
\alias{calculate_weights}
\title{Calculate Weights}
\usage{
calculate_weights(
  sample_a,
  sample_b,
  method,
  aux_variables,
  study_variables,
  weight,
  strata,
  psu
)
}
\arguments{
\item{sample_a}{data.frame with representative sample}

\item{sample_b}{data.frame with All of Us sample}

\item{method}{string or string vector specifying weighting method to use: "ipw", "cal", and "ipw+cal"}

\item{aux_variables}{character vector with names of calibration variables}

\item{study_variables}{character vector with names of study variables}

\item{weight}{character vector with name of the weight variable in sample_a}

\item{strata}{character vector with name of the strata variable in sample_a}

\item{psu}{character vector with name of the primary sampling units variable in sample_a}
}
\value{
list of data.frame with added (or replaced) weight columns and survey designs
}
\description{
Calculate weights using three methods: IPW, Calibration, and Calibration+IPW
}
\details{
Calculates weights intended to reduce the sampling bias present in All of Us. Three versions
of weights are calculated from different reweighting strategies: IPW, Calibration, and
Calibration+IPW.
}
\examples{
# Prepare the NHIS data
calVars <- c(
  "SEX_A_R", "AGEP_A_R", "HISPALLP_A_R", "ORIENT_A_R", "HICOV_A_R", "EDUCP_A_R", "REGION_R",
  "EMPLASTWK_A_R", "HOUTENURE_A_R", "MARITAL_A_R"
)
stuVars <- "DIBTYPE_A_R"
vars_dummies <- c("AGEP_A_R","HISPALLP_A_R","EDUCP_A_R","REGION_R")
nhis_keep_vars <- c("PPSU","PSTRAT","WTFA_A")
nhis_imputed <- impute_data(nhis_processed, c(calVars, stuVars), nhis_keep_vars)
nhis_dummied <- dummies(nhis_imputed, vars=paste0(vars_dummies, '_I'))
factor_vars <- setdiff(names(nhis_dummied), nhis_keep_vars)
nhis_dummied[factor_vars] <- lapply(nhis_dummied[factor_vars], as.factor)

# Prepare the synthetic All of Us data
aou_imputed <- impute_data(aou_synthetic, c(calVars, stuVars))
aou_dummied <- dummies(aou_imputed, vars=paste0(vars_dummies, '_I'))
aou_dummied[] <- lapply(aou_dummied, as.factor)

# Calculate IPW weights using NHIS data and applied to All of Us
weights_df <- calculate_weights(
  nhis_dummied, 
  aou_dummied, 
  'ipw',
  paste0(calVars, '_I'), 
  paste0(stuVars, '_I'), 
  weight='WTFA_A',
  strata='PSTRAT',
  psu='PPSU'
)

}
