% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{webdav_list_files}
\alias{webdav_list_files}
\title{List files from a specific folder on WebDAV server}
\usage{
webdav_list_files(
  base_url,
  folder_path = NULL,
  username = Sys.getenv("WEBDAV_USERNAME"),
  password = Sys.getenv("WEBDAV_PASSWORD"),
  depth = 1,
  verbose = FALSE
)
}
\arguments{
\item{base_url}{The base URL of the WebDAV server.}

\item{folder_path}{The path inside WebDAV where the files are located. If not provided or empty, the root folder will be listed.}

\item{username}{The username for WebDAV authentication. Defaults to the "WEBDAV_USERNAME" environment variable.}

\item{password}{The password for WebDAV authentication. Defaults to the "WEBDAV_PASSWORD" environment variable.}

\item{depth}{The depth of the PROPFIND request (default is 1).}

\item{verbose}{Logical value indicating whether to print detailed debug messages. When TRUE, the function outputs additional information about its progress and actions.}
}
\value{
A tibble containing:
\describe{
  \item{display_name}{The name of the file or directory.}
  \item{full_path}{The full URL (href) of the resource.}
  \item{creation_date}{The date the resource was created.}
  \item{last_modified}{The date the resource was last modified.}
  \item{content_length}{The size of the resource in bytes (NA for directories).}
  \item{is_folder}{Logical indicating whether the resource is a directory.}
}
Returns `NULL` if an error occurs during the execution of the function.
}
\description{
This function lists the files in a specific folder on the WebDAV server. If no folder path is provided, it lists files from the root directory. The function validates the provided parameters and handles errors during the process.
}
\examples{
# Example usage with a public WebDAV server.
# Visit test_server$url link to view the results of the operation.
library(httr2)
test_server <- "http://webdavserver.net/" |>
  request() |>
  req_retry(max_tries = 1, max_seconds = 2, backoff =  ~ 1) |>
  req_perform() |>
  try(silent = TRUE)

# List files in a directory
if (class(test_server) != "try-error")
  webdav_list_files(base_url = test_server$url, folder_path = "Sales/", verbose = TRUE)

}
