% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dkmap.R
\name{dkmap}
\alias{dkmap}
\title{Mapping Matrix that maps \eqn{Q_{k+1}} to \eqn{Q_k} for a beta-Wishart Distribution, but without \eqn{n} on the diagonal}
\usage{
dkmap(k, alpha = 2)
}
\arguments{
\item{k}{The order of the mapping matrix \eqn{D_k} (a positive integer)}

\item{alpha}{The type of beta-Wishart distribution (\eqn{\alpha=2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
A matrix that maps \eqn{Q_{k+1}} to \eqn{Q_k}, but without \eqn{n} on the diagonal.
}
\description{
This function computes the matrix that maps \eqn{Q_{k+1}} to \eqn{Q_k} when \eqn{W \sim W_m^{\beta}(n, \Sigma)}.
}
\examples{
# Example 1: Compute the mapping matrix for k = 2, real Wishart
dkmap(2)
# Example 2: Compute the mapping matrix for k = 1, complex Wishart
dkmap(1, 1)
# Example 3: Compute the mapping matrix for k = 2, quaternion Wishart
dkmap(2, 1/2)
}
