% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishmom_sym.R
\name{wishmom_sym}
\alias{wishmom_sym}
\title{Symbolic Expectation of a Matrix-valued Function of a beta-Wishart Distribution}
\usage{
wishmom_sym(f, iw = 0, alpha = 2, latex = FALSE)
}
\arguments{
\item{f}{A vector of nonnegative integers \eqn{f_j} that represents
the power of \eqn{\mbox{tr}(W^{-j})}, where \eqn{j=1, \ldots, r}}

\item{iw}{The power of the beta-Wishart matrix \eqn{W^{-1}} (0 by default)}

\item{alpha}{The type of Wishart distribution \eqn{(\alpha=2/\beta)}:
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}

\item{latex}{A Boolean indicating whether the output will be a LaTeX string or a dataframe
(FALSE by default)}
}
\value{
When \code{iw = 0}, it returns an analytical expression of
\eqn{E[\prod_{j=1}^r \mbox{tr}(W^j)^{f_j}]}.
When \code{iw != 0}, it returns an analytical expression of
\eqn{E[\prod_{j=1}^r \mbox{tr}(W^j)^{f_j}W^{iw}]}.
If \code{latex = FALSE}, the output is a data frame that stores the coefficients
for calculating the result. If \code{latex = TRUE}, the output is a LaTeX
formatted string of the result in terms of \eqn{n} and \eqn{\Sigma}.
}
\description{
When \code{iw = 0}, the function returns an analytical expression of
\eqn{E[\prod_{j=1}^r \mbox{tr}(W^j)^{f_j}]}, where \eqn{W \sim W_m^{\beta}(n, S)}.
When \code{iw != 0}, the function returns an analytical expression of
\eqn{E[\prod_{j=1}^r \mbox{tr}(W^j)^{f_j}W^{iw}]}.
For a given \code{f}, \code{iw}, and \code{alpha}, this function provides the aforementioned
expectations in terms of the variables \eqn{n} and \eqn{\Sigma}.
}
\examples{
# Example 1: For E[tr(W)^4] with W ~ W_m^1(n,Sigma), represented as a dataframe:
wishmom_sym(4) # iw = 0, for real Wishart distribution

# Example 2: For E[tr(W)*tr(W^2)W] with W ~ W_m^1(n,S), represented as a dataframe:
wishmom_sym(c(1, 1), 1) # iw = 1, for real Wishart distribution

# Example 3: For E[tr(W)^4] with W ~ W_m^2(n,S), represented as a LaTeX string:
# Using writeLines() to format
writeLines(wishmom_sym(4, 0, 1, latex=TRUE)) # iw = 0, for complex Wishart distribution

# Example 4: For E[tr(W)*tr(W^2)W] with W ~ W_m^2(n,S), represented as a LaTeX string:
# Using writeLines() to format
writeLines(wishmom_sym(c(1, 1), 1, 1, latex=TRUE)) # iw = 1, for real Wishart distribution
}
