% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc2vec.R
\name{textmodel_doc2vec}
\alias{textmodel_doc2vec}
\title{Doc2vec model}
\usage{
textmodel_doc2vec(
  x,
  dim = 50,
  type = c("dm", "dbow"),
  min_count = 5,
  window = 5,
  iter = 10,
  alpha = 0.05,
  model = NULL,
  use_ns = TRUE,
  ns_size = 5,
  sample = 0.001,
  tolower = TRUE,
  include_data = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{a \link[quanteda:tokens]{quanteda::tokens} or \link[quanteda:tokens_xptr]{quanteda::tokens_xptr} object.}

\item{dim}{the size of the word vectors.}

\item{type}{the architecture of the model; either "dm" (distributed memory) or
"dbow" (distributed bag-of-words).}

\item{min_count}{the minimum frequency of the words. Words less frequent than
this in \code{x} are removed before training.}

\item{window}{the size of the window for context words. Ignored when \code{type = "dbow"} as
its context window is the entire document (sentence or paragraph).}

\item{iter}{the number of iterations in model training.}

\item{alpha}{the initial learning rate.}

\item{model}{a trained Word2vec model; if provided, its word vectors are updated for \code{x}.}

\item{use_ns}{if \code{TRUE}, negative sampling is used. Otherwise, hierarchical softmax
is used.}

\item{ns_size}{the size of negative samples. Only used when \code{use_ns = TRUE}.}

\item{sample}{the rate of sampling of words based on their frequency. Sampling is
disabled when \code{sample = 1.0}}

\item{tolower}{lower-case all the tokens before fitting the model.}

\item{include_data}{if \code{TRUE}, the resulting object includes the data supplied as \code{x}.}

\item{verbose}{if \code{TRUE}, print the progress of training.}

\item{...}{additional arguments.}
}
\value{
Returns a textmodel_doc2vec object with matrices for word and document vector values in \code{values}.
Other elements are the same as \link{textmodel_word2vec}.
}
\description{
Train a doc2vec model (Le & Mikolov, 2014) using a \link[quanteda:tokens]{quanteda::tokens} object.
}
\references{
Le, Q. V., & Mikolov, T. (2014). Distributed Representations of Sentences and
Documents (No. arXiv:1405.4053). arXiv. https://doi.org/10.48550/arXiv.1405.4053
}
