% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_base_r.R
\name{as_base_r}
\alias{as_base_r}
\title{Convert xlr types to their base R type}
\usage{
as_base_r(x)
}
\arguments{
\item{x}{a xlr object}
}
\value{
The base type of the base R object.
}
\description{
\code{as_base_r} converts xlr objects, \link{xlr_table}, \link{xlr_numeric}, \link{xlr_integer},
\link{xlr_percent}, and \link{xlr_format} to their base R type.
}
\details{
\link{as_base_r} is a generic. It is a wrapper around \link[vctrs]{vec_data} but will convert
every object to its base type.
}
\examples{
library(xlr)

# We create a xlr objects
a <- xlr_numeric(1:100)
b <- xlr_percent(1:100/100)
tab <- xlr_table(mtcars,"a title","a footnote")

# now lets convert them back to their base types
as_base_r(a)
as_base_r(b)
as_base_r(tab)
}
