% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pzconf.R
\name{pzconf}
\alias{pzconf}
\title{Calculate Confidence Intervals for the Difference of Zero Order and
  (Semi) Partial Correlation}
\usage{
pzconf(pzcor_obj, level = 0.9)
}
\arguments{
\item{pzcor_obj}{pzcor object (output from pzcor function).}

\item{level}{numerical. Confidence level used to calculate the confidence
interval. This may be a vector so multiple intervals can be determined.}
}
\value{
The confidence interval(s) is(are) displayed in a dataframe with four
  columns: Level, Lower, Upper, and Warnings. Level refers to the confidence
  level of the interval. Lower and Upper are the respective lower and upper
  bounds of the interval. Warnings may say "Max Level Passed" to show that
  the specified confidence level exceeds the largest confidence interval
  that can be determined from the test. The largest confidence interval is
  shown in the last row (named "Max").
}
\description{
The \code{pzconf} function calculates confidence intervals for a
  zero order correlation minus a (semi) partial correlation (\eqn{\rho.xy -
  \rho.xy.z}). It is intended to be used after the \code{\link{pzcor}}
  function.
}
\details{
The \code{pzconf} function calculates confidence intervals based on
  the bootstrap distribution determined from the \code{\link{pzcor}}
  function. See \code{?pzcor} for details.
}
\examples{
require(graphics)
require(MASS)
# data
set.seed(1111)
mu <- rep(0,4)
Sigma <- matrix(.2, nrow=4, ncol=4) + diag(4)*.8
data <- mvrnorm(n=100, mu=mu, Sigma=Sigma)

# p.(1,2) = p.(1,2)|(3,4) test
test <- pzcor(data[,1], data[,2], data[,c(3,4)], k = 1000)
hist(test$distribution)
pzconf(test, c(0.9, 0.95, 0.99))

}
\seealso{
\code{\link{pzcor}}
}
