% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createZoomRosetta.R
\name{createZoomRosetta}
\alias{createZoomRosetta}
\title{Create a file to aid in adding a unique identifier to link to the zoom user name}
\usage{
createZoomRosetta(zoomOutput)
}
\arguments{
\item{zoomOutput}{the output from running processZoomOutput}
}
\value{
a data.frame that has unique values for the zoom display name
that show up across any files that are available, including
participants, transcript, and chat. If the user gives the participants
file, it will separate display name changes and include all versions. If
there are emails attached to display names, it will include those.
}
\description{
A major challenge in analyzing virtual meetings is reconciling the display
name that zoom users in chat and transcript. This function outputs a data.frame
that can be helpful in manually adding a new unique identifier to use in
further data anlaysis.
}
\examples{
rosetta.out = createZoomRosetta(processZoomOutput(fileRoot=
file.path(system.file('extdata', package = 'zoomGroupStats'),"meeting001")))
\dontrun{
rosetta.out = createZoomRosetta(processZoomOutput(fileRoot="~/zoomMeetings/meeting001"))
}
}
