% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textSentiment.R
\name{textSentiment}
\alias{textSentiment}
\title{Conduct a sentiment analysis on text data}
\usage{
textSentiment(
  inputData,
  idVars,
  textVar,
  sentMethods,
  appendOut = FALSE,
  languageCodeVar
)
}
\arguments{
\item{inputData}{data.frame that has been output by either the processZoomTranscript or processZoomChat functions}

\item{idVars}{vector with the name of variables that give the unique identifiers for this piece of text. Usually this will be a the meeting id variable and the text id variable (e.g., utteranceId, messageId)}

\item{textVar}{name of variable that contains the text}

\item{sentMethods}{a vector specifying the types of sentiment analysis-currently
either "aws" or "syuzhet"}

\item{appendOut}{boolean indicating whether you want the sentiment results
merged to the inputData in your output}

\item{languageCodeVar}{name of variable that contains the language code}
}
\value{
returns a list containing as data.frames the output of the sentiment analyses
that were requested in sentMethods. For each output data.frame, the first columns
are the idVars specified to enable combining back with the original inputData
}
\description{
This function takes in the output of the chat and transcript functions. It then
conducts a sentiment analysis on an identified chunk of text
and returns the values.
To use the aws option, you must have an aws account that with privileges for the comprehend service
However you authenticate for AWS, you should do so before running calling the function
with this option in sentMethods
}
\examples{
sent.out = textSentiment(inputData=sample_chat_processed,
idVars=c('batchMeetingId', 'messageId'), 
textVar='message', sentMethods='syuzhet',appendOut=TRUE,
languageCodeVar='messageLanguage')

\dontrun{
sent.out = textSentiment(inputData=sample_transcript_processed, 
idVars=c('batchMeetingId','utteranceId'), 
textVar='utteranceMessage', sentMethods=c('aws','syuzhet'), 
appendOut=TRUE, languageCodeVar='utteranceLanguage')
}

}
