/* powerpc64le-linux.kernel.vmlinux.h
   created from powerpc64le-linux.kernel.vmlinux.bin, 10035 (0x2733) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_SIZE    10035
#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_ADLER32 0xe3e14d04
#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_CRC32   0xd3f47a72

unsigned char stub_powerpc64le_linux_kernel_vmlinux[10035] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 21,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 72, 30,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */   0,  0,  0, 72,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */ 208,  0,  6, 40, 32,  0,194, 76,191,240,132, 84, 32,  0,194, 77,
/* 0x0060 */  16,  0,  0, 60, 64,  0,  4,124,  8,  0,128, 65,120,  3,  4,124,
/* 0x0070 */  32,  1,165, 56,120, 27,103,124,252,255, 99, 56,166,  3,137,124,
/* 0x0080 */  28,  0,  0, 72,186,  2, 11, 84, 80, 88, 99,125, 20, 58,107,125,
/* 0x0090 */ 186,  1, 96, 81,  0,  0,  3,144, 32,  0, 64, 79,  4,  0,  3,132,
/* 0x00a0 */ 190, 85, 11, 84, 64, 40, 11,124,220,255,194, 65,240,255, 32, 67,
/* 0x00b0 */  32,  0,128, 78,236, 41,  0,124,166,  2,168,125,  2,  0,  7, 40,
/* 0x00c0 */ 236,  0,130, 64,  0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,
/* 0x00d0 */ 198,  7,  0,120,120,  3,  9,124,255,255, 99, 56,255,255,165, 56,
/* 0x00e0 */ 255,255, 64, 57,184,  0,  0, 72, 20, 73, 41,125, 36,248, 41,121,
/* 0x00f0 */  64,  0, 41,124, 20, 72, 41,125, 32,  0,226, 76,  1,  0, 32, 57,
/* 0x0100 */  46, 24, 41,125,  4,  0, 99, 56,224,255,255, 75,  1,  0,  3,141,
/* 0x0110 */   1,  0,  5,157,221,255,255, 75,244,255,225, 65,  1,  0,224, 56,
/* 0x0120 */ 209,255,255, 75, 21, 57,231,124,201,255,255, 75,244,255,192, 65,
/* 0x0130 */ 253,255,231, 52,  0,  0,  0, 57, 24,  0,192, 65,  1,  0, 99,141,
/* 0x0140 */  46, 64,231, 84,248, 88,234,124, 63,  0, 75, 85,  0,  0,194, 65,
/* 0x0150 */ 161,255,255, 75, 21, 65,  8,125,153,255,255, 75, 21, 65,  8,125,
/* 0x0160 */   1,  0,224, 56, 28,  0,194, 64,  3,  0,224, 56,  1,  0,  0, 57,
/* 0x0170 */ 129,255,255, 75, 21, 65,  8,125,121,255,255, 75,244,255,192, 65,
/* 0x0180 */ 255,242,106, 33, 20, 57,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x0190 */   1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x01a0 */ 236, 41,  7,124, 44, 26,  7,124,108,255,255, 75,236, 41,  0,124,
/* 0x01b0 */ 166,  2,168,125,  5,  0,  7, 40, 48,  1,130, 64,  0,  0,166,248,
/* 0x01c0 */  20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,  0,128, 32, 61,
/* 0x01d0 */ 198,  7, 41,121,255,255, 99, 56,255,255,165, 56,255,255, 64, 57,
/* 0x01e0 */ 248,  0,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x01f0 */  20, 73, 41,125, 36,248, 41,121, 64,  0, 41,124, 20, 72, 41,125,
/* 0x0200 */  32,  0,128, 78,  1,  0,  3,141,  1,  0,  5,157, 64,  0, 41,124,
/* 0x0210 */  20, 72, 41,125,209,255,194, 65,236,255,225, 65,  1,  0,224, 56,
/* 0x0220 */  20,  0,  0, 72,255,255,231, 56, 21, 72, 41,125,185,255,194, 65,
/* 0x0230 */  21, 57,231,124, 21, 72, 41,125,173,255,194, 65, 21, 57,231,124,
/* 0x0240 */  64,  0, 41,124, 20, 72, 41,125,157,255,194, 65,216,255,192, 65,
/* 0x0250 */   0,  0,  0, 57,253,255,231, 52, 46, 64,231, 84, 28,  0,192, 65,
/* 0x0260 */   1,  0, 99,141,249, 88,234,124,112, 14, 74,125,  0,  0, 42, 44,
/* 0x0270 */   0,  0,194, 65, 12,  0,  0, 72, 21, 72, 41,125,105,255,194, 65,
/* 0x0280 */  21, 65,  8,125, 21, 72, 41,125, 93,255,194, 65, 21, 65,  8,125,
/* 0x0290 */  40,  0,130, 64,  1,  0,  0, 57, 21, 72, 41,125, 73,255,194, 65,
/* 0x02a0 */  21, 65,  8,125, 64,  0, 41,124, 20, 72, 41,125, 57,255,194, 65,
/* 0x02b0 */ 232,255,192, 65,  2,  0,  8, 57,255,250,234, 32,  1,  0,  8, 57,
/* 0x02c0 */ 148,  1,  8,125, 20, 42,234,124,166,  3,  9,125,  1,  0,  7,141,
/* 0x02d0 */   1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,236, 41,  7,124,
/* 0x02e0 */  44, 26,  7,124, 40,255,255, 75,236, 41,  0,124,166,  2,168,125,
/* 0x02f0 */   8,  0,  7, 40, 72,  1,130, 64,  0,  0,166,248, 20, 26,132,124,
/* 0x0300 */   0,128,  0, 60,198,  7,  0,120,120,  3,  9,124,255,255, 99, 56,
/* 0x0310 */ 255,255,165, 56,255,255, 64, 57, 20,  1,  0, 72,  1,  0, 32, 57,
/* 0x0320 */  46, 24, 41,125,  4,  0, 99, 56, 20, 73, 41,125, 36,248, 41,121,
/* 0x0330 */  64,  0, 41,124, 20, 72, 41,125, 32,  0,128, 78,  1,  0,  3,141,
/* 0x0340 */   1,  0,  5,157, 64,  0, 41,124, 20, 72, 41,125,209,255,194, 65,
/* 0x0350 */ 236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56,
/* 0x0360 */  21, 72, 41,125,185,255,194, 65, 20, 57,231,124, 21, 72, 41,125,
/* 0x0370 */ 173,255,194, 65, 20, 57,231,124, 64,  0, 41,124, 20, 72, 41,125,
/* 0x0380 */ 157,255,194, 65,216,255,192, 65,253,255,231, 52,  0,  0,  0, 57,
/* 0x0390 */  40,  0,192, 65,  1,  0, 99,141,198, 69,231,120,118,  6,231,124,
/* 0x03a0 */ 249, 88,234,124,116, 14, 74,125,  0,  0,194, 65,  1,  0,107,113,
/* 0x03b0 */  80,  0,226, 65, 20,  0,  0, 72, 64,  0, 41,124, 20, 72, 41,125,
/* 0x03c0 */  93,255,194, 65, 60,  0,225, 65,  1,  0,  0, 57, 64,  0, 41,124,
/* 0x03d0 */  20, 72, 41,125, 73,255,194, 65, 40,  0,225, 65, 21, 72, 41,125,
/* 0x03e0 */  61,255,194, 65, 20, 65,  8,125, 64,  0, 41,124, 20, 72, 41,125,
/* 0x03f0 */  45,255,194, 65,232,255,192, 65,  2,  0,  8, 57, 16,  0,  0, 72,
/* 0x0400 */  21, 72, 41,125, 25,255,194, 65, 20, 65,  8,125,255,250,106, 33,
/* 0x0410 */   2,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x0420 */   1,  0,103,141,  1,  0,101,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x0430 */ 236, 41,  7,124, 44, 26,  7,124, 12,255,255, 75,  0,  0,230,232,
/* 0x0440 */ 166,  3,168,125, 80, 24,100,124, 80, 40,135,124,  1,  0, 99, 56,
/* 0x0450 */   1,  0,132, 56,  0,  0,134,248, 31,  0,231, 96,108, 56,  0,124,
/* 0x0460 */  64, 40, 39,124,172, 63,  0,124, 32,  0,231, 56,240,255,128, 65,
/* 0x0470 */ 172,  4,  0,124, 44,  1,  0, 76, 32,  0,128, 78, 14,  0,  7, 40,
/* 0x0480 */   0,  0,130, 64,120, 11, 42,124,  0,  0, 38, 57,  0,  0,  6,129,
/* 0x0490 */ 120, 43,167,124,254,255,164, 56,  2,  0,131, 56,  0,  0,131,137,
/* 0x04a0 */ 194,232,139,121, 96,  7,140,121,  0,250, 96, 56, 54, 88, 99,124,
/* 0x04b0 */ 100,241, 99, 56, 20, 26, 33,124,100,  6, 33,120,  0,  0,  0, 56,
/* 0x04c0 */ 120, 83, 67,125,  0,  0,  9,144,249,255,  3,248, 64, 24, 33,124,
/* 0x04d0 */ 248,255,128, 65,255,255,  4,136, 32,  0,193, 56, 40,  0, 97, 56,
/* 0x04e0 */   2,  0,131,153, 16,  0,225,248, 24,  0, 33,249,  2,225, 11,120,
/* 0x04f0 */  32,  7,  0,120,  1,  0, 99,153,  0,  0,  3,152,145,255, 65,249,
/* 0x0500 */ 166,  2,  8,124, 16,  0,  1,248, 21,  0,  0, 72, 16,  0,  1,232,
/* 0x0510 */   0,  0, 33,232,166,  3,  8,124, 32,  0,128, 78,112,  0, 33, 56,
/* 0x0520 */  24,  0,161,232, 16,  0,225,232,  0,  0,165,128,  0,  0, 33,232,
/* 0x0530 */  20, 58,165,124, 16,  0,  1,232,255,255,165, 56,166,  3,  8,124,
/* 0x0540 */   0,  0, 33,232, 32,  0,128, 78,166,  2,  8,124,  1,  0, 64, 57,
/* 0x0550 */   1,  0,  0, 72,  4,  0, 99, 59,  2,  0,227, 59,  0,  4,  0, 56,
/* 0x0560 */   2,  0, 99,137, 48, 88, 75,125,255,255,107, 57, 32,  0,107,121,
/* 0x0570 */  96,255, 97,249,  1,  0, 99,137, 48, 88, 74,125,  0,  0, 96, 57,
/* 0x0580 */ 255,255, 74, 57, 32,  0, 74,121,104,255, 65,249,  0,  0, 67,137,
/* 0x0590 */   0,  0,102,145,  0,  0,105,145,180,  7, 85,125,  1,  0, 99,137,
/* 0x05a0 */  20, 82, 75,125,  0,  3, 96, 57, 48, 80,106,125, 54,  7, 74, 57,
/* 0x05b0 */  32,  0, 74,121,  0,  0,138, 47,  1,  0,106, 57,  8,  0,254, 64,
/* 0x05c0 */   1,  0, 96, 57,255,255,107, 53, 12,  0,130, 65,  2,  0, 31,180,
/* 0x05d0 */ 244,255,255, 75,  5,  0,  0, 56, 20, 42,164,124,166,  3,  9,124,
/* 0x05e0 */   5,  0,100, 57,120, 35,159,124,  0,  0, 64, 57, 64, 40,191,127,
/* 0x05f0 */  12,  0,158, 64,  1,  0, 96, 56, 88, 10,  0, 72,  1,  0,255, 59,
/* 0x0600 */ 255,255, 31,136, 46, 64, 74, 85,120, 83, 10,124, 32,  0, 74,121,
/* 0x0610 */ 220,255,  0, 66,255,255,  0, 56,255,  0, 32, 63, 32,  0,  0,120,
/* 0x0620 */   1,  0,192, 58,  1,  0,  0, 59,  1,  0,224, 58,  1,  0, 64, 58,
/* 0x0630 */   0,  0,128, 57,  0,  0,192, 59,  0,  0, 64, 59,255,255, 57, 99,
/* 0x0640 */   1,  0,128, 58,  8,  0,117, 34, 64, 64,154,127,216,  9,156, 64,
/* 0x0650 */  96,255,161,235, 64,200,128,127, 56,232, 95,127, 54, 32,157, 85,
/* 0x0660 */ 180,  7,252,127,180,  7,189,127, 20,234,188,127,164, 15,189,123,
/* 0x0670 */  36,  0,157, 65, 64, 40,171,127,124,255,158, 65,  0,  0,139,139,
/* 0x0680 */  46, 64, 74, 85, 40, 64,  0,120,  1,  0,107, 57,120, 83,138,127,
/* 0x0690 */  32,  0, 74,121, 46,234,251,125,254,170, 16, 84,214,121, 16,126,
/* 0x06a0 */  64,128,138,127, 32,  0, 28,122,228,  1,156, 64,  0,  8, 15, 32,
/* 0x06b0 */ 104,255,225,235, 48,158,222,127,112, 46,  0,124, 20,122,224,125,
/* 0x06c0 */  56,248, 64,127, 46,235,251,125, 48,168, 29,124,  6,  0,140, 47,
/* 0x06d0 */  20,234,190,127,  0,  3,189, 31, 32,  0,189,123, 54,  7,189, 59,
/* 0x06e0 */ 164, 15,189,123, 20,234,187,127, 16,  0,157, 65,  1,  0,192, 59,
/* 0x06f0 */ 120,227,128,127, 12,  1,  0, 72, 80,208, 18,124,  1,  0,192, 59,
/* 0x0700 */  32,  0,  0,120,174,  0,231,125, 60,  8,255, 85,180,  7,239,127,
/* 0x0710 */ 238,  5,255, 87, 64,200,156,127,180,  7,255,127,  0,  1, 63, 58,
/* 0x0720 */  20,242, 49,126,164, 15, 49,122, 36,  0,157, 65, 64, 40,171,127,
/* 0x0730 */ 196,254,158, 65,  0,  0, 11,136, 46, 64, 74, 85, 40, 64,156,123,
/* 0x0740 */   1,  0,107, 57,120, 83, 10,124, 32,  0, 74,121, 46,138, 29,126,
/* 0x0750 */ 254,170,128, 87, 60,  8,222, 87,214,129,  0,124, 64,  0, 10,127,
/* 0x0760 */  32,  0, 14,120,  0,  0,191, 47, 36,  0,152, 64,  0,  8, 16, 32,
/* 0x0770 */ 180,  7,222,127,112, 46,  0,124, 20,130,  0,126,120,115,220,125,
/* 0x0780 */  46,139, 29,126, 48,  0,158, 65,104,255,255, 75, 80,224,128,127,
/* 0x0790 */  80, 80, 64,125,126,217,  0, 86, 80,128,  0,126,  1,  0,222, 59,
/* 0x07a0 */  32,  0,156,123, 32,  0, 74,121, 46,139, 29,126,180,  7,222,127,
/* 0x07b0 */  64,255,158, 65,255,  0,158, 47, 80,255,157, 64, 52,255,255, 75,
/* 0x07c0 */  64,200,128,127,164, 15,208,123, 68,  0,157, 64, 46,130,157,127,
/* 0x07d0 */ 254,170, 31, 84, 60,  8,222, 87,214,225,255,127, 64,248,138,127,
/* 0x07e0 */  32,  0,241,123, 76,  0,156, 64,  0,  8, 28, 32,180,  7,222,127,
/* 0x07f0 */ 112, 46,  0,124, 20,226,128,127, 46,131,157,127,120,139, 32,126,
/* 0x0800 */ 255,  0,158, 47,188,255,157, 64, 80,  0,  0, 72, 64, 40,171,127,
/* 0x0810 */ 228,253,158, 65,  0,  0,235,139, 46, 64, 74, 85, 40, 64,  0,120,
/* 0x0820 */   1,  0,107, 57,120, 83,234,127, 32,  0, 74,121,160,255,255, 75,
/* 0x0830 */  80,  0, 31,124, 80, 80, 95,125,126,217,159, 87, 80,224,159,127,
/* 0x0840 */   1,  0,222, 59, 32,  0, 74,121, 46,131,157,127,180,  7,222,127,
/* 0x0850 */  32,  0, 17,120,168,255,255, 75, 32,  6,222,123,  1,  0,250, 59,
/* 0x0860 */   3,  0,140, 47, 32,  0,255,123,174,209,199,127,172,  7,157, 64,
/* 0x0870 */   9,  0,140, 47, 12,  0,157, 65,253,255,140, 57,  8,  0,  0, 72,
/* 0x0880 */ 250,255,140, 57,180,  7,140,125,148,  7,  0, 72, 80,  0, 16,124,
/* 0x0890 */ 126,217,254, 85, 80, 80, 16,126, 80,120,254,125,192,  0,140, 59,
/* 0x08a0 */  64,200,128,127, 46,235,251,125, 32,  0, 17,120, 32,  0, 10,122,
/* 0x08b0 */ 164, 15,156,123, 36,  0,157, 65, 64, 40,171,127, 56,253,158, 65,
/* 0x08c0 */   0,  0, 75,137, 46, 64, 16, 86, 40, 64, 17,120,  1,  0,107, 57,
/* 0x08d0 */ 120,131, 74,125, 32,  0, 74,121, 46,226, 27,126,254,170, 32, 86,
/* 0x08e0 */ 214,129,  0,124, 64,  0,138,127, 32,  0, 30,120, 68,  0,156, 64,
/* 0x08f0 */   7,  0,140, 47,  0,  8, 16, 32, 38, 16,144,125,254,239,140, 85,
/* 0x0900 */ 112, 46,  0,124, 20,130,  0,126,120,195, 22,127,208,  0,140,125,
/* 0x0910 */ 120,187,248,126, 46,227, 27,126, 66,240,140,121,104,  6,163, 59,
/* 0x0920 */   0, 16,140,121,120,147, 87,126,  3,  0,140, 57,124,  2,  0, 72,
/* 0x0930 */  80,136,192,127,126,217, 15, 86, 80,128, 15,126, 80, 80,  0,124,
/* 0x0940 */  64,200,158,127, 46,227, 27,126, 32,  0,209,123, 32,  0, 10,120,
/* 0x0950 */  24,  0, 28, 58, 36,  0,157, 65, 64, 40,171,127,152,252,158, 65,
/* 0x0960 */   0,  0, 75,137, 46, 64,  0, 84, 40, 64,209,123,  1,  0,107, 57,
/* 0x0970 */ 120,  3, 74,125, 32,  0, 74,121, 46,130,251,125,254,170, 32, 86,
/* 0x0980 */ 214,121,  0,124, 64,  0,138,127, 32,  0, 30,120,208,  0,156, 64,
/* 0x0990 */   0,  8,143, 35, 64,200,128,127,112, 46,156,127, 20,122,252,125,
/* 0x09a0 */ 224,  1,189, 59, 46,131,251,125, 36,  0,157, 65, 64, 40,171,127,
/* 0x09b0 */  68,252,158, 65, 40, 64, 30,120,  0,  0, 11,136, 46, 64, 74, 85,
/* 0x09c0 */   1,  0,107, 57,120, 83, 10,124, 32,  0, 74,121, 46,234, 59,126,
/* 0x09d0 */ 254,170,220, 87,214,137,156,127, 64,224,138,127, 32,  0,128,123,
/* 0x09e0 */  80,  0,156, 64,  0,  8,241, 35,  0,  0,186, 47,112, 46,255,127,
/* 0x09f0 */  20,138, 63,126, 46,235, 59,126,252,251,158, 65,  7,  0,140, 47,
/* 0x0a00 */  80,208,242,127, 38, 16,144,125,254,239,140, 85, 32,  0,255,123,
/* 0x0a10 */ 208,  0,140,125,174,248,199,127,164,  7,140,121,  1,  0,250, 59,
/* 0x0a20 */  11,  0,140, 57, 32,  0,255,123,174,209,199,127,240,  5,  0, 72,
/* 0x0a30 */ 126,217, 32, 86, 80,136,  0,124, 80,240,220,127, 80, 80, 92,125,
/* 0x0a40 */  46,235, 27,124, 32,  0,222,123,120,195,  0,127, 32,  0, 74,121,
/* 0x0a50 */ 120,147, 88,126,120,187,242,126,124,  0,  0, 72, 80,136, 32,126,
/* 0x0a60 */ 126,217,254, 85, 80, 80,  0,124, 80,120,254,125, 64,200,145,127,
/* 0x0a70 */  46,131,251,125, 32,  0, 61,122, 32,  0, 10,120, 48,  0, 28, 58,
/* 0x0a80 */  36,  0,157, 65, 64, 40,171,127,108,251,158, 65,  0,  0, 75,137,
/* 0x0a90 */  46, 64,  0, 84, 40, 64, 61,122,  1,  0,107, 57,120,  3, 74,125,
/* 0x0aa0 */  32,  0, 74,121, 46,130, 59,126,254,170,160, 87,214,137,  0,124,
/* 0x0ab0 */  64,  0,138,127, 32,  0, 30,120, 36,  0,156, 64,  0,  8, 17, 32,
/* 0x0ac0 */ 112, 46,  0,124, 20,138, 32,126,120,195,  0,127, 46,131, 59,126,
/* 0x0ad0 */ 120,187,248,126,120,  3, 23,124,160,  0,  0, 72, 80,232,160,127,
/* 0x0ae0 */ 126,217, 62, 86, 80, 80,  0,124, 80,136, 62,126, 64,200,157,127,
/* 0x0af0 */  32,  0,175,123, 46,131, 59,126, 32,  0, 10,120, 72,  0,156, 59,
/* 0x0b00 */  36,  0,157, 65, 64, 40,171,127,236,250,158, 65,  0,  0, 75,137,
/* 0x0b10 */  46, 64,  0, 84, 40, 64,175,123,  1,  0,107, 57,120,  3, 74,125,
/* 0x0b20 */  32,  0, 74,121, 46,226,187,127,254,170,224, 85,214,233,  0,124,
/* 0x0b30 */  64,  0,138,127, 32,  0, 30,120, 24,  0,156, 64,  0,  8, 29, 32,
/* 0x0b40 */ 112, 46,  0,124, 20,234,  0,124, 46,227, 27,124, 44,  0,  0, 72,
/* 0x0b50 */  80,120,192,127, 80, 80, 64,125,126,217,160, 87, 80,232,  0,124,
/* 0x0b60 */  32,  0, 74,121, 46,227, 27,124,120,195,  0,127, 32,  0,222,123,
/* 0x0b70 */ 120,179,216,126,120,  3, 22,124,  7,  0,140, 47,120,147, 64,126,
/* 0x0b80 */  38, 16,144,125,254,239,140, 85,120,195, 18,127,108, 10,163, 59,
/* 0x0b90 */ 120,187,248,126,120,  3, 23,124,208,  0,140,125, 66,240,140,121,
/* 0x0ba0 */   0, 16,140,121, 11,  0,140, 57, 64,200,158,127, 36,  0,157, 65,
/* 0x0bb0 */  64, 40,171,127, 64,250,158, 65,  0,  0, 11,136, 46, 64, 74, 85,
/* 0x0bc0 */  40, 64,222,123,  1,  0,107, 57,120, 83, 10,124, 32,  0, 74,121,
/* 0x0bd0 */   0,  0,253,161,254,170,220, 87,214,121,156,127, 64,224,138,127,
/* 0x0be0 */  32,  0,128,123, 48,  0,156, 64, 56, 24,255, 87,  0,  8, 47, 34,
/* 0x0bf0 */ 180,  7,255,127,112, 46, 49,126,  2,  0,255, 59, 20,122, 49,126,
/* 0x0c00 */ 164, 15,255,123,  0,  0, 61,178,  0,  0,  0, 58, 20,250,189,127,
/* 0x0c10 */ 136,  0,  0, 72, 80,240,220,127,126,217,241, 85, 80, 80,156,127,
/* 0x0c20 */  80,120, 49,126, 64,200,158,127, 32,  0,208,123,  0,  0, 61,178,
/* 0x0c30 */  32,  0,138,123, 36,  0,157, 65, 64, 40,171,127,184,249,158, 65,
/* 0x0c40 */   0,  0, 75,137, 46, 64,156, 87, 40, 64,208,123,  1,  0,107, 57,
/* 0x0c50 */ 120,227, 74,125, 32,  0, 74,121,  2,  0,157,163,254,170, 30, 86,
/* 0x0c60 */ 214,225,222,127, 64,240,138,127, 32,  0,192,123, 52,  0,156, 64,
/* 0x0c70 */  56, 24,255, 87,  0,  8,220, 35,180,  7,255,127,112, 46,222,127,
/* 0x0c80 */ 130,  0,255, 59, 20,226,158,127,164, 15,255,123,  2,  0,157,179,
/* 0x0c90 */   8,  0,  0, 58, 20,250,189,127,  3,  0, 32, 58, 44,  0,  0, 72,
/* 0x0ca0 */ 126,217,159, 87, 80,128, 30,124, 80, 80, 94,125, 80,224,255,127,
/* 0x0cb0 */  32,  0, 74,121,  2,  0,253,179, 32,  0,  0,120,  4,  2,189, 59,
/* 0x0cc0 */  16,  0,  0, 58,  8,  0, 32, 58,255,255,241, 59,  1,  0,192, 59,
/* 0x0cd0 */  32,  0,255,123,  1,  0,255, 59,166,  3,233,127,164, 15,220,123,
/* 0x0ce0 */  64,200,128,127, 20,226,157,127, 36,  0,157, 65, 64, 40,171,127,
/* 0x0cf0 */   4,249,158, 65,  0,  0,235,139, 46, 64, 74, 85, 40, 64,  0,120,
/* 0x0d00 */   1,  0,107, 57,120, 83,234,127, 32,  0, 74,121,  0,  0,252,161,
/* 0x0d10 */ 254,170, 31, 84, 60,  8,222, 87,214,121,255,127, 64,248,138,127,
/* 0x0d20 */  32,  0,238,123, 32,  0,156, 64,  0,  8, 15, 32,180,  7,222,127,
/* 0x0d30 */ 112, 46,  0,124, 20,122,224,125,120,115,192,125,  0,  0,252,177,
/* 0x0d40 */  40,  0,  0, 72, 80,  0, 31,124, 80, 80, 95,125,126,217,255, 85,
/* 0x0d50 */  80,120,255,125,  1,  0,222, 59,  0,  0,252,177, 32,  0,  0,120,
/* 0x0d60 */  32,  0, 74,121,180,  7,222,127,116,255,  0, 66, 48,136,145,126,
/* 0x0d70 */   3,  0,140, 47, 80,128, 49,126, 20,242,145,127, 80,  2,157, 65,
/* 0x0d80 */   3,  0,156, 47,120,227,158,127,  8,  0,157, 64,  3,  0,192, 59,
/* 0x0d90 */  50, 48,222, 87,180,  7,222,127,  6,  0,160, 59,176,  1,222, 59,
/* 0x0da0 */ 166,  3,169,127,164, 15,222,123,  1,  0,224, 59,164, 15,241,123,
/* 0x0db0 */  64,200,128,127, 20,242, 49,126, 36,  0,157, 65, 64, 40,171,127,
/* 0x0dc0 */  52,248,158, 65,  0,  0,171,139, 46, 64, 74, 85, 40, 64,  0,120,
/* 0x0dd0 */   1,  0,107, 57,120, 83,170,127, 32,  0, 74,121, 46,138, 91,126,
/* 0x0de0 */ 254,170, 29, 84, 60,  8,255, 87,214,145,189,127, 64,232,138,127,
/* 0x0df0 */  32,  0,176,123, 32,  0,156, 64,  0,  8, 18, 32,180,  7,255,127,
/* 0x0e00 */ 112, 46,  0,124, 20,146, 64,126,120,131,  0,126, 46,139, 91,126,
/* 0x0e10 */  40,  0,  0, 72, 80,  0, 29,124, 80, 80, 93,125,126,217, 93, 86,
/* 0x0e20 */  80,144, 93,126,  1,  0,255, 59, 46,139, 91,126, 32,  0,  0,120,
/* 0x0e30 */  32,  0, 74,121,180,  7,255,127,116,255,  0, 66,192,255,255, 59,
/* 0x0e40 */   3,  0,159, 47,180,  7,242,127,108,  1,157, 64,254,  7,241, 87,
/* 0x0e50 */  13,  0,159, 47,  2,  0, 49, 98,112, 14,254,127, 32,  0, 61,122,
/* 0x0e60 */  40,  0,157, 65,255,255,254, 59,176,  2,210, 35,180,  7,253,127,
/* 0x0e70 */  48,248, 63,126, 20,250,222,127,164, 15,222,123,254,255,222, 59,
/* 0x0e80 */  20,242,219,127,116,  0,  0, 72,250,255,222, 59, 32,  0,222,123,
/* 0x0e90 */   1,  0,222, 59,166,  3,201,127, 64,200,128,127, 36,  0,157, 65,
/* 0x0ea0 */  64, 40,171,127, 80,247,158, 65,  0,  0,235,139, 46, 64, 74, 85,
/* 0x0eb0 */  40, 64,  0,120,  1,  0,107, 57,120, 83,234,127, 32,  0, 74,121,
/* 0x0ec0 */ 126,248, 30, 84, 60,  8,191, 87, 64,240,138,127, 32,  0,192,123,
/* 0x0ed0 */  32,  0,253,123, 20,  0,156, 65, 80, 80, 94,125,  1,  0,255, 99,
/* 0x0ee0 */  32,  0, 74,121, 32,  0,253,123,176,255,  0, 66, 40, 32,191,123,
/* 0x0ef0 */  72,  6,195, 59,  4,  0,160, 59,255,255,189, 59,  1,  0, 64, 58,
/* 0x0f00 */  32,  0,189,123,  1,  0, 32, 58,  1,  0,189, 59,166,  3,169,127,
/* 0x0f10 */ 164, 15, 80,122, 64,200,128,127, 20,130, 30,126, 36,  0,157, 65,
/* 0x0f20 */  64, 40,171,127,208,246,158, 65,  0,  0,171,139, 46, 64, 74, 85,
/* 0x0f30 */  40, 64,  0,120,  1,  0,107, 57,120, 83,170,127, 32,  0, 74,121,
/* 0x0f40 */   0,  0,240,161,254,170, 29, 84, 60,  8, 82, 86,214,121,189,127,
/* 0x0f50 */  64,232,138,127, 32,  0,174,123, 32,  0,156, 64,  0,  8, 15, 32,
/* 0x0f60 */ 180,  7, 82,126,112, 46,  0,124, 20,122,224,125,120,115,192,125,
/* 0x0f70 */   0,  0,240,177, 48,  0,  0, 72, 80,  0, 29,124, 80, 80, 93,125,
/* 0x0f80 */ 126,217,253, 85, 80,120,253,125,  1,  0, 82, 58,  0,  0,240,177,
/* 0x0f90 */ 120,251, 63,126, 32,  0,  0,120, 32,  0, 74,121,180,  7, 82,126,
/* 0x0fa0 */  32,  0,255,123, 60,  8, 49, 86,180,  7, 49,126,100,255,  0, 66,
/* 0x0fb0 */   8,  0,  0, 72, 32,  0,255,123,  1,  0,255, 59, 33,  0,242,123,
/* 0x0fc0 */ 100,  0,130, 65,  7,  0,140, 57,180,  7,140,125,  2,  0,220, 59,
/* 0x0fd0 */  64,208,146,127,180,  7,222,127, 28,246,157, 65,255,255,222, 59,
/* 0x0fe0 */  32,  0,222,123,  1,  0,222, 59,166,  3,201,127, 80,208,242,127,
/* 0x0ff0 */   1,  0,186, 59, 32,  0,255,123,174,248,199,127, 32,  0,191,123,
/* 0x1000 */ 174,209,199,127, 24,  0, 64, 66, 64, 64,157,127,120,251,250,127,
/* 0x1010 */ 220,255,156, 65,  8,  0,  0, 72,  0,  0,128, 57,120,251,250,127,
/* 0x1020 */  40,246,255, 75,255,  0, 64, 61,255,255, 74, 97, 64, 80,128,127,
/* 0x1030 */  16,  0,157, 65, 64, 40,171,127,188,245,158, 65,  1,  0,107, 57,
/* 0x1040 */  80, 88,132,124,  0,  0, 96, 56,  0,  0,134,144,  0,  0, 73,147,
/* 0x1050 */   0,  0,  0, 72,112,255,193,249,120,255,225,249,128,255,  1,250,
/* 0x1060 */ 136,255, 33,250,144,255, 65,250,152,255, 97,250,160,255,129,250,
/* 0x1070 */ 168,255,161,250,176,255,193,250,184,255,225,250,192,255,  1,251,
/* 0x1080 */ 200,255, 33,251,208,255, 65,251,216,255, 97,251,224,255,129,251,
/* 0x1090 */ 232,255,161,251,240,255,193,251,248,255,225,251, 16,  0,  1,248,
/* 0x10a0 */  32,  0,128, 78,112,255,193,233,120,255,225,233,128,255,  1,234,
/* 0x10b0 */ 136,255, 33,234,144,255, 65,234,152,255, 97,234,160,255,129,234,
/* 0x10c0 */ 168,255,161,234,176,255,193,234,184,255,225,234,192,255,  1,235,
/* 0x10d0 */ 200,255, 33,235,208,255, 65,235,216,255, 97,235,224,255,129,235,
/* 0x10e0 */  16,  0,  1,232,232,255,161,235,166,  3,  8,124,240,255,193,235,
/* 0x10f0 */ 248,255,225,235, 32,  0,128, 78,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x1100 */ 120,255,225,249,112,255,193,249,  0,  0,  0, 56,  1,  0, 96, 57,
/* 0x1110 */ 152,255, 97,250,144,255, 65,250,  4,  0, 99, 58,248,255,225,251,
/* 0x1120 */ 240,255,193,251,  2,  0,227, 59,128,255,  1,250,136,255, 33,250,
/* 0x1130 */ 160,255,129,250,168,255,161,250,176,255,193,250,184,255,225,250,
/* 0x1140 */ 192,255,  1,251,200,255, 33,251,208,255, 65,251,216,255, 97,251,
/* 0x1150 */ 224,255,129,251,232,255,161,251,  0,  0, 67,137,  1,  0, 67,138,
/* 0x1160 */   2,  0, 35,138,  0,  0,  6,144,  0,  0,  9,144,180,  7, 79,125,
/* 0x1170 */  48,136,113,125, 48,144,107,125,255,255, 49, 58,255,255,107, 57,
/* 0x1180 */  32,  0, 49,122, 32,  0,114,121,  1,  0, 99,137, 20, 82,107,125,
/* 0x1190 */   0,  3, 64, 57, 48, 88, 74,125, 54,  7, 74, 57, 33,  0, 75,121,
/* 0x11a0 */  40,  0,130, 65,255,255, 75, 57,  0,  4, 96, 57, 32,  0, 74,121,
/* 0x11b0 */   1,  0, 74, 57,166,  3, 73,125,  0,  0,  0, 96,  0,  0,  0, 96,
/* 0x11c0 */   2,  0,127,181,252,255,  0, 66, 20, 42,164,124, 64, 40,164,127,
/* 0x11d0 */ 240,  2,158, 65,  4,  0,224, 59,  0,  0, 68,137,  1,  0,100, 57,
/* 0x11e0 */ 166,  3,233,127,  5,  0,132, 57, 64, 40,171,127, 46, 64, 74, 85,
/* 0x11f0 */   1,  0,107, 57,204,  2,158, 65,255,255, 11,136,120, 83, 10,124,
/* 0x1200 */  32,  0, 74,121,228,255,  0, 66,  0,  0,168, 47, 80, 11,158, 65,
/* 0x1210 */   1,  0,  0, 56,  1,  0, 96, 57, 96,255,  1,248, 88,255, 97,249,
/* 0x1220 */   8,  0, 15, 32,255,255,224, 59, 84,255,  1,144,255,  0, 32, 63,
/* 0x1230 */  32,  0,255,123,  1,  0,192, 57,  1,  0,  0, 58,  0,  0,160, 58,
/* 0x1240 */   0,  0, 96, 57,  0,  0,192, 58,255,255, 57, 99, 56,136,221,126,
/* 0x1250 */  54, 32,160, 86,180,  7,190,127,180,  7,  0,124, 20,  2,222,127,
/* 0x1260 */  64,200,159,127,164, 15,222,123, 36,  0,157, 65, 64, 40,172,127,
/* 0x1270 */  80,  2,158, 65,  0,  0, 12,136, 46, 64, 74, 85, 40, 64,255,123,
/* 0x1280 */   1,  0,140, 57,120, 83, 10,124, 32,  0, 74,121, 46,242,147,127,
/* 0x1290 */ 254,170,251, 87,214,225,123,127, 64,216,138,127, 32,  0, 96,123,
/* 0x12a0 */ 112,  2,156, 64, 84,255,225,131, 56,144,221,126,  6,  0,149, 47,
/* 0x12b0 */  48,120,189,127, 48,254,107,125,  0,  8,252, 35,112, 46,255,127,
/* 0x12c0 */  20,226,255,127, 20,234,107,125, 46,243,243,127, 46, 64,125, 85,
/* 0x12d0 */  42, 80,107, 85, 80, 88,189,127,  1,  0, 96, 57, 32,  0,189,123,
/* 0x12e0 */  54,  7,189, 59,164, 15,189,123, 20,234,179,127, 40,  1,157, 64,
/* 0x12f0 */  80,176,240,127,  1,  0, 96, 57, 32,  0,255,123,174,248, 71,127,
/* 0x1300 */  40,  0,  0, 72,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0, 96,
/* 0x1310 */  46,243,125,127,180,  7,107,125,120,251,224,127,172,  0,130, 64,
/* 0x1320 */ 255,  0,139, 47,172,  0,157, 65, 60,  8, 90, 87,238,  5, 95, 87,
/* 0x1330 */  60,  8,120, 85,180,  7,255,127,  0,  1,223, 59,  0,  0, 63, 44,
/* 0x1340 */  20, 90,222,127, 64,200,  0,127,  0,  0,128, 79,120,195, 11,127,
/* 0x1350 */  64, 40,172,124,  1,  0, 24, 59, 46, 64, 95, 85,164, 15,222,123,
/* 0x1360 */ 180,  7, 90,127, 28,  0,153, 65, 88,  1,134, 65,  0,  0, 76,137,
/* 0x1370 */  40, 64,  0,120,  1,  0,140, 57,120,251, 74,125, 32,  0, 74,121,
/* 0x1380 */  46,242,157,127,254,170, 27, 84,214,225,251,127,  0,  8,124, 35,
/* 0x1390 */ 126,217,151, 87,112, 46,123,127, 64,248, 10,127, 20,226,123,127,
/* 0x13a0 */  80,  0, 31,124, 80, 80,159,126, 80,224,151,127, 32,  0,255,123,
/* 0x13b0 */  96,255,152, 65, 46,243,157,127,180,  7, 11,127, 32,  0,  0,120,
/* 0x13c0 */  32,  0,138,122, 92,255,158, 64,255,  0,139, 47, 72,  0,253, 64,
/* 0x13d0 */  32,  6,107,121,  1,  0,214, 59,174,177,103,125,120,  3, 31,124,
/* 0x13e0 */  32,  0,214,123,  9,  0,149, 47,104,  8,157, 65,253,255,181, 58,
/* 0x13f0 */ 180,  7,181,126, 84,  6,  0, 72,  0,  0,  0, 96,  0,  0,  0, 96,
/* 0x1400 */ 180,  7,107,127,255,  0,139, 47, 46,227,221,127,120,211, 64,127,
/* 0x1410 */ 136,  0,157, 65, 60,  8,123, 85, 64,200,128,127, 64, 40, 44,127,
/* 0x1420 */ 120,219,120,127, 46, 64, 95, 85,164, 15,124,121, 28,  0,157, 65,
/* 0x1430 */ 144,  0,154, 65,  0,  0, 76,137, 40, 64,  0,120,  1,  0,140, 57,
/* 0x1440 */ 120,251, 74,125, 32,  0, 74,121, 46,226, 93,127,254,170, 31, 84,
/* 0x1450 */   1,  0,120, 57,214,209,255,127,  0,  8,218, 35,126,217, 88, 87,
/* 0x1460 */ 112, 46,222,127, 64,248,138,127, 80,208, 24,127, 20,210,222,127,
/* 0x1470 */  32,  0,250,123,140,255,156, 65,180,  7,107,125, 80,  0, 31,124,
/* 0x1480 */  80, 80, 95,125, 46,227, 29,127,255,  0,139, 47, 32,  0,  0,120,
/* 0x1490 */  32,  0, 74,121,128,255,157, 64,  1,  0,214, 59, 32,  6,107,121,
/* 0x14a0 */  32,  0,222,123,  3,  0,149, 47,174,177,103,125,120,  3, 31,124,
/* 0x14b0 */ 120,243,214,127, 48,255,157, 65,  0,  0,160, 58,140,  5,  0, 72,
/* 0x14c0 */   1,  0, 96, 56,112,255,193,233,120,255,225,233,128,255,  1,234,
/* 0x14d0 */ 136,255, 33,234,144,255, 65,234,152,255, 97,234,160,255,129,234,
/* 0x14e0 */ 168,255,161,234,176,255,193,234,184,255,225,234,192,255,  1,235,
/* 0x14f0 */ 200,255, 33,235,208,255, 65,235,216,255, 97,235,224,255,129,235,
/* 0x1500 */ 232,255,161,235,240,255,193,235,248,255,225,235, 32,  0,128, 78,
/* 0x1510 */  80,248, 27,124,126,217,159, 87, 80, 80,123,127, 80,224,255,127,
/* 0x1520 */ 192,  0,117, 57, 64,200,128,127, 46,243,243,127, 32,  0, 26,120,
/* 0x1530 */  32,  0,106,123,164, 15,107,121, 36,  0,157, 65, 64, 40,172,127,
/* 0x1540 */ 128,255,158, 65,  0,  0, 76,137, 46, 64,123, 87, 40, 64, 26,120,
/* 0x1550 */   1,  0,140, 57,120,219, 74,125, 32,  0, 74,121, 46, 90,115,127,
/* 0x1560 */ 254,170, 64, 87,214,217,  0,124, 64,  0,138,127, 32,  0, 28,120,
/* 0x1570 */  16,  3,156, 64,  0,  8, 27, 32,104,255,  1,250,  7,  0,149, 47,
/* 0x1580 */ 112, 46,  0,124, 20,218, 96,127,104,  6,  3, 59, 46, 91,115,127,
/* 0x1590 */  38, 16,176,126,254,239,181, 86,208,  0,181,126, 66,240,181,122,
/* 0x15a0 */   0, 16,181,122,  3,  0,181, 58, 64,200,156,127, 36,  0,157, 65,
/* 0x15b0 */  64, 40,172,127, 12,255,158, 65,  0,  0,108,137, 46, 64, 74, 85,
/* 0x15c0 */  40, 64,156,123,  1,  0,140, 57,120, 83,106,125, 32,  0, 74,121,
/* 0x15d0 */   0,  0, 24,160,254,170,139, 87,214,  1,107,125, 64, 88,138,127,
/* 0x15e0 */  32,  0,127,121,156,  4,156, 64, 56, 24,171, 87,  0,  8,192, 35,
/* 0x15f0 */ 180,  7,107,125,112, 46,222,127,  2,  0,107, 57, 20,  2, 30,124,
/* 0x1600 */ 164, 15,107,121,  0,  0, 24,176,  0,  0,128, 58, 20, 90, 24,127,
/* 0x1610 */   3,  0,224, 58,255,255,119, 57,  1,  0,  0, 56, 32,  0,107,121,
/* 0x1620 */   1,  0,107, 57,166,  3,105,125,  0,  0,  0, 96,  0,  0,  0, 96,
/* 0x1630 */ 164, 15, 28,120, 60,  8, 26, 84, 64,200,159,127, 64, 40, 44,127,
/* 0x1640 */ 120,211, 93,127, 46, 64, 75, 85, 20,226,152,127, 28,  0,157, 65,
/* 0x1650 */ 112,254,154, 65,  0,  0, 76,137, 40, 64,255,123,  1,  0,140, 57,
/* 0x1660 */ 120, 91, 74,125, 32,  0, 74,121,  0,  0,220,163,254,170,235, 87,
/* 0x1670 */   1,  0, 29, 56,214,241,107,125,  0,  8,190, 35,126,217,219, 87,
/* 0x1680 */ 112, 46,189,127, 64, 88,138,127, 80,240,123,127, 20,242,221,127,
/* 0x1690 */  32,  0,125,121,236,  2,156, 64,180,  7, 64,127,  0,  0,220,179,
/* 0x16a0 */ 120,235,191,127,140,255,  0, 66,  1,  0, 96, 57,  3,  0,149, 47,
/* 0x16b0 */  48,184,119,125, 80,160,247,126, 20,  2,247,126, 80,255,225,146,
/* 0x16c0 */  24,  3,157, 65,  3,  0,151, 47, 32,  0,235,122,148,  5,157, 65,
/* 0x16d0 */  50, 48,120, 85,180,  7, 24,127,  6,  0,  0, 56,176,  1, 24, 59,
/* 0x16e0 */ 166,  3,  9,124,164, 15, 24,123,  1,  0, 96, 57,  0,  0,  0, 96,
/* 0x16f0 */ 164, 15,124,121, 60,  8,119, 85, 64,200,159,127, 64, 40, 44,127,
/* 0x1700 */ 120,187,235,126, 46, 64, 64, 85, 20,194,156,127, 28,  0,157, 65,
/* 0x1710 */ 176,253,154, 65,  0,  0, 76,137, 40, 64,255,123,  1,  0,140, 57,
/* 0x1720 */ 120,  3, 74,125, 32,  0, 74,121, 46,226,211,127,254,170,224, 87,
/* 0x1730 */   1,  0,107, 57,214,241,  0,124,  0,  8,190, 35,126,217,219, 87,
/* 0x1740 */ 112, 46,189,127, 64,  0,138,127, 80,240,123,127, 20,242,221,127,
/* 0x1750 */  32,  0, 29,120, 76,  2,156, 64,180,  7,235,126, 46,227,211,127,
/* 0x1760 */ 120,235,191,127,140,255,  0, 66,192,255,107, 57,  3,  0,139, 47,
/* 0x1770 */ 180,  7,126,125, 76,  2,157, 64,254,  7,122, 85, 13,  0,139, 47,
/* 0x1780 */   2,  0, 90, 99,112, 14,107,125, 32,  0, 64,123, 48,  5,157, 65,
/* 0x1790 */ 255,255,107, 57,176,  2, 30, 34, 48, 88, 90,127,180,  7,107,125,
/* 0x17a0 */  20,210, 16,126,164, 15, 16,122,254,255, 16, 58, 20,130, 19,126,
/* 0x17b0 */ 255,255,107, 57,  1,  0,192, 59, 32,  0,107,121,  1,  0,128, 59,
/* 0x17c0 */   1,  0,107, 57,166,  3,105,125, 32,  0,  0, 72,  0,  0,  0, 96,
/* 0x17d0 */   0,  0, 27,176,180,  7,254,126,120,235,191,127, 60,  8,156, 87,
/* 0x17e0 */ 180,  7,156,127,224,  1, 64, 66,164, 15,219,123, 60,  8,215, 87,
/* 0x17f0 */  64,200,159,127, 64, 40, 44,127,120,187,254,126, 46, 64, 75, 85,
/* 0x1800 */  20,218,112,127, 28,  0,157, 65,184,252,154, 65,  0,  0, 76,137,
/* 0x1810 */  40, 64,255,123,  1,  0,140, 57,120, 91, 74,125, 32,  0, 74,121,
/* 0x1820 */   0,  0, 27,160,254,170,235, 87,120,211,148,127,214,  1,107,125,
/* 0x1830 */   0,  8,160, 35,126,217, 24, 84,112, 46,189,127, 64, 88,138,127,
/* 0x1840 */  80,  0, 24,127, 20,  2, 29,124, 32,  0,125,121,132,255,156, 65,
/* 0x1850 */  80,248,235,127, 80, 80, 75,125,  0,  0, 27,179,  1,  0,222, 59,
/* 0x1860 */  32,  0,255,123, 32,  0, 74,121,180,  7,222,127, 32,  0,154,122,
/* 0x1870 */ 108,255,255, 75,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0, 96,
/* 0x1880 */  80,208,224,127,126,217,124, 87, 80,216,124,127, 80, 80,  0,124,
/* 0x1890 */  64,200,159,127, 32,  0,250,123, 46, 91,115,127, 32,  0, 10,120,
/* 0x18a0 */  24,  0,139, 59, 36,  0,157, 65, 64, 40,172,127, 20,252,158, 65,
/* 0x18b0 */   0,  0, 76,137, 46, 64,  0, 84, 40, 64,250,123,  1,  0,140, 57,
/* 0x18c0 */ 120,  3, 74,125, 32,  0, 74,121, 46,226,243,127,254,170, 64, 87,
/* 0x18d0 */ 214,249,  0,124, 64,  0,138,127, 32,  0, 27,120, 52,  2,156, 64,
/* 0x18e0 */   0,  8,127, 33, 64,200,128,127,112, 46,107,125, 20,250,235,127,
/* 0x18f0 */ 224,  1,222, 59, 46,227,243,127, 36,  0,157, 65, 64, 40,172,127,
/* 0x1900 */ 192,251,158, 65,  0,  0,108,137, 46, 64, 74, 85, 40, 64, 27,120,
/* 0x1910 */   1,  0,140, 57,120, 83,106,125, 32,  0, 74,121, 46,242, 19,124,
/* 0x1920 */ 254,170,107, 87,214,  1,107,125, 64, 88,138,127, 32,  0,127,121,
/* 0x1930 */  56,  3,156, 64,  0,  8, 96, 33,  0,  0,182, 47,112, 46,107,125,
/* 0x1940 */  20,  2, 11,124, 46,243, 19,124,120,251,158, 65,  7,  0,149, 47,
/* 0x1950 */  80,176,112,125, 38, 16,176,126,254,239,181, 86, 32,  0,107,121,
/* 0x1960 */   1,  0, 22, 56,208,  0,181,126,164,  7,181,122,174, 88,103,125,
/* 0x1970 */ 174,177,103,125, 11,  0,181, 58, 32,  0, 22,120,204,  0,  0, 72,
/* 0x1980 */  80,248,235,127, 80, 80, 75,125,  0,  0,124,179, 32,  0,255,123,
/* 0x1990 */  32,  0, 74,121,180,  7,  0,124,152,252,  0, 66, 12,253,255, 75,
/* 0x19a0 */  80,248,224,127, 80, 80, 64,125, 46,227,115,127, 32,  0,255,123,
/* 0x19b0 */  32,  0, 74,121,180,  7,107,125, 56,253,  0, 66,172,253,255, 75,
/* 0x19c0 */  32,  0,122,121,  1,  0, 90, 59, 33,  0, 80,123,132,  0,130, 65,
/* 0x19d0 */   7,  0,181, 58,180,  7,181,126, 64,176,144,127,228,250,157, 65,
/* 0x19e0 */  80,255,  1,128,  1,  0,182, 59, 80,176,208,127, 32,  0,222,123,
/* 0x19f0 */ 120,179,220,126, 20,  2,125,125, 80, 88,112,125, 80, 88,126,125,
/* 0x1a00 */  32,  0,107,121,  1,  0,107, 57,166,  3,105,125, 20,  0,  0, 72,
/* 0x1a10 */ 120,179,220,126, 32,  0,222,123, 56,  0,157, 64,  1,  0,182, 59,
/* 0x1a20 */ 174,240,103,125, 64,232,136,127,  1,  0,222, 59, 32,  0,182,123,
/* 0x1a30 */ 174,225,103,125,220,255,  0, 66,104,255,  1,232, 96,255,193,249,
/* 0x1a40 */  88,255,193,233, 88,255,  1,248, 64,176,136,127,  0,248,253, 65,
/* 0x1a50 */ 255,  0, 64, 61,255,255, 74, 97, 64, 80,159,127, 16,  0,157, 65,
/* 0x1a60 */  64, 40,172,127, 92,250,158, 65,  1,  0,140, 57, 80, 96,132,124,
/* 0x1a70 */   0,  0, 96, 56,  0,  0,134,144,  0,  0,201,146, 72,250,255, 75,
/* 0x1a80 */  80,224,139,127,126,217, 31, 84, 80, 80,107,125, 80,  0, 31,124,
/* 0x1a90 */  64,200,156,127, 32,  0,158,123,  0,  0, 24,176, 32,  0,106,121,
/* 0x1aa0 */  36,  0,157, 65, 64, 40,172,127, 24,250,158, 65,  0,  0, 76,137,
/* 0x1ab0 */  46, 64,107, 85, 40, 64,158,123,  1,  0,140, 57,120, 91, 74,125,
/* 0x1ac0 */  32,  0, 74,121,  2,  0, 24,160,254,170,203, 87,214,  1,107,125,
/* 0x1ad0 */  64, 88,138,127, 32,  0,127,121, 72,  1,156, 64, 56, 24,171, 87,
/* 0x1ae0 */   0,  8,192, 35,180,  7,107,125,112, 46,222,127,130,  0,107, 57,
/* 0x1af0 */  20,  2, 30,124,164, 15,107,121,  2,  0, 24,176,  8,  0,128, 58,
/* 0x1b00 */  20, 90, 24,127,  3,  0,224, 58, 12,251,255, 75,  0,  0,  0, 96,
/* 0x1b10 */  80,208, 64,127,126,217,251, 87, 80, 80,192,127, 80,248,251,127,
/* 0x1b20 */  64,200,154,127, 46,227,243,127, 32,  0, 64,123, 32,  0,202,123,
/* 0x1b30 */  48,  0,235, 59, 36,  0,157, 65, 64, 40,172,127,132,249,158, 65,
/* 0x1b40 */   0,  0, 76,137, 46, 64,192, 87,  1,  0,140, 57,120,  3, 74,125,
/* 0x1b50 */  40, 64, 64,123, 32,  0, 74,121, 46,250,115,127,254,170, 30, 84,
/* 0x1b60 */ 214,217,222,127, 64,240,138,127, 32,  0,220,123, 44,  1,156, 65,
/* 0x1b70 */  80,  0, 30,124,126,217,124, 87, 80, 80,222,127, 80,216,156,127,
/* 0x1b80 */  64,200,128,127, 32,  0, 26,120, 46,251,147,127, 32,  0,202,123,
/* 0x1b90 */  72,  0,107, 57, 36,  0,157, 65, 64, 40,172,127, 36,249,158, 65,
/* 0x1ba0 */   0,  0, 76,137, 46, 64,222, 87, 40, 64, 26,120,  1,  0,140, 57,
/* 0x1bb0 */ 120,243, 74,125, 32,  0, 74,121, 46, 90,243,127,254,170, 64, 87,
/* 0x1bc0 */ 214,249,  0,124, 64,  0,138,127, 32,  0, 28,120,104,  1,156, 64,
/* 0x1bd0 */   0,  8, 31, 32,104,255,  1,250,120,115,208,125, 96,255,193,233,
/* 0x1be0 */ 112, 46,  0,124, 20,250,224,127, 46, 91,243,127,  0,  0,  0, 96,
/* 0x1bf0 */   7,  0,149, 47,108, 10,  3, 59, 38, 16,176,126,254,239,181, 86,
/* 0x1c00 */ 208,  0,181,126, 66,240,181,122,  0, 16,181,122, 11,  0,181, 58,
/* 0x1c10 */ 152,249,255, 75,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0, 96,
/* 0x1c20 */ 126,217, 31, 84, 80,  0, 31,124, 80, 80, 75,125, 80,240,235,127,
/* 0x1c30 */   2,  0, 24,176, 32,  0, 74,121,  4,  2, 24, 59, 32,  0,255,123,
/* 0x1c40 */  16,  0,128, 58,  8,  0,224, 58,204,249,255, 75,  0,  0,  0, 96,
/* 0x1c50 */ 250,255,181, 58,180,  7,181,126,240,253,255, 75,  0,  0,  0, 96,
/* 0x1c60 */   3,  0, 96, 57,108,250,255, 75,126,217, 31, 84, 80,216,139,127,
/* 0x1c70 */  80, 80, 75,125, 88,255, 97,233, 88,255,193,249, 80,  0, 31,124,
/* 0x1c80 */ 104,255, 97,249, 32,  0,156,123, 96,255,193,233, 32,  0, 74,121,
/* 0x1c90 */  46,243, 19,124, 92,255,255, 75,  0,  8,123, 33,104,255,  1,250,
/* 0x1ca0 */  88,255,  1,234,112, 46,107,125, 20,218,107,127, 88,255,193,249,
/* 0x1cb0 */  96,255,193,233, 46,251,115,127, 56,255,255, 75,250,255,107, 57,
/* 0x1cc0 */  32,  0,107,121,  1,  0,107, 57,166,  3,105,125,  0,  0,  0, 96,
/* 0x1cd0 */  64,200,159,127, 60,  8, 26, 84, 64, 40, 44,127, 46, 64, 75, 85,
/* 0x1ce0 */  28,  0,157, 65,220,247,154, 65,  0,  0, 76,137, 40, 64,255,123,
/* 0x1cf0 */   1,  0,140, 57,120, 91, 74,125, 32,  0, 74,121,126,248,235, 87,
/* 0x1d00 */  64, 88,138,127, 32,  0, 64,123, 32,  0,127,121, 20,  0,156, 65,
/* 0x1d10 */  80, 80, 75,125,  1,  0, 90, 99, 32,  0, 74,121, 32,  0, 64,123,
/* 0x1d20 */ 176,255,  0, 66, 72,  6,  3, 58, 40, 32, 26,120,  4,  0, 96, 57,
/* 0x1d30 */ 128,250,255, 75,126,217,254, 87, 80,248,254,127, 80,208,128,127,
/* 0x1d40 */ 104,255,  1,250, 96,255,  1,234, 80, 80, 64,125, 46, 91,243,127,
/* 0x1d50 */  32,  0,156,123, 32,  0, 74,121,152,254,255, 75,  0,  0,192, 58,
/* 0x1d60 */  12,253,255, 75,  0,  0,  0,  0,  0,  0,  0,  0, 85, 80, 88, 33,
/* 0x1d70 */ 161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1d80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,108,101,
/* 0x1d90 */  32,102,111,114,109, 97,116, 32,101,108,102, 54, 52, 45,112,111,
/* 0x1da0 */ 119,101,114,112, 99,108,101, 10, 10, 83,101, 99,116,105,111,110,
/* 0x1db0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x1dc0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x1dd0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1de0 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1df0 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x1e00 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 73, 78,
/* 0x1e10 */  85, 88, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48,
/* 0x1e20 */  32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1e30 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 76, 73, 78,
/* 0x1e40 */  85, 88, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48,
/* 0x1e50 */  32, 32, 48, 32, 32, 48, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1e60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 76, 73, 78,
/* 0x1e70 */  85, 88, 48, 50, 48, 32, 32, 32, 32, 32, 32, 48, 54, 52, 32, 32,
/* 0x1e80 */  48, 32, 32, 48, 32, 32, 48, 53, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x1e90 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 76, 73,
/* 0x1ea0 */  78, 85, 88, 48, 51, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x1eb0 */  32, 32, 48, 32, 32, 48, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1ec0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82, 86,
/* 0x1ed0 */  50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,102, 56, 32, 32,
/* 0x1ee0 */  48, 32, 32, 48, 32, 32, 48, 98, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1ef0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 78, 82,
/* 0x1f00 */  86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 51, 99,
/* 0x1f10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 32, 32, 50, 42,
/* 0x1f20 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54,
/* 0x1f30 */  32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1f40 */  49, 53, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,101, 56, 32,
/* 0x1f50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1f60 */  32, 32, 55, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32,
/* 0x1f70 */  32, 32, 48, 49, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 51,
/* 0x1f80 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1f90 */  83, 10, 32, 32, 56, 32, 67, 70, 76, 85, 83, 72, 32, 32, 32, 32,
/* 0x1fa0 */  32, 32, 32, 32, 48, 50, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1fb0 */  52, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1fc0 */  78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 32, 32, 32, 32,
/* 0x1fd0 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1fe0 */  52, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1ff0 */  78, 84, 83, 10, 32, 49, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x2000 */  48, 48, 32, 32, 32, 32, 48, 97, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x2010 */  32, 48, 52, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2020 */  84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 68,
/* 0x2030 */  69, 67, 51, 48, 32, 32, 32, 32, 48, 50, 99, 32, 32, 48, 32, 32,
/* 0x2040 */  48, 32, 32, 48, 53, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2050 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 76, 90, 77, 65,
/* 0x2060 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 98, 56, 32, 32,
/* 0x2070 */  48, 32, 32, 48, 32, 32, 48, 53, 52, 56, 32, 32, 50, 42, 42, 48,
/* 0x2080 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 76,
/* 0x2090 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 99, 54,
/* 0x20a0 */  99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 48, 48, 32, 32,
/* 0x20b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x20c0 */  49, 52, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x20d0 */  32, 48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,100, 54,
/* 0x20e0 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x20f0 */  83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,
/* 0x2100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2110 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 50,
/* 0x2120 */  48, 32, 48, 32, 76, 73, 78, 85, 88, 48, 50, 48, 10, 48, 48, 48,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2140 */  32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48, 32, 48,
/* 0x2150 */  32, 76, 73, 78, 85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2170 */ 100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82,
/* 0x2180 */  86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x21a0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77,
/* 0x21b0 */  65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x21d0 */  32, 76, 73, 78, 85, 88, 48, 48, 48, 32, 48, 32, 76, 73, 78, 85,
/* 0x21e0 */  88, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73,
/* 0x2200 */  78, 85, 88, 48, 49, 48, 32, 48, 32, 76, 73, 78, 85, 88, 48, 49,
/* 0x2210 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,
/* 0x2230 */  32, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2240 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2250 */  32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10,
/* 0x2260 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2270 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48,
/* 0x2280 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2290 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x22a0 */  67, 70, 76, 85, 83, 72, 32, 48, 32, 67, 70, 76, 85, 83, 72, 10,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22c0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 32, 48, 32,
/* 0x22d0 */  76, 90, 77, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22e0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x22f0 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x2300 */  69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2310 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x2320 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x2330 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2340 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2350 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77,
/* 0x2360 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2370 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2380 */  32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 48, 32, 85, 80, 88, 49,
/* 0x2390 */  72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23a0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x23b0 */  78, 68, 42, 32, 48, 32,102,105,108,116,101,114, 95,108,101,110,
/* 0x23c0 */ 103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23d0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x23e0 */  68, 42, 32, 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10,
/* 0x23f0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2400 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 48,
/* 0x2410 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x2420 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x2430 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x2440 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,
/* 0x2450 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x2460 */  76, 73, 78, 85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2470 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x2480 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 76, 73, 78, 85,
/* 0x2490 */  88, 48, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x24a0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73,
/* 0x24b0 */  78, 85, 88, 48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x24c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x24d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x24e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24f0 */  48, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 65, 68, 68, 82, 51,
/* 0x2500 */  50, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,
/* 0x2510 */ 116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2520 */  48, 48, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 65, 68, 68, 82,
/* 0x2530 */  51, 50, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111,
/* 0x2540 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x2550 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93,
/* 0x2560 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2570 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2580 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 56, 32, 82, 95, 80, 80,
/* 0x25a0 */  67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82,
/* 0x25b0 */  86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x25c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x25d0 */  78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x25e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x25f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x2600 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x2610 */  52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32,
/* 0x2620 */  32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69,
/* 0x2630 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2640 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70,
/* 0x2650 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x2660 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2670 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x2690 */  82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65,
/* 0x26a0 */  73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x26b0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65,
/* 0x26c0 */  95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x26d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x26e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x26f0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2700 */  48, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52,
/* 0x2710 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43,
/* 0x2720 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2730 */  50, 99, 10
};
