# 相機|deepin-camera|

## 概述

相機是一款簡單易用的鏡頭應用工具，可實現拍照、錄製影片等功能，支持多鏡頭切換。

## 使用入門

您可以通過以下方式運行或關閉相機，或者創建快捷方式。

### 運行相機

1. 單擊任務欄上的啟動器圖標 ![deepin_launcher](../common/deepin_launcher.svg)，進入啟動器界面。
2. 上下滾動鼠標滾輪瀏覽或通過搜索找到，相機圖標 ![camera](../common/camera.svg)，單擊運行。
3. 右鍵單擊 ![camera](../common/camera.svg)，您可以：
   - 單擊 **傳送到桌面**，在桌面創建快捷方式。
   - 單擊 **傳送到任務欄**，將應用程序固定到任務欄。
   - 單擊 **加至開機啟動**，將應用程序添加到開機啟動項，在電腦開機時自動運行該應用程序。

### 關閉相機

- 在相機界面單擊 ![close](../common/close.svg)，退出相機。
- 在任務欄右鍵單擊 ![camera](../common/camera.svg)，選擇 **關閉所有** 來退出相機。
- 在相機界面，單擊 ![icon_menu](../common/icon_menu.svg)，選擇 **退出** 來退出相機。

## 圖標介紹

<table class="block1">
    <tbody>
        <tr>
            <td><img src="../common/photograph.png" alt="拍照" class="inline" /></td>
            <td>拍照</td>
            <td><img src="../common/record.png" alt="影片" class="inline" /></td>
            <td>影片</td>
            <td><img src="../common/switch.png" alt="切換鏡頭" class="inline" /></td>
            <td>切換鏡頭</td>
        </tr>
        <tr>
            <td><img src="../common/more.png" alt="展開" class="inline" /></td>
            <td>展開工具欄</td>
            <td><img src="../common/fold.png" alt="摺疊" class="inline" /></td>
            <td>摺疊工具欄</td>
            <td><img src="../common/delay.png" alt="延時" class="inline" /></td>
            <td>延時拍攝</td>
       </tr>   
       <tr>
            <td><img src="../common/flashlight.png" alt="閃光燈" class="inline" /></td>
            <td>開啟閃光燈</td>
            <td><img src="../common/filter.png" alt="濾鏡" class="inline" /></td>
            <td>設置濾鏡</td>
            <td><img src="../common/exposure.png" alt="曝光" class="inline" /></td>
            <td>調節曝光度</td>
        </tr>
    </tbody>
</table>

> ![notes](../common/notes.svg) 說明：當連接多個鏡頭時，界面上才會顯示切換鏡頭按鈕 ![icon](../common/switch.png)。


## 操作介紹

使用相機的前提是電腦自帶鏡頭或外接鏡頭。打開相機後，單擊 **拍照** 或 **影片** 切換模式，您還可以在 **設置 > 拍照設置** 中開啟鏡像鏡頭功能，將畫面左右翻轉。

### 拍照

打開相機後，默認進入拍照模式。單擊拍照按鈕 ![photograph](../common/photograph.png)，拍攝的圖片文件會展示在界面。

<img src="fig/image.png" alt="image" style="zoom:80%;" />


### 錄製影片 

在相機主界面，單擊 **影片**，進入影片模式。單擊錄製影片按鈕 ![transcribe](../common/record.svg) 進行錄製，錄製完成後單擊結束錄製按鈕 ![stop](../common/stop.svg)，影片文件會展示在界面，也會保存在默認路徑下。

<img src="fig/video.png" alt="video" style="zoom:80%;" />

### 管理圖片/影片

在相機主界面，右鍵單擊照片或影片文件，可選擇複製、刪除或打開文件夾。

- 複製：將選中的照片複製到其他路徑。
- 刪除：將選中的照片刪除。
- 打印：將選中的圖片進行打印。單擊 **打印** 後，跳轉到打印預覽界面，您可以進行相關設置後再打印。

   > ![notes](../common/notes.svg) 說明：僅圖片文件支持打印功能，影片文件不會顯示打印按鈕。
- 打開文件夾：打開照片或影片所在的文件夾。

<img src="fig/right_menu.png" alt="right_menu" style="zoom:80%;" />

## 主菜單

在主菜單中，您可以進行相機設置、切換窗口主題，查看幫助手冊等操作。

### 設置

1. 在相機界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **設置**，您可以進行基本設置、拍照設置及輸出設置。

   - 基本設置：設置照片和影片的默認存儲路徑，選擇構圖網格的樣式。
   - 拍照設置：設置音效、連拍次數及拍照延時時間，開啟或關閉鏡像鏡頭、閃光燈。
   - 輸出設置：顯示圖片和影片的輸出格式，設置輸出解像度。

### 主題

窗口主題包含淺色主題、深色主題和系統主題。

1. 在相機界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **主題**，選擇一個主題顏色。

### 幫助

1. 在相機界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **幫助**，查看幫助手冊，進一步了解和使用相機。

### 關於

1. 在相機界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **關於**，查看相機的版本和介紹。

### 退出

1. 在相機界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **退出**。

