/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "FileObject.h"
#include "IconFactory.h"
#include "Request.h"

FileObject::FileObject(Folder* parent,const IconClass& kind,
	const string& name,IconInfo* info):
	IconObject(parent,kind,name,info)
{
}

FileObject::~FileObject()
{
}

void FileObject::doubleClick()
{
	edit();
}

set<string> FileObject::can()
{
    return IconObject::can();
}

void FileObject::createFiles()
{
	IconObject::createFiles();
	Path p = path();
	if(!link_ && !p.exists()) 
		p.touch();
}

Request FileObject::request() const
{
	const char* n = className().c_str();
	Request r(n);
	r("PATH") = path().str().c_str();
	return r;
}

void FileObject::request(const Request& /*r*/)
{
	//IconObject::request(r);
}

static IconMaker<FileObject> maker1("File");
