/*************************************************************
 *   mpgtx an mpeg toolbox                                   *
 *   by Laurent Alacoque <laureck@users.sourceforge.net>     *
 *   (c) 2001                                                *
 *   You may copy, modify and redistribute this              *
 *   source file under the terms of the GNU Public License   *
 ************************************************************/

#ifndef __id3command_hh_
#define __id3command_hh_

#include <stdio.h>
#include <string.h>
#include "common.hh"

// needed by move
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
//for the home dir
#include <pwd.h>
// end needed

bool id3_Show_Only =false;

/**
 * ID3v1 TAG with additional character for each string termination
 */
typedef struct {
	char title [31];
	char artist [31];
	char album  [31];
	char year   [5];
	char comment [31];
	int track;
	unsigned char genre;
} myID3tag;

#define NOT_MP3 0
#define REAL_MP3 1
#define FAKE_MP3 2

typedef struct {
	FILE* 		thefile;
	myID3tag* 	thetag;
	int		filetype;
} OpenedFile;

int ParseID3Command(int argc, char** argv, int argc_offset);
int ParseShow(int argc, char** argv, int argc_offset);
int ParseSet(int argc, char** argv, int argc_offset);
int ParseMov(int argc, char** argv, int argc_offset);
int ParseDel(int argc, char** argv, int argc_offset);
// include for ParseDel()
#ifdef _WIN32
// windows version
// del mode is not implemented under windows
#else
#include <unistd.h>
#endif

OpenedFile* OpenFile(char* FileName);

bool SetID3(char* format,OpenedFile* tag);
void WriteID3(OpenedFile* filename);
bool AskDirCreation(char* path);
void Move2(const char* name,const char* basedir,const char* dest);

#endif // __id3command_hh_
