/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.CleanUpAction;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public class AllCleanUpsAction
extends CleanUpAction {
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;

    public AllCleanUpsAction(IWorkbenchSite site) {
        super(site);
        this.setToolTipText(ActionMessages.CleanUpAction_tooltip);
        this.setDescription(ActionMessages.CleanUpAction_description);
        this.installPreferenceListener();
        this.updateActionLabel();
    }

    public AllCleanUpsAction(JavaEditor editor) {
        super(editor);
        this.setToolTipText(ActionMessages.CleanUpAction_tooltip);
        this.setDescription(ActionMessages.CleanUpAction_description);
        this.installPreferenceListener();
        this.updateActionLabel();
    }

    @Override
    protected ICleanUp[] createCleanUps(IJavaScriptUnit[] units) {
        return CleanUpRefactoring.createCleanUps();
    }

    @Override
    protected String getActionName() {
        return ActionMessages.CleanUpAction_actionName;
    }

    @Override
    protected void performRefactoring(IJavaScriptUnit[] cus, ICleanUp[] cleanUps) throws JavaScriptModelException, InvocationTargetException {
        RefactoringExecutionStarter.startCleanupRefactoring(cus, cleanUps, this.getShell(), this.showWizard(), this.getActionName());
    }

    private boolean showWizard() {
        InstanceScope instanceScope = new InstanceScope();
        IEclipsePreferences instanceNode = instanceScope.getNode("org.eclipse.wst.jsdt.ui");
        if (instanceNode.get("cleanup.showwizard", null) != null) {
            return instanceNode.getBoolean("cleanup.showwizard", true);
        }
        DefaultScope defaultScope = new DefaultScope();
        IEclipsePreferences defaultNode = defaultScope.getNode("org.eclipse.wst.jsdt.ui");
        return defaultNode.getBoolean("cleanup.showwizard", true);
    }

    private void updateActionLabel() {
        if (this.showWizard()) {
            this.setText(ActionMessages.CleanUpAction_labelWizard);
        } else {
            this.setText(ActionMessages.CleanUpAction_label);
        }
    }

    private void installPreferenceListener() {
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("cleanup.showwizard")) {
                    AllCleanUpsAction.this.updateActionLabel();
                }
            }
        };
        new InstanceScope().getNode("org.eclipse.wst.jsdt.ui").addPreferenceChangeListener(this.fPreferenceChangeListener);
    }

    public void dispose() {
        if (this.fPreferenceChangeListener != null) {
            new InstanceScope().getNode("org.eclipse.wst.jsdt.ui").removePreferenceChangeListener(this.fPreferenceChangeListener);
            this.fPreferenceChangeListener = null;
        }
    }
}

