/*
 * Decompiled with CFR 0.152.
 */
package ms.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import ms.configuration.services.cs.CsConfigurationServices;
import ms.design.AbstractDNodeScope;
import ms.design.CSConfigurationStyle;
import ms.design.CSSRefreshExtension;
import ms.design.DNodeContainerScope;
import ms.design.DNodeScope;
import ms.design.DefaultScope;
import ms.design.DiagramScope;
import ms.design.Scope;
import ms.design.ScopeVisitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.vp.ms.CSConfiguration;

public class ConfigurationScopeVisitor
implements ScopeVisitor<Collection<CSConfiguration>> {
    private static final CsConfigurationServices cs = new CsConfigurationServices();
    private final CSSRefreshExtension css;
    private static final String KEY_CONFIGURATIONS = "vpms_Configurations";
    private static final String KEY_ALL_CONFIGURATIONS = "vpms_AllConfigurations";

    public ConfigurationScopeVisitor(CSSRefreshExtension css) {
        this.css = css;
    }

    @Override
    public Collection<CSConfiguration> visitDiagramScope(DiagramScope ds) {
        this.updateConfigurationsAttribute(ds, cs.getSelectedConfigurations((DSemanticDiagram)ds.getElement()));
        return this.getAllParentScopeConfigurations(ds);
    }

    @Override
    public Collection<CSConfiguration> visitAbstracDNodeScope(AbstractDNodeScope asd) {
        this.updateConfigurationsAttribute(asd, cs.getSelectedConfigurations((AbstractDNode)asd.getElement(), false));
        this.updateStyle(asd);
        return this.getAllParentScopeConfigurations(asd);
    }

    @Override
    public Collection<CSConfiguration> visitDNodeContainerScope(DNodeContainerScope dns) {
        return this.visitAbstracDNodeScope(dns);
    }

    @Override
    public Collection<CSConfiguration> visitDNodeScope(DNodeScope dns) {
        return this.visitAbstracDNodeScope(dns);
    }

    protected void updateStyle(AbstractDNodeScope asd) {
        this.updateStyle((DDiagramElement)asd.getElement(), this.getAllParentScopeConfigurations(asd));
    }

    @Override
    public Collection<CSConfiguration> visitDefaultScope(DefaultScope ds) {
        return Collections.emptyList();
    }

    private void updateConfigurationsAttribute(Scope scope, Collection<CSConfiguration> local) {
        scope.setAttribute(KEY_CONFIGURATIONS, Collections.unmodifiableCollection(local));
        ArrayList<CSConfiguration> allConfigurations = new ArrayList<CSConfiguration>(local);
        if (scope.getParentScope() != null) {
            allConfigurations.addAll((Collection)scope.getParentScope().getAttribuge(KEY_ALL_CONFIGURATIONS));
        }
        scope.setAttribute(KEY_ALL_CONFIGURATIONS, Collections.unmodifiableCollection(allConfigurations));
    }

    protected Collection<CSConfiguration> getAllParentScopeConfigurations(Scope scope) {
        if (scope.getParentScope() != null) {
            return this.getAllScopeConfigurations(scope.getParentScope());
        }
        return Collections.emptyList();
    }

    protected Collection<CSConfiguration> getAllScopeConfigurations(Scope scope) {
        return (Collection)scope.getAttribuge(KEY_ALL_CONFIGURATIONS);
    }

    protected void updateStyle(DDiagramElement element, Collection<CSConfiguration> appliedConfigurations) {
        CSConfigurationStyle style = this.css.getCSConfigurationStyle((EObject)element).clear();
        EObject target = this.getTarget(element);
        this.updateStyle(style, target, appliedConfigurations);
    }

    protected void updateStyle(CSConfigurationStyle style, EObject semantic, Collection<CSConfiguration> appliedConfigurations) {
        if (semantic != null) {
            for (CSConfiguration c : appliedConfigurations) {
                if (!c.getScope().contains((Object)semantic)) continue;
                if (c.includes((ModelElement)semantic)) {
                    style.addClass("included");
                    continue;
                }
                style.addClass("excluded");
            }
        }
    }

    protected EObject getTarget(DDiagramElement e) {
        EObject semanticTarget = e.getTarget();
        if (semanticTarget instanceof Part) {
            semanticTarget = ((Part)semanticTarget).getType();
            return semanticTarget;
        }
        return semanticTarget;
    }
}

