/*
 * Decompiled with CFR 0.152.
 */
package ms.design;

import java.util.ArrayDeque;
import ms.design.AbstractMsRefreshExtension;
import ms.design.CSConfigurationStyle;
import ms.design.CSSRefreshExtension;
import ms.design.ConfigurationScopeVisitor;
import ms.design.Scope;
import ms.design.ScopeFactory;
import ms.design.ScopeVisitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;

public class DefaultMsRefreshExtension
extends AbstractMsRefreshExtension {
    DefaultMsRefreshExtension(CSSRefreshExtension css) {
        super(css);
    }

    protected ScopeFactory createScopeFactory() {
        return new ScopeFactory();
    }

    protected ScopeVisitor<?> createVisitor() {
        return new ConfigurationScopeVisitor(this.css);
    }

    protected void refreshNodes(DDiagram dDiagram) {
        ScopeFactory scopeFactory = this.createScopeFactory();
        ScopeVisitor<?> visitor = this.createVisitor();
        ArrayDeque<Scope> remaining = new ArrayDeque<Scope>();
        remaining.push((Scope)scopeFactory.doSwitch((EObject)dDiagram));
        while (!remaining.isEmpty()) {
            Scope scope = (Scope)remaining.pop();
            scope.accept(visitor);
            scopeFactory.setParent(scope);
            for (DDiagramElement dDiagramElement : scope.getChildren()) {
                if (dDiagramElement instanceof DEdge) continue;
                remaining.push((Scope)scopeFactory.doSwitch((EObject)dDiagramElement));
            }
        }
    }

    protected void refreshEdges(DDiagram dDiagram) {
        for (DEdge edge : dDiagram.getEdges()) {
            CSConfigurationStyle style = this.getCSConfigurationStyle((DDiagramElement)edge);
            style.clear();
            for (String clazz : this.getCSConfigurationStyle((DDiagramElement)edge.getTargetNode()).getStyle()) {
                style.addClass(clazz);
            }
            for (String clazz : this.getCSConfigurationStyle((DDiagramElement)edge.getSourceNode()).getStyle()) {
                style.addClass(clazz);
            }
        }
    }

    public void postRefresh(DDiagram dDiagram) {
        this.refreshNodes(dDiagram);
        this.refreshEdges(dDiagram);
    }

    @Override
    public void beforeRefresh(DDiagram dDiagram) {
    }
}

