/*
 * Decompiled with CFR 0.152.
 */
package ms.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ms.design.AbstractDNodeScope;
import ms.design.CSConfigurationStyle;
import ms.design.CSSRefreshExtension;
import ms.design.ConfigurationScopeVisitor;
import ms.design.DNodeScope;
import ms.design.DefaultMsRefreshExtension;
import ms.design.Scope;
import ms.design.ScopeVisitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.sequence.description.EndOfLifeMapping;
import org.eclipse.sirius.diagram.sequence.description.ExecutionMapping;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.interaction.services.SequenceMessageExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.vp.ms.CSConfiguration;

public class ScenarioMsRefreshExtension
extends DefaultMsRefreshExtension {
    ScenarioMsRefreshExtension(CSSRefreshExtension css) {
        super(css);
    }

    @Override
    protected ScopeVisitor<?> createVisitor() {
        return new ConfigurationScopeVisitor(this.css){
            Map<DEdge, Scope> rememberedEdgeScopes;
            {
                this.rememberedEdgeScopes = new HashMap<DEdge, Scope>();
            }

            @Override
            public Collection<CSConfiguration> visitAbstracDNodeScope(AbstractDNodeScope asd) {
                Object result = super.visitAbstracDNodeScope(asd);
                AbstractDNode node = (AbstractDNode)asd.getElement();
                if (node instanceof EdgeTarget) {
                    for (DEdge edge : ((EdgeTarget)node).getOutgoingEdges()) {
                        this.updateEdgeStyle(asd, edge, true);
                    }
                    for (DEdge edge : ((EdgeTarget)node).getIncomingEdges()) {
                        this.updateEdgeStyle(asd, edge, false);
                    }
                }
                return result;
            }

            @Override
            public Collection<CSConfiguration> visitDNodeScope(DNodeScope dns) {
                DNode node = (DNode)dns.getElement();
                if (!(node.getActualMapping() instanceof EndOfLifeMapping)) {
                    return this.visitAbstracDNodeScope(dns);
                }
                return Collections.emptyList();
            }

            @Override
            protected EObject getTarget(DDiagramElement e) {
                if (e.getTarget() instanceof StateFragment) {
                    return ((StateFragment)e.getTarget()).getRelatedAbstractFunction();
                }
                if (e.getTarget() instanceof InstanceRole) {
                    return ((InstanceRole)e.getTarget()).getRepresentedInstance().getType();
                }
                return super.getTarget(e);
            }

            private void updateFunctionalExchangeStyle(DEdge edge, FunctionalExchange fe, Scope fipScope, Scope fopScope) {
                this.updateExchangeStyle(edge, fipScope, (EObject)fe.getTargetFunctionInputPort(), fopScope, (EObject)fe.getSourceFunctionOutputPort());
            }

            private void updateExchangeStyle(DEdge edge, Scope inScope, EObject inScopeTarget, Scope outScope, EObject outScopeTarget) {
                CSConfigurationStyle style = ScenarioMsRefreshExtension.this.getCSConfigurationStyle((DDiagramElement)edge).clear();
                this.updateStyle(style, outScopeTarget, this.getAllScopeConfigurations(outScope));
                this.updateStyle(style, inScopeTarget, this.getAllScopeConfigurations(inScope));
                this.applyExecutionStyleFromEdge(edge, style);
            }

            private void applyExecutionStyleFromEdge(DEdge edge, CSConfigurationStyle style) {
                if (edge.getTargetNode() instanceof DDiagramElement && ((DDiagramElement)edge.getTargetNode()).getMapping() instanceof ExecutionMapping) {
                    CSConfigurationStyle execStyle = ScenarioMsRefreshExtension.this.getCSConfigurationStyle((DDiagramElement)edge.getTargetNode()).clear();
                    for (String s : style.getStyle()) {
                        execStyle.addClass(s);
                    }
                }
            }

            private void updateComponentExchangeStyle(DEdge edge, ComponentExchange ce, Scope inScope, Scope outScope) {
                this.updateExchangeStyle(edge, inScope, (EObject)ce.getTargetPort(), outScope, (EObject)ce.getSourcePort());
            }

            private void updateEdgeStyle(AbstractDNodeScope thisScope, DEdge edge, boolean outgoing) {
                Scope opposite;
                if (edge.getTarget() instanceof SequenceMessage && (opposite = this.getOppositeScope(edge, thisScope)) != null) {
                    Scope out;
                    AbstractEventOperation op = SequenceMessageExt.getOperation((SequenceMessage)((SequenceMessage)edge.getTarget()));
                    Scope in = outgoing ? opposite : thisScope;
                    Scope scope = out = outgoing ? thisScope : opposite;
                    if (op instanceof FunctionalExchange) {
                        this.updateFunctionalExchangeStyle(edge, (FunctionalExchange)op, in, out);
                    } else if (op instanceof ComponentExchange) {
                        this.updateComponentExchangeStyle(edge, (ComponentExchange)op, in, out);
                    } else if (op instanceof ExchangeItemAllocation) {
                        this.updateExchangeItemAllocationStyle(edge, (ExchangeItemAllocation)op, in, out);
                    }
                }
            }

            private void updateExchangeItemAllocationStyle(DEdge edge, ExchangeItemAllocation op, Scope in, Scope out) {
                CSConfigurationStyle style = ScenarioMsRefreshExtension.this.getCSConfigurationStyle((DDiagramElement)edge).clear();
                SequenceMessage msg = (SequenceMessage)edge.getTarget();
                Classifier sender = (Classifier)msg.getSendingPart().getType();
                for (ComponentPort port : this.getRequiringPorts((Collection<Feature>)sender.getOwnedFeatures(), op.getAllocatingInterface())) {
                    this.updateStyle(style, (EObject)port, this.getAllScopeConfigurations(out));
                }
                Classifier receiver = (Classifier)msg.getReceivingPart().getType();
                for (ComponentPort port : this.getProvidingPorts((Collection<Feature>)receiver.getOwnedFeatures(), op.getAllocatingInterface())) {
                    this.updateStyle(style, (EObject)port, this.getAllScopeConfigurations(in));
                }
                this.applyExecutionStyleFromEdge(edge, style);
            }

            private Collection<ComponentPort> getRequiringPorts(Collection<Feature> features, Interface iface) {
                ArrayList<ComponentPort> requiringPorts = new ArrayList<ComponentPort>();
                for (Feature feature : features) {
                    if (!(feature instanceof ComponentPort) || !((ComponentPort)feature).getRequiredInterfaces().contains((Object)iface)) continue;
                    requiringPorts.add((ComponentPort)feature);
                }
                return requiringPorts;
            }

            private Collection<ComponentPort> getProvidingPorts(Collection<Feature> features, Interface iface) {
                ArrayList<ComponentPort> providingPorts = new ArrayList<ComponentPort>();
                for (Feature feature : features) {
                    if (!(feature instanceof ComponentPort) || !((ComponentPort)feature).getProvidedInterfaces().contains((Object)iface)) continue;
                    providingPorts.add((ComponentPort)feature);
                }
                return providingPorts;
            }

            private Scope getOppositeScope(DEdge edge, Scope thisScope) {
                Scope otherEnd = this.rememberedEdgeScopes.remove(edge);
                if (otherEnd == null) {
                    this.rememberedEdgeScopes.put(edge, thisScope);
                }
                return otherEnd;
            }
        };
    }

    @Override
    public void postRefresh(DDiagram dDiagram) {
        this.refreshNodes(dDiagram);
    }
}

