/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;

@ServiceProvider(value="Services available for Booleans. See [document examples](https://github.com/ObeoNetwork/M2Doc/tree/master/tests/org.obeonetwork.m2doc.tests/resources/booleanServices).")
public class BooleanServices {
    @Documentation(value="Returns \"X\" for boolean true.", params={@Param(name="value", value="The boolean value")}, result="\"X\" when the boolean value is true, \"\" otherwise.", examples={@Example(expression="true.check()", result="X"), @Example(expression="false.check()", result="")})
    public String check(boolean value) {
        String res = value ? "X" : "";
        return res;
    }

    @Documentation(value="Returns \"Yes\" for boolean true, \"No\" otherwise.", params={@Param(name="value", value="The boolean value")}, result="\"Yes\" when the boolean value is true, \"No\" otherwise.", examples={@Example(expression="true.yesNo()", result="Yes"), @Example(expression="false.yesNo()", result="No")})
    public String yesNo(boolean value) {
        String res = value ? "Yes" : "No";
        return res;
    }
}

