/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class FeatureImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "FeatureImportWizard";
    private FeatureImportWizardPage fPage;

    public FeatureImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_IMPORT_WIZ);
        this.setWindowTitle(PDEUIMessages.FeatureImportWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setNeedsProgressMonitor(false);
        this.fPage = new FeatureImportWizardPage();
        this.addPage((IWizardPage)this.fPage);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        IFeatureModel[] models = this.fPage.getSelectedModels();
        this.fPage.storeSettings(true);
        IPath targetPath = this.computeTargetPath();
        ReplaceQuery query = new ReplaceQuery(this.getShell());
        final FeatureImportOperation op = new FeatureImportOperation(models, this.fPage.isBinary(), targetPath, query);
        Job job = new Job(PDEUIMessages.FeatureImportWizard_title){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private IPath computeTargetPath() {
        IPath pluginsLocation = PDEPlugin.getWorkspace().getRoot().getLocation();
        if ("plugins".equals(pluginsLocation.lastSegment())) {
            return pluginsLocation.removeLastSegments(1).append("features");
        }
        return null;
    }

    private static class ReplaceDialog
    extends MessageDialog {
        public ReplaceDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, PDEUIMessages.FeatureImportWizard_messages_title, null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, PDEUIMessages.FeatureImportWizard_noToAll, IDialogConstants.CANCEL_LABEL}, 0);
        }
    }

    public static class ReplaceQuery
    implements FeatureImportOperation.IReplaceQuery {
        private int yesToAll = 0;
        private int[] RETURNCODES;

        public ReplaceQuery(Shell shell) {
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[1] = 2;
            nArray[2] = 1;
            nArray[3] = 1;
            this.RETURNCODES = nArray;
        }

        public int doQuery(IProject project) {
            if (this.yesToAll != 0) {
                return this.yesToAll > 0 ? 2 : 1;
            }
            String message = NLS.bind((String)PDEUIMessages.FeatureImportWizard_messages_exists, (Object)project.getName());
            int[] result = new int[1];
            Display.getDefault().syncExec(new Runnable(this, message, result){
                final /* synthetic */ ReplaceQuery this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = replaceQuery;
                    this.val$message = string;
                    this.val$result = nArray;
                }

                public void run() {
                    ReplaceDialog dialog = new ReplaceDialog(Display.getDefault().getActiveShell(), this.val$message);
                    int retVal = dialog.open();
                    if (retVal >= 0) {
                        this.val$result[0] = ReplaceQuery.access$0(this.this$1)[retVal];
                        if (retVal == 1) {
                            ReplaceQuery.access$1(this.this$1, 1);
                        } else if (retVal == 3) {
                            ReplaceQuery.access$1(this.this$1, -1);
                        }
                    }
                }
            });
            return result[0];
        }

        static /* synthetic */ int[] access$0(ReplaceQuery replaceQuery) {
            return replaceQuery.RETURNCODES;
        }

        static /* synthetic */ void access$1(ReplaceQuery replaceQuery, int n) {
            replaceQuery.yesToAll = n;
        }
    }
}

