/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class ActionDelegateHelper
implements IPartListener,
IWindowListener {
    private static ActionDelegateHelper fgDefault;
    private IMember fMember = null;
    private ITextEditor fTextEditor = null;
    private ISelection fCurrentSelection = null;
    private IWorkbenchWindow fCurrentWindow = JDIDebugUIPlugin.getActiveWorkbenchWindow();
    static /* synthetic */ Class class$0;

    public static ActionDelegateHelper getDefault() {
        if (fgDefault == null) {
            fgDefault = new ActionDelegateHelper();
        }
        return fgDefault;
    }

    private ActionDelegateHelper() {
        if (this.fCurrentWindow != null) {
            this.fCurrentWindow.getWorkbench().addWindowListener((IWindowListener)this);
            this.fCurrentWindow.getPartService().addPartListener((IPartListener)this);
            IWorkbenchPage page = this.fCurrentWindow.getActivePage();
            if (page != null) {
                IEditorPart part = page.getActiveEditor();
                this.checkToSetTextEditor((IWorkbenchPart)part);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.checkToSetTextEditor(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTextEditor()) {
            this.cleanup();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected IMember getMember() {
        return this.fMember;
    }

    protected void setMember(IMember member) {
        this.fMember = member;
    }

    protected void checkToSetTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            if (part instanceof JavaSnippetEditor) {
                this.cleanup();
            } else {
                this.setTextEditor((ITextEditor)part);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMember getCurrentMember(ITextSelection currentSelection) {
        IMember m;
        block14: {
            if (currentSelection == this.getCurrentSelection()) {
                return this.getMember();
            }
            this.setCurrentSelection((ISelection)currentSelection);
            ITextEditor editor = this.getTextEditor();
            if (editor == null) {
                return null;
            }
            IEditorInput editorInput = editor.getEditorInput();
            m = null;
            try {
                IClassFile classFile;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IClassFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((classFile = (IClassFile)editorInput.getAdapter((Class)clazz)) != null) {
                    IJavaElement e = classFile.getElementAt(currentSelection.getOffset());
                    if (e instanceof IMember) {
                        m = (IMember)e;
                    }
                    break block14;
                }
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit unit = manager.getWorkingCopy(editorInput);
                if (unit == null) break block14;
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    unit.reconcile(0, false, null, null);
                }
                IJavaElement e = unit.getElementAt(currentSelection.getOffset());
                if (e instanceof IMember) {
                    m = (IMember)e;
                }
            }
            catch (JavaModelException jme) {
                JDIDebugUIPlugin.log(jme);
            }
        }
        this.setMember(m);
        return m;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected ISelection getCurrentSelection() {
        return this.fCurrentSelection;
    }

    protected void setCurrentSelection(ISelection currentSelection) {
        this.fCurrentSelection = currentSelection;
    }

    public void windowActivated(IWorkbenchWindow window) {
        if (this.fCurrentWindow != null) {
            this.fCurrentWindow.getPartService().removePartListener((IPartListener)this);
            this.cleanup();
        }
        this.fCurrentWindow = window;
        this.fCurrentWindow.getPartService().addPartListener((IPartListener)this);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.checkToSetTextEditor((IWorkbenchPart)page.getActiveEditor());
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        if (this.fCurrentWindow == window) {
            this.fCurrentWindow = null;
            this.cleanup();
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    protected void cleanup() {
        this.setTextEditor(null);
        this.setCurrentSelection(null);
        this.setMember(null);
    }
}

