/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;

final class IndexFileDeleter {
    private List deletable;
    private Map refCounts = new HashMap();
    private List commits = new ArrayList();
    private List lastFiles = new ArrayList();
    private List commitsToDelete = new ArrayList();
    private PrintStream infoStream;
    private Directory directory;
    private IndexDeletionPolicy policy;
    private DocumentsWriter docWriter;
    final boolean startingCommitDeleted;
    public static boolean VERBOSE_REF_COUNTS = false;
    static /* synthetic */ Class class$org$apache$lucene$index$IndexFileDeleter;

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
        if (infoStream != null) {
            this.message("setInfoStream deletionPolicy=" + this.policy);
        }
    }

    private void message(String message) {
        this.infoStream.println("IFD [" + Thread.currentThread().getName() + "]: " + message);
    }

    public IndexFileDeleter(Directory directory, IndexDeletionPolicy policy, SegmentInfos segmentInfos, PrintStream infoStream, DocumentsWriter docWriter) throws CorruptIndexException, IOException {
        String fileName;
        this.docWriter = docWriter;
        this.infoStream = infoStream;
        if (infoStream != null) {
            this.message("init: current segments file is \"" + segmentInfos.getCurrentSegmentFileName() + "\"; deletionPolicy=" + policy);
        }
        this.policy = policy;
        this.directory = directory;
        long currentGen = segmentInfos.getGeneration();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        String[] files = directory.listAll();
        CommitPoint currentCommitPoint = null;
        for (int i = 0; i < files.length; ++i) {
            fileName = files[i];
            if (!filter.accept(null, fileName) || fileName.equals("segments.gen")) continue;
            this.getRefCount(fileName);
            if (!fileName.startsWith("segments") || SegmentInfos.generationFromSegmentsFileName(fileName) > currentGen) continue;
            if (infoStream != null) {
                this.message("init: load commit \"" + fileName + "\"");
            }
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(directory, fileName);
            }
            catch (FileNotFoundException e) {
                if (infoStream != null) {
                    this.message("init: hit FileNotFoundException when loading commit \"" + fileName + "\"; skipping this commit point");
                }
                sis = null;
            }
            if (sis == null) continue;
            CommitPoint commitPoint = new CommitPoint(this.commitsToDelete, directory, sis);
            if (sis.getGeneration() == segmentInfos.getGeneration()) {
                currentCommitPoint = commitPoint;
            }
            this.commits.add(commitPoint);
            this.incRef(sis, true);
        }
        if (currentCommitPoint == null) {
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(directory, segmentInfos.getCurrentSegmentFileName());
            }
            catch (IOException e) {
                throw new CorruptIndexException("failed to locate current segments_N file");
            }
            if (infoStream != null) {
                this.message("forced open of current segments file " + segmentInfos.getCurrentSegmentFileName());
            }
            currentCommitPoint = new CommitPoint(this.commitsToDelete, directory, sis);
            this.commits.add(currentCommitPoint);
            this.incRef(sis, true);
        }
        Collections.sort(this.commits);
        Iterator it = this.refCounts.keySet().iterator();
        while (it.hasNext()) {
            fileName = (String)it.next();
            RefCount rc = (RefCount)this.refCounts.get(fileName);
            if (0 != rc.count) continue;
            if (infoStream != null) {
                this.message("init: removing unreferenced file \"" + fileName + "\"");
            }
            this.deleteFile(fileName);
        }
        policy.onInit(this.commits);
        this.checkpoint(segmentInfos, false);
        this.startingCommitDeleted = currentCommitPoint.isDeleted();
        this.deleteCommits();
    }

    private void deleteCommits() throws IOException {
        int size = this.commitsToDelete.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                CommitPoint commit = (CommitPoint)this.commitsToDelete.get(i);
                if (this.infoStream != null) {
                    this.message("deleteCommits: now decRef commit \"" + commit.getSegmentsFileName() + "\"");
                }
                Iterator it = commit.files.iterator();
                while (it.hasNext()) {
                    this.decRef((String)it.next());
                }
            }
            this.commitsToDelete.clear();
            size = this.commits.size();
            int writeTo = 0;
            for (int readFrom = 0; readFrom < size; ++readFrom) {
                CommitPoint commit = (CommitPoint)this.commits.get(readFrom);
                if (commit.deleted) continue;
                if (writeTo != readFrom) {
                    this.commits.set(writeTo, this.commits.get(readFrom));
                }
                ++writeTo;
            }
            while (size > writeTo) {
                this.commits.remove(size - 1);
                --size;
            }
        }
    }

    public void refresh(String segmentName) throws IOException {
        String segmentPrefix2;
        String segmentPrefix1;
        String[] files = this.directory.listAll();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        if (segmentName != null) {
            segmentPrefix1 = segmentName + ".";
            segmentPrefix2 = segmentName + "_";
        } else {
            segmentPrefix1 = null;
            segmentPrefix2 = null;
        }
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!filter.accept(null, fileName) || segmentName != null && !fileName.startsWith(segmentPrefix1) && !fileName.startsWith(segmentPrefix2) || this.refCounts.containsKey(fileName) || fileName.equals("segments.gen")) continue;
            if (this.infoStream != null) {
                this.message("refresh [prefix=" + segmentName + "]: removing newly created unreferenced file \"" + fileName + "\"");
            }
            this.deleteFile(fileName);
        }
    }

    public void refresh() throws IOException {
        this.refresh(null);
    }

    public void close() throws IOException {
        int size = this.lastFiles.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.decRef((Collection)this.lastFiles.get(i));
            }
            this.lastFiles.clear();
        }
        this.deletePendingFiles();
    }

    private void deletePendingFiles() throws IOException {
        if (this.deletable != null) {
            List oldDeletable = this.deletable;
            this.deletable = null;
            int size = oldDeletable.size();
            for (int i = 0; i < size; ++i) {
                if (this.infoStream != null) {
                    this.message("delete pending file " + oldDeletable.get(i));
                }
                this.deleteFile((String)oldDeletable.get(i));
            }
        }
    }

    public void checkpoint(SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        if (this.infoStream != null) {
            this.message("now checkpoint \"" + segmentInfos.getCurrentSegmentFileName() + "\" [" + segmentInfos.size() + " segments " + "; isCommit = " + isCommit + "]");
        }
        this.deletePendingFiles();
        this.incRef(segmentInfos, isCommit);
        if (isCommit) {
            this.commits.add(new CommitPoint(this.commitsToDelete, this.directory, segmentInfos));
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        } else {
            int size;
            List docWriterFiles;
            if (this.docWriter != null) {
                docWriterFiles = this.docWriter.openFiles();
                if (docWriterFiles != null) {
                    this.incRef(docWriterFiles);
                }
            } else {
                docWriterFiles = null;
            }
            if ((size = this.lastFiles.size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    this.decRef((Collection)this.lastFiles.get(i));
                }
                this.lastFiles.clear();
            }
            this.lastFiles.add(segmentInfos.files(this.directory, false));
            if (docWriterFiles != null) {
                this.lastFiles.add(docWriterFiles);
            }
        }
    }

    void incRef(SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        Iterator it = segmentInfos.files(this.directory, isCommit).iterator();
        while (it.hasNext()) {
            this.incRef((String)it.next());
        }
    }

    void incRef(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            this.incRef((String)files.get(i));
        }
    }

    void incRef(String fileName) throws IOException {
        RefCount rc = this.getRefCount(fileName);
        if (this.infoStream != null && VERBOSE_REF_COUNTS) {
            this.message("  IncRef \"" + fileName + "\": pre-incr count is " + rc.count);
        }
        rc.IncRef();
    }

    void decRef(Collection files) throws IOException {
        Iterator it = files.iterator();
        while (it.hasNext()) {
            this.decRef((String)it.next());
        }
    }

    void decRef(String fileName) throws IOException {
        RefCount rc = this.getRefCount(fileName);
        if (this.infoStream != null && VERBOSE_REF_COUNTS) {
            this.message("  DecRef \"" + fileName + "\": pre-decr count is " + rc.count);
        }
        if (0 == rc.DecRef()) {
            this.deleteFile(fileName);
            this.refCounts.remove(fileName);
        }
    }

    void decRef(SegmentInfos segmentInfos) throws IOException {
        Iterator it = segmentInfos.files(this.directory, false).iterator();
        while (it.hasNext()) {
            this.decRef((String)it.next());
        }
    }

    private RefCount getRefCount(String fileName) {
        RefCount rc;
        if (!this.refCounts.containsKey(fileName)) {
            rc = new RefCount(fileName);
            this.refCounts.put(fileName, rc);
        } else {
            rc = (RefCount)this.refCounts.get(fileName);
        }
        return rc;
    }

    void deleteFiles(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            this.deleteFile((String)files.get(i));
        }
    }

    void deleteNewFiles(Collection files) throws IOException {
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            if (this.refCounts.containsKey(fileName)) continue;
            this.deleteFile(fileName);
        }
    }

    void deleteFile(String fileName) throws IOException {
        block5: {
            try {
                if (this.infoStream != null) {
                    this.message("delete \"" + fileName + "\"");
                }
                this.directory.deleteFile(fileName);
            }
            catch (IOException e) {
                if (!this.directory.fileExists(fileName)) break block5;
                if (this.infoStream != null) {
                    this.message("IndexFileDeleter: unable to remove file \"" + fileName + "\": " + e.toString() + "; Will re-try later.");
                }
                if (this.deletable == null) {
                    this.deletable = new ArrayList();
                }
                this.deletable.add(fileName);
            }
        }
    }

    private static final class CommitPoint
    extends IndexCommit
    implements Comparable {
        long gen;
        Collection files;
        String segmentsFileName;
        boolean deleted;
        Directory directory;
        Collection commitsToDelete;
        long version;
        long generation;
        final boolean isOptimized;
        final Map userData;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CommitPoint(Collection commitsToDelete, Directory directory, SegmentInfos segmentInfos) throws IOException {
            this.directory = directory;
            this.commitsToDelete = commitsToDelete;
            this.userData = segmentInfos.getUserData();
            this.segmentsFileName = segmentInfos.getCurrentSegmentFileName();
            this.version = segmentInfos.getVersion();
            this.generation = segmentInfos.getGeneration();
            this.files = Collections.unmodifiableCollection(segmentInfos.files(directory, true));
            this.gen = segmentInfos.getGeneration();
            boolean bl = this.isOptimized = segmentInfos.size() == 1 && !segmentInfos.info(0).hasDeletions();
            if (!$assertionsDisabled && segmentInfos.hasExternalSegments(directory)) {
                throw new AssertionError();
            }
        }

        public boolean isOptimized() {
            return this.isOptimized;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection getFileNames() throws IOException {
            return this.files;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public long getVersion() {
            return this.version;
        }

        public long getGeneration() {
            return this.generation;
        }

        public Map getUserData() {
            return this.userData;
        }

        public void delete() {
            if (!this.deleted) {
                this.deleted = true;
                this.commitsToDelete.add(this);
            }
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public int compareTo(Object obj) {
            CommitPoint commit = (CommitPoint)obj;
            if (this.gen < commit.gen) {
                return -1;
            }
            if (this.gen > commit.gen) {
                return 1;
            }
            return 0;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$IndexFileDeleter == null ? (class$org$apache$lucene$index$IndexFileDeleter = IndexFileDeleter.class$("org.apache.lucene.index.IndexFileDeleter")) : class$org$apache$lucene$index$IndexFileDeleter).desiredAssertionStatus();
        }
    }

    private static final class RefCount {
        final String fileName;
        boolean initDone;
        int count;
        static final /* synthetic */ boolean $assertionsDisabled;

        RefCount(String fileName) {
            this.fileName = fileName;
        }

        public int IncRef() {
            if (!this.initDone) {
                this.initDone = true;
            } else if (!$assertionsDisabled && this.count <= 0) {
                throw new AssertionError((Object)("RefCount is 0 pre-increment for file \"" + this.fileName + "\""));
            }
            return ++this.count;
        }

        public int DecRef() {
            if (!$assertionsDisabled && this.count <= 0) {
                throw new AssertionError((Object)("RefCount is 0 pre-decrement for file \"" + this.fileName + "\""));
            }
            return --this.count;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$IndexFileDeleter == null ? (class$org$apache$lucene$index$IndexFileDeleter = IndexFileDeleter.class$("org.apache.lucene.index.IndexFileDeleter")) : class$org$apache$lucene$index$IndexFileDeleter).desiredAssertionStatus();
        }
    }
}

