/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.mappingprovider.table.panel;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.EMFFormsViewService;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsMappingProviderTable")
public class EMFFormsMappingProviderTable
implements EMFFormsMappingProvider {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ReportService reportService;
    private EMFFormsViewService emfFormsViewService;

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Reference(unbind="-")
    protected void setEMFFormsViewService(EMFFormsViewService emfFormsViewService) {
        this.emfFormsViewService = emfFormsViewService;
    }

    public Set<UniqueSetting> getMappingFor(VDomainModelReference domainModelReference, EObject domainObject) {
        EStructuralFeature.Setting tableSetting;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        EObject parent = domainModelReference.eContainer();
        while (!(parent instanceof VView)) {
            parent = parent.eContainer();
        }
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)domainModelReference;
        try {
            tableSetting = this.emfFormsDatabinding.getSetting((VDomainModelReference)tableDMR, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Collections.emptySet();
        }
        LinkedHashSet<UniqueSetting> settingsMap = new LinkedHashSet<UniqueSetting>();
        settingsMap.add(UniqueSetting.createSetting((EStructuralFeature.Setting)tableSetting));
        for (EObject eObject : (List)tableSetting.get(true)) {
            EStructuralFeature.Setting columnSetting2;
            for (VDomainModelReference columnDMR : tableDMR.getColumnDomainModelReferences()) {
                try {
                    columnSetting2 = this.emfFormsDatabinding.getSetting(columnDMR, eObject);
                    settingsMap.add(UniqueSetting.createSetting((EStructuralFeature.Setting)columnSetting2));
                }
                catch (DatabindingFailedException columnSetting2) {
                    // empty catch block
                }
            }
            for (VDomainModelReference columnDMR : this.getView((VView)parent, eObject)) {
                try {
                    columnSetting2 = this.emfFormsDatabinding.getSetting(columnDMR, eObject);
                    settingsMap.add(UniqueSetting.createSetting((EStructuralFeature.Setting)columnSetting2));
                }
                catch (DatabindingFailedException databindingFailedException) {
                    // empty catch block
                }
            }
        }
        return settingsMap;
    }

    private Collection<VDomainModelReference> getView(VView view, EObject newEntry) {
        LinkedHashSet<VDomainModelReference> result = new LinkedHashSet<VDomainModelReference>();
        VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)view);
        VView detailView = this.emfFormsViewService.getView(newEntry, properties);
        TreeIterator eAllContents = detailView.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof VDomainModelReference) || next.eContainingFeature() != VViewPackage.eINSTANCE.getControl_DomainModelReference()) continue;
            result.add((VDomainModelReference)next);
        }
        return result;
    }

    public double isApplicable(VDomainModelReference domainModelReference, EObject domainObject) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given VDomainModelReference was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (domainObject == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain object was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (VTableDomainModelReference.class.isInstance(domainModelReference) && VTableControl.class.isInstance(domainModelReference.eContainer()) && ((VTableControl)VTableControl.class.cast(domainModelReference.eContainer())).getDetailEditing() == DetailEditing.WITH_PANEL) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }
}

