/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.Collections;
import java.util.List;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CompactVerticallyTableViewerCompositeBuilder
implements TableViewerCompositeBuilder {
    private Label titleLabel;
    private Label validationLabel;
    private Composite buttonComposite;
    private Composite viewerComposite;
    private final boolean createTitleLabel;
    private final boolean createValidationLabel;

    public CompactVerticallyTableViewerCompositeBuilder(boolean createTitleLabel, boolean createValidationLabel) {
        this.createTitleLabel = createTitleLabel;
        this.createValidationLabel = createValidationLabel;
    }

    @Override
    public void createCompositeLayout(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        int numberOfColumns = this.createTitleLabel || this.createValidationLabel ? 3 : 2;
        GridLayoutFactory.fillDefaults().numColumns(numberOfColumns).applyTo(composite);
        if (this.createTitleLabel || this.createValidationLabel) {
            Composite frontComposite = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(false, false).align(1, 1).applyTo((Control)frontComposite);
            int numberOfFrontColumns = this.createTitleLabel && this.createValidationLabel ? 2 : 1;
            GridLayoutFactory.fillDefaults().numColumns(numberOfFrontColumns).equalWidth(false).applyTo(frontComposite);
            this.titleLabel = this.createTitleLabel(frontComposite, parent.getBackground());
            this.validationLabel = this.createValidationLabel(frontComposite);
        }
        this.viewerComposite = this.createViewerComposite(composite);
        this.buttonComposite = this.createButtonComposite(composite);
    }

    protected Label createTitleLabel(Composite parentComposite, Color background) {
        Label titleLabel = new Label(parentComposite, 0);
        titleLabel.setBackground(background);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)titleLabel);
        return titleLabel;
    }

    protected Composite createButtonComposite(Composite parentComposite) {
        Composite buttonComposite = new Composite(parentComposite, 0);
        buttonComposite.setBackground(parentComposite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(false, false).applyTo((Control)buttonComposite);
        return buttonComposite;
    }

    protected Composite createViewerComposite(Composite composite) {
        Composite viewerComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, 200).applyTo((Control)viewerComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(viewerComposite);
        return viewerComposite;
    }

    protected Label createValidationLabel(Composite topComposite) {
        Label validationLabel = new Label(topComposite, 0);
        validationLabel.setBackground(topComposite.getBackground());
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)validationLabel);
        return validationLabel;
    }

    @Override
    public Optional<Label> getTitleLabel() {
        return Optional.ofNullable((Object)this.titleLabel);
    }

    @Override
    public Optional<List<Control>> getValidationControls() {
        if (this.validationLabel != null) {
            return Optional.of(Collections.singletonList(this.validationLabel));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Composite> getButtonComposite() {
        return Optional.ofNullable((Object)this.buttonComposite);
    }

    @Override
    public Composite getViewerComposite() {
        return this.viewerComposite;
    }
}

