/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.model.impl;

import java.util.Set;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomDomainModelReference;
import org.eclipse.emf.ecp.view.spi.custom.model.impl.VCustomDomainModelReferenceImpl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DomainModelReferenceConverter;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DomainModelReferenceConverterEMF.class, DomainModelReferenceConverter.class})
public class CustomDMRConverter
implements DomainModelReferenceConverterEMF {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ServiceReference<EMFFormsDatabindingEMF> databindingServiceReference;
    private BundleContext bundleContext;

    @Activate
    protected final void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected final void deactivate(BundleContext bundleContext) {
        if (this.databindingServiceReference != null) {
            bundleContext.ungetService(this.databindingServiceReference);
            this.emfFormsDatabinding = null;
        }
    }

    private EMFFormsDatabindingEMF getEMFFormsDatabindingEMF() {
        if (this.emfFormsDatabinding == null) {
            this.databindingServiceReference = this.bundleContext.getServiceReference(EMFFormsDatabindingEMF.class);
            if (this.databindingServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDatabindingEMF available!");
            }
            this.emfFormsDatabinding = (EMFFormsDatabindingEMF)this.bundleContext.getService(this.databindingServiceReference);
        }
        return this.emfFormsDatabinding;
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (object == null) {
            return this.convertToValueProperty(domainModelReference, null, null);
        }
        return this.convertToValueProperty(domainModelReference, object.eClass(), this.getEditingDomain(object));
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EClass rootEClass, EditingDomain editingDomain) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VTableDomainModelReference.");
        }
        VCustomDomainModelReference tableDomainModelReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference);
        if (!tableDomainModelReference.getDomainModelReferences().isEmpty()) {
            VDomainModelReference nextDmr = (VDomainModelReference)tableDomainModelReference.getDomainModelReferences().iterator().next();
            if (rootEClass == null) {
                return this.getEMFFormsDatabindingEMF().getValueProperty(nextDmr, null);
            }
            return this.getEMFFormsDatabindingEMF().getValueProperty(nextDmr, rootEClass, editingDomain);
        }
        ECPHardcodedReferences customControl = CustomDMRConverter.loadObject(tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName());
        if (customControl == null) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s cannot be resolved.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        Set<VDomainModelReference> neededDomainModelReferences = customControl.getNeededDomainModelReferences();
        if (neededDomainModelReferences.isEmpty()) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s doesn't define any DomainModelReferences.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        VDomainModelReference nextNeededDmr = neededDomainModelReferences.iterator().next();
        if (rootEClass == null) {
            return this.getEMFFormsDatabindingEMF().getValueProperty(nextNeededDmr, null);
        }
        return this.getEMFFormsDatabindingEMF().getValueProperty(nextNeededDmr, rootEClass, editingDomain);
    }

    private static ECPHardcodedReferences loadObject(String bundleName, String clazz) throws DatabindingFailedException {
        Class loadClass;
        block6: {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                new ClassNotFoundException(String.format(LocalizationServiceHelper.getString(VCustomDomainModelReferenceImpl.class, (String)"BundleNotFound_ExceptionMessage"), clazz, bundleName));
                return null;
            }
            loadClass = bundle.loadClass(clazz);
            if (ECPHardcodedReferences.class.isAssignableFrom(loadClass)) break block6;
            return null;
        }
        try {
            return (ECPHardcodedReferences)ECPHardcodedReferences.class.cast(loadClass.newInstance());
        }
        catch (ClassNotFoundException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
    }

    public IEMFListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VTableDomainModelReference.");
        }
        VCustomDomainModelReference tableDomainModelReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference);
        ECPHardcodedReferences customControl = CustomDMRConverter.loadObject(tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName());
        if (customControl == null) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s cannot be resolved.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        Set<VDomainModelReference> neededDomainModelReferences = customControl.getNeededDomainModelReferences();
        if (neededDomainModelReferences.isEmpty()) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s doesn't define any DomainModelReferences.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        return this.getEMFFormsDatabindingEMF().getListProperty(neededDomainModelReferences.iterator().next(), object);
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        IEMFValueProperty valueProperty = this.convertToValueProperty(domainModelReference, object);
        IObservableValue observableValue = valueProperty.observe((Object)object);
        EObject eObject = (EObject)((IObserving)IObserving.class.cast(observableValue)).getObserved();
        EStructuralFeature eStructuralFeature = valueProperty.getStructuralFeature();
        return ((InternalEObject)InternalEObject.class.cast(eObject)).eSetting(eStructuralFeature);
    }
}

