/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.featurepath;

import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRSegmentExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="FeatureSegmentExpander")
public class FeatureSegmentExpander
implements EMFFormsDMRSegmentExpander {
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Optional<EObject> prepareDomainObject(VDomainModelReferenceSegment segment, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)segment).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)segment).ofClass(VFeatureDomainModelReferenceSegment.class);
        VFeatureDomainModelReferenceSegment featureSegment = (VFeatureDomainModelReferenceSegment)segment;
        EStructuralFeature structuralFeature = domainObject.eClass().getEStructuralFeature(featureSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new EMFFormsExpandingFailedException(String.format("The given domain object does not contain the segment's feature. The segment was %1$s. The domain object was %2$s.", segment, domainObject));
        }
        if (!EReference.class.isInstance(structuralFeature)) {
            throw new EMFFormsExpandingFailedException(String.format("The feature described by the given segment must be an EReference. The segment was %1$s.", segment));
        }
        EReference reference = (EReference)structuralFeature;
        EObject child = (EObject)domainObject.eGet((EStructuralFeature)reference);
        if (child == null) {
            if (!reference.getEReferenceType().isAbstract() && !reference.getEReferenceType().isInterface()) {
                child = EcoreUtil.create((EClass)reference.getEReferenceType());
                domainObject.eSet((EStructuralFeature)reference, (Object)child);
            } else {
                throw new EMFFormsExpandingFailedException(String.format("The reference type of the segment's feature is either abstract or an interface. Therefore, no instance can be created. The segment was %1$s.", segment));
            }
        }
        return Optional.ofNullable(child);
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference segment was null."));
            return NOT_APPLICABLE;
        }
        if (VFeatureDomainModelReferenceSegment.class.isInstance(segment)) {
            return 1.0;
        }
        return NOT_APPLICABLE;
    }

    public boolean needsToExpandLastSegment() {
        return false;
    }
}

