/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.reference;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.SWTImageHelper;
import org.eclipse.emf.ecp.edit.internal.swt.controls.SingleControl;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.reference.AddReferenceAction;
import org.eclipse.emf.ecp.edit.spi.swt.reference.DeleteReferenceAction;
import org.eclipse.emf.ecp.edit.spi.swt.reference.NewReferenceAction;
import org.eclipse.emf.ecp.edit.spi.util.ECPModelElementChangeListener;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

@Deprecated
public class LinkControl
extends SingleControl {
    private Composite linkComposite;
    private Link hyperlink;
    private Label imageHyperlink;
    private ComposedAdapterFactory composedAdapterFactory;
    private ECPModelElementChangeListener modelElementChangeListener;
    private Label unsetLabel;
    private StackLayout stackLayout;
    private Composite mainComposite;
    private Button[] buttons;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;

    @Override
    protected void fillControlComposite(Composite composite) {
        int numColumns = 1 + this.getNumButtons();
        if (this.isEmbedded()) {
            numColumns = 1;
        }
        if (!this.isEmbedded() && this.getFirstStructuralFeature().isUnsettable()) {
            ++numColumns;
        }
        Composite parent = new Composite(composite, 0);
        parent.setBackground(composite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(numColumns).spacing(0, 0).equalWidth(false).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)parent);
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.mainComposite);
        this.stackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.mainComposite, 0);
        this.unsetLabel.setText(LocalizationServiceHelper.getString(this.getClass(), (String)"LinkControl_NotSet"));
        this.unsetLabel.setBackground(this.mainComposite.getBackground());
        this.unsetLabel.setForeground(this.getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        this.linkComposite = new Composite(this.mainComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.linkComposite);
        this.linkComposite.setBackground(this.mainComposite.getBackground());
        this.createHyperlink();
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.linkComposite);
        this.stackLayout.topControl = this.getFirstSetting().isSet() ? this.linkComposite : this.unsetLabel;
        if (!this.isEmbedded()) {
            this.buttons = this.createButtons(parent);
        }
    }

    protected int getNumButtons() {
        return 3;
    }

    protected Button[] createButtons(Composite composite) {
        Button[] buttons = new Button[3];
        EStructuralFeature.Setting setting = this.getFirstSetting();
        buttons[0] = this.createButtonForAction(new DeleteReferenceAction(this.getEditingDomain(this.getFirstSetting()), setting, (ReferenceService)this.getService(ReferenceService.class)), composite);
        buttons[1] = this.createButtonForAction(new AddReferenceAction(this.getEditingDomain(this.getFirstSetting()), setting, this.getItemPropertyDescriptor(setting), (ReferenceService)this.getService(ReferenceService.class)), composite);
        buttons[2] = this.createButtonForAction(new NewReferenceAction(this.getEditingDomain(this.getFirstSetting()), setting, (EMFFormsEditSupport)this.getViewModelContext().getService(EMFFormsEditSupport.class), (EMFFormsLabelProvider)this.getViewModelContext().getService(EMFFormsLabelProvider.class), (ReferenceService)this.getService(ReferenceService.class), (ReportService)this.getViewModelContext().getService(ReportService.class), this.getDomainModelReference(), this.getViewModelContext().getDomainModel()), composite);
        return buttons;
    }

    private void createHyperlink() {
        this.setComposedAdapterFactory(new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}));
        this.setAdapterFactoryItemDelegator(new AdapterFactoryItemDelegator((AdapterFactory)this.getComposedAdapterFactory()));
        this.imageHyperlink = new Label(this.linkComposite, 0);
        this.imageHyperlink.setBackground(this.linkComposite.getBackground());
        this.hyperlink = new Link(this.linkComposite, 0);
        this.hyperlink.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_reference");
        this.hyperlink.setBackground(this.linkComposite.getBackground());
        this.hyperlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LinkControl.this.linkClicked((EObject)LinkControl.this.getModelValue().getValue());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.hyperlink);
    }

    protected void linkClicked(EObject value) {
        ((ReferenceService)this.getService(ReferenceService.class)).openInNewContext(value);
    }

    public void setEditable(boolean isEditable) {
        if (!this.isEmbedded()) {
            Button[] buttonArray = this.buttons;
            int n = this.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                button.setVisible(isEditable);
                ++n2;
            }
        }
        this.mainComposite.getParent().layout();
    }

    @Override
    public Binding bindValue() {
        ISWTObservableValue value = WidgetProperties.text().observe((Widget)this.hyperlink);
        this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), this.createValueExtractingUpdateStrategy(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                LinkControl.this.updateChangeListener((EObject)value);
                return "<a>" + LinkControl.this.getLinkText(value) + "</a>";
            }
        });
        ISWTObservableValue tooltipValue = WidgetProperties.tooltipText().observe((Widget)this.hyperlink);
        this.getDataBindingContext().bindValue((IObservableValue)tooltipValue, this.getModelValue(), this.createValueExtractingUpdateStrategy(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getLinkText(value);
            }
        });
        ISWTObservableValue imageValue = WidgetProperties.image().observe((Widget)this.imageHyperlink);
        this.getDataBindingContext().bindValue((IObservableValue)imageValue, this.getModelValue(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getImage(value);
            }
        });
        ISWTObservableValue deleteButtonEnablement = WidgetProperties.enabled().observe((Widget)this.getDeleteButton());
        this.getDataBindingContext().bindValue((IObservableValue)deleteButtonEnablement, this.getModelValue(), this.createValueExtractingUpdateStrategy(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value != null) {
                    return true;
                }
                return false;
            }
        });
        return null;
    }

    private UpdateValueStrategy createValueExtractingUpdateStrategy() {
        return new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getModelValue().getValue();
            }
        };
    }

    protected Object getImage(Object value) {
        Object image = this.getAdapterFactoryItemDelegator().getImage(value);
        return SWTImageHelper.getImage(image);
    }

    protected Object getLinkText(Object value) {
        String linkName = this.getAdapterFactoryItemDelegator().getText(value);
        return linkName == null ? "" : linkName;
    }

    protected Button getDeleteButton() {
        return this.buttons[0];
    }

    @Override
    protected void updateValidationColor(Color color) {
        if (this.hyperlink != null) {
            this.hyperlink.setBackground(color);
        }
    }

    private void updateChangeListener(EObject value) {
        if (this.modelElementChangeListener != null) {
            if (this.modelElementChangeListener.getTarget().equals(value)) {
                return;
            }
            this.modelElementChangeListener.remove();
            this.modelElementChangeListener = null;
        }
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.mainComposite.layout();
            }
        } else {
            if (this.stackLayout.topControl != this.linkComposite) {
                this.stackLayout.topControl = this.linkComposite;
                this.mainComposite.layout();
            }
            this.modelElementChangeListener = new ECPModelElementChangeListener(value){

                public void onChange(Notification notification) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            LinkControl.this.getDataBindingContext().updateTargets();
                            LinkControl.this.linkComposite.layout();
                        }
                    });
                }
            };
        }
    }

    @Override
    public void dispose() {
        this.getComposedAdapterFactory().dispose();
        if (this.modelElementChangeListener != null) {
            this.modelElementChangeListener.remove();
        }
        this.hyperlink.dispose();
        super.dispose();
    }

    @Override
    protected String getUnsetLabelText() {
        return LocalizationServiceHelper.getString(this.getClass(), (String)"LinkControl_NoLinkSetClickToSetLink");
    }

    @Override
    protected String getUnsetButtonTooltip() {
        return LocalizationServiceHelper.getString(this.getClass(), (String)"LinkControl_UnsetLink");
    }

    @Override
    protected Control[] getControlsForTooltip() {
        return new Control[0];
    }

    public AdapterFactoryItemDelegator getAdapterFactoryItemDelegator() {
        return this.adapterFactoryItemDelegator;
    }

    public void setAdapterFactoryItemDelegator(AdapterFactoryItemDelegator adapterFactoryItemDelegator) {
        this.adapterFactoryItemDelegator = adapterFactoryItemDelegator;
    }

    public ComposedAdapterFactory getComposedAdapterFactory() {
        return this.composedAdapterFactory;
    }

    public void setComposedAdapterFactory(ComposedAdapterFactory composedAdapterFactory) {
        this.composedAdapterFactory = composedAdapterFactory;
    }
}

