/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.tooling.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class EMFFormsSelectTemplateWizardPage
extends WizardPage {
    private Text templateText;

    EMFFormsSelectTemplateWizardPage() {
        super("selectPage");
        this.setTitle(Messages.EMFFormsSelectTemplateWizardPage_Title);
        this.setDescription(Messages.EMFFormsSelectTemplateWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.EMFFormsSelectTemplateWizardPage_Label);
        this.templateText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.templateText);
        this.templateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EMFFormsSelectTemplateWizardPage.this.validate();
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.EMFFormsSelectTemplateWizardPage_BrowseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EMFFormsSelectTemplateWizardPage.this.handleBrowse();
            }
        });
        this.validate();
        this.setControl((Control)composite);
    }

    public String getTemplateName() {
        return this.templateText.getText();
    }

    private void handleBrowse() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.templateText.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle(Messages.EMFFormsSelectTemplateWizardPage_BrowseDialogTitle);
        dialog.setInitialPattern("*.template", 1);
        if (dialog.open() != 0) {
            return;
        }
        Object firstResult = dialog.getFirstResult();
        if (!IFile.class.isInstance(firstResult)) {
            this.templateText.setText("");
            return;
        }
        this.templateText.setText(((IFile)IFile.class.cast(firstResult)).getFullPath().toString());
    }

    private void validate() {
        if (this.getTemplateName().length() == 0) {
            this.updateStatus(Messages.EMFFormsSelectTemplateWizardPage_ErrorNoTemplateName);
            return;
        }
        IResource template = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getTemplateName()));
        if (template == null) {
            this.updateStatus(Messages.EMFFormsSelectTemplateWizardPage_ErrorTemplateNotExisting);
            return;
        }
        if (template.getType() != 1) {
            this.updateStatus(Messages.EMFFormsSelectTemplateWizardPage_ErrorTemplateIsNoFile);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

