/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.workspace.internal.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.spi.ui.CompositeStateObserver;
import org.eclipse.emf.ecp.workspace.internal.ui.NewXMIFileWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NewWorkspaceProjectComposite
extends Composite {
    private final CompositeStateObserver compositeStateObserver;
    private final ECPProperties properties;
    private boolean complete;
    private Text newFileText;
    private Text rootClassText;
    private Text importFileText;
    private Button createButton;
    private Button importButton;
    private StackLayout providerStackLayout;
    private Composite providerStackComposite;
    private Composite newProjectComposite;
    private Composite importProjectComposite;
    private Resource resource;
    private EClass eClass;
    private Composite grpDoYouWant;
    private Button newWorkspaceButton;
    private Button importWorkspaceButton;
    private Label label;

    public NewWorkspaceProjectComposite(Composite parent, CompositeStateObserver observer, ECPProperties projectProperties) {
        super(parent, 0);
        this.properties = projectProperties;
        this.compositeStateObserver = observer;
        this.setLayout((Layout)new GridLayout(1, false));
        this.createStackComposite(parent);
        this.notifyObserver();
    }

    private void createStackComposite(Composite parent) {
        this.providerStackLayout = new StackLayout();
        this.grpDoYouWant = new Composite((Composite)this, 2048);
        this.grpDoYouWant.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.grpDoYouWant.setLayout((Layout)new GridLayout(2, false));
        this.createButton = new Button(this.grpDoYouWant, 16);
        this.createButton.setText("Create empty project");
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((NewWorkspaceProjectComposite)NewWorkspaceProjectComposite.this).providerStackLayout.topControl = NewWorkspaceProjectComposite.this.newProjectComposite;
                NewWorkspaceProjectComposite.this.checkStatusChanged();
                NewWorkspaceProjectComposite.this.providerStackComposite.layout();
            }
        });
        this.createButton.setSelection(true);
        this.importButton = new Button(this.grpDoYouWant, 16);
        this.importButton.setText("Import existing XMI-File");
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((NewWorkspaceProjectComposite)NewWorkspaceProjectComposite.this).providerStackLayout.topControl = NewWorkspaceProjectComposite.this.importProjectComposite;
                NewWorkspaceProjectComposite.this.checkStatusChanged();
                NewWorkspaceProjectComposite.this.providerStackComposite.layout();
            }
        });
        this.providerStackComposite = new Composite((Composite)this, 0);
        this.providerStackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.providerStackComposite.setLayout((Layout)this.providerStackLayout);
        this.createNewWorkspaceProjectComposite(this.providerStackComposite);
        this.createImportWorkspaceProjectComposite(this.providerStackComposite);
        this.providerStackLayout.topControl = this.newProjectComposite;
        Button rootClassButton = new Button(this.newProjectComposite, 4);
        rootClassButton.setText("Choose Root Class \u2026");
        rootClassButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        rootClassButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewWorkspaceProjectComposite.this.eClass = NewWorkspaceProjectComposite.this.openClassSelectionDialog(NewWorkspaceProjectComposite.this.newProjectComposite);
                NewWorkspaceProjectComposite.this.fillResource();
                if (NewWorkspaceProjectComposite.this.eClass != null) {
                    NewWorkspaceProjectComposite.this.rootClassText.setText(String.valueOf(NewWorkspaceProjectComposite.this.eClass.getEPackage().getNsURI()) + "/" + NewWorkspaceProjectComposite.this.eClass.getName());
                }
            }
        });
    }

    private void createImportWorkspaceProjectComposite(Composite composite) {
        this.importProjectComposite = new Composite(composite, 2048);
        this.importProjectComposite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.importProjectComposite.setLayout((Layout)new GridLayout(3, false));
        Label selectFileLabel = new Label(this.importProjectComposite, 0);
        selectFileLabel.setText("Select File: ");
        this.importFileText = new Text(this.importProjectComposite, 2060);
        this.importFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.importFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkspaceProjectComposite.this.checkStatusChanged();
            }
        });
        new Label(this.importProjectComposite, 0);
        Button importFileButton = new Button(this.importProjectComposite, 0);
        importFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setText("Open");
                fileDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
                String path = fileDialog.open();
                if (path != null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.createResource(URI.createFileURI((String)path));
                    try {
                        resource.load(null);
                        NewWorkspaceProjectComposite.this.importFileText.setText(URI.createFileURI((String)path).toString());
                    }
                    catch (IOException iOException) {
                        MessageDialog.openError((Shell)NewWorkspaceProjectComposite.this.getShell(), (String)"Error", (String)"Error parsing XMI-File!");
                    }
                }
            }
        });
        importFileButton.setText("Browse File System ...");
        this.importWorkspaceButton = new Button(this.importProjectComposite, 0);
        this.importWorkspaceButton.addSelectionListener((SelectionListener)new ImportWorkspaceAdapter());
        this.importWorkspaceButton.setText("Browse Workspace ...");
    }

    private void createNewWorkspaceProjectComposite(Composite composite) {
        this.newProjectComposite = new Composite(composite, 2048);
        this.newProjectComposite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.newProjectComposite.setLayout((Layout)new GridLayout(4, false));
        Label filenameLabel = new Label(this.newProjectComposite, 0);
        filenameLabel.setText("Filename:");
        this.newFileText = new Text(this.newProjectComposite, 2060);
        this.newFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkspaceProjectComposite.this.checkStatusChanged();
            }
        });
        this.newFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(this.newProjectComposite, 0);
        Button newFileButton = new Button(this.newProjectComposite, 0);
        newFileButton.setText("Browse File System ...");
        newFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(composite.getShell(), 8192);
                fileDialog.setText("Open");
                fileDialog.setOverwrite(true);
                fileDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
                String path = fileDialog.open();
                if (path != null) {
                    URI pathURI = URI.createFileURI((String)path);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    NewWorkspaceProjectComposite.this.resource = resourceSet.createResource(pathURI);
                    NewWorkspaceProjectComposite.this.fillResource();
                    NewWorkspaceProjectComposite.this.newFileText.setText(pathURI.toString());
                }
            }
        });
        this.newWorkspaceButton = new Button(this.newProjectComposite, 0);
        this.newWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewXMIFileWizard newXMIFileWizard = new NewXMIFileWizard();
                WizardDialog wizardDialog = new WizardDialog(composite.getShell(), (IWizard)newXMIFileWizard);
                if (wizardDialog.open() == 0) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    NewWorkspaceProjectComposite.this.resource = resourceSet.createResource(newXMIFileWizard.getFileURI());
                    NewWorkspaceProjectComposite.this.fillResource();
                    NewWorkspaceProjectComposite.this.newFileText.setText(newXMIFileWizard.getFileURI().toString());
                }
            }
        });
        this.newWorkspaceButton.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.newWorkspaceButton.setText("Browse Workspace ...");
        new Label(this.newProjectComposite, 0);
        this.label = new Label(this.newProjectComposite, 258);
        this.label.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
        Label rootClassLabel = new Label(this.newProjectComposite, 0);
        rootClassLabel.setText("Root Class:");
        this.rootClassText = new Text(this.newProjectComposite, 2060);
        this.rootClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWorkspaceProjectComposite.this.checkStatusChanged();
            }
        });
        this.rootClassText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    private EClass openClassSelectionDialog(Composite composite) {
        SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), (Collection)ECPUtil.getAllRegisteredEPackages(), new HashSet());
        SelectModelElementWizard wizard = new SelectModelElementWizard("Choose Root Class", "Choose Root Class", "Choose Root Class", "Select the class that will be used as the root of the your new project.");
        wizard.setCompositeProvider((CompositeProvider)helper);
        WizardDialog wd = new WizardDialog(composite.getShell(), (IWizard)wizard);
        int wizardResult = wd.open();
        if (wizardResult == 0) {
            Object[] selection = helper.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            return (EClass)selection[0];
        }
        return null;
    }

    private void notifyObserver() {
        if (this.compositeStateObserver != null) {
            this.compositeStateObserver.compositeChangedState((Composite)this, this.complete, this.properties);
        }
    }

    private void checkStatusChanged() {
        boolean pendingStatus;
        this.properties.addProperty("rootURI", this.createButton.getSelection() ? this.newFileText.getText() : this.importFileText.getText());
        boolean bl = pendingStatus = this.createButton.getSelection() && this.newFileTextStatus() && this.rootClassTextStatus() || this.importButton.getSelection() && this.importFileTextStatus();
        if (pendingStatus != this.complete) {
            this.complete = pendingStatus;
            this.notifyObserver();
        }
    }

    private boolean newFileTextStatus() {
        return this.nonEmptyString(this.newFileText.getText());
    }

    private boolean importFileTextStatus() {
        return this.nonEmptyString(this.importFileText.getText());
    }

    private boolean rootClassTextStatus() {
        return this.nonEmptyString(this.rootClassText.getText());
    }

    private boolean nonEmptyString(String string) {
        return string != null && string.length() > 0 && string.trim().length() == string.length();
    }

    private void fillResource() {
        if (this.resource != null && this.eClass != null) {
            EObject root = EcoreUtil.create((EClass)this.eClass);
            this.resource.getContents().clear();
            this.resource.getContents().add((Object)root);
            try {
                this.resource.save(null);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    static /* synthetic */ Text access$0(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.importFileText;
    }

    static /* synthetic */ StackLayout access$1(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.providerStackLayout;
    }

    static /* synthetic */ Composite access$2(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.newProjectComposite;
    }

    static /* synthetic */ void access$3(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        newWorkspaceProjectComposite.checkStatusChanged();
    }

    static /* synthetic */ Composite access$4(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.providerStackComposite;
    }

    static /* synthetic */ Composite access$5(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.importProjectComposite;
    }

    static /* synthetic */ EClass access$6(NewWorkspaceProjectComposite newWorkspaceProjectComposite, Composite composite) {
        return newWorkspaceProjectComposite.openClassSelectionDialog(composite);
    }

    static /* synthetic */ void access$7(NewWorkspaceProjectComposite newWorkspaceProjectComposite, EClass eClass) {
        newWorkspaceProjectComposite.eClass = eClass;
    }

    static /* synthetic */ void access$8(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        newWorkspaceProjectComposite.fillResource();
    }

    static /* synthetic */ EClass access$9(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.eClass;
    }

    static /* synthetic */ Text access$10(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.rootClassText;
    }

    static /* synthetic */ void access$11(NewWorkspaceProjectComposite newWorkspaceProjectComposite, Resource resource) {
        newWorkspaceProjectComposite.resource = resource;
    }

    static /* synthetic */ Text access$12(NewWorkspaceProjectComposite newWorkspaceProjectComposite) {
        return newWorkspaceProjectComposite.newFileText;
    }

    private final class ImportWorkspaceAdapter
    extends SelectionAdapter {
        private ImportWorkspaceAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setAllowMultiple(false);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    File file;
                    if (selection.length == 1 && selection[0] instanceof File && (file = (File)selection[0]).getType() == 1) {
                        return new Status(0, "org.eclipse.emf.ecp.workspace.ui", 0, null, null);
                    }
                    return new Status(4, "org.eclipse.emf.ecp.workspace.ui", 4, "Please Select a File", null);
                }
            });
            dialog.setTitle("Select XMI");
            if (dialog.open() == 0 && dialog.getFirstResult() instanceof File) {
                File file = (File)dialog.getFirstResult();
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                try {
                    resource.load(null);
                    NewWorkspaceProjectComposite.this.importFileText.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)NewWorkspaceProjectComposite.this.getShell(), (String)"Error", (String)"Error parsing XMI-File!");
                }
            }
        }
    }
}

