/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.ConnectionLeakDetector;
import com.sun.enterprise.resource.pool.ConnectionLeakListener;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.PoolStatus;
import com.sun.enterprise.resource.pool.PoolTxHelper;
import com.sun.enterprise.resource.pool.ResourceGateway;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.DataStructureFactory;
import com.sun.enterprise.resource.pool.resizer.Resizer;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueue;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueueFactory;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.RetryableUnavailableException;
import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ConnectionPool
implements ResourcePool,
ConnectionLeakListener,
ResourceHandler,
PoolProperties {
    private static final Logger LOG = LogDomains.getLogger(ConnectionPool.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected int maxPoolSize;
    protected int steadyPoolSize;
    protected int resizeQuantity;
    protected int maxWaitTime;
    protected long idletime;
    protected boolean failAllConnections;
    protected boolean matchConnections;
    protected boolean connectionValidationRequired;
    protected boolean preferValidateOverRecreate;
    protected volatile boolean poolInitialized;
    protected Resizer resizerTask;
    protected Timer resizerTaskTimer;
    protected boolean connectionCreationRetry_;
    protected int connectionCreationRetryAttempts_;
    protected long conCreationRetryInterval_;
    protected long validateAtmostPeriodInMilliSeconds_;
    protected int maxConnectionUsage;
    private boolean validateAtmostEveryIdleSecs;
    protected PoolLifeCycleListener poolLifeCycleListener;
    protected ResourceGateway gateway;
    protected String resourceGatewayClass;
    protected ConnectionLeakDetector leakDetector;
    protected DataStructure dataStructure;
    protected String dataStructureType;
    protected String dataStructureParameters;
    protected PoolWaitQueue waitQueue;
    protected PoolWaitQueue reconfigWaitQueue;
    private long reconfigWaitTime;
    protected String poolWaitQueueClass;
    protected final PoolInfo poolInfo;
    private final PoolTxHelper poolTxHelper;
    protected ResourceAllocator allocator;
    private boolean blocked;
    private final ReentrantLock getResourceFromPoolAndFreeResourceMethodsLock = new ReentrantLock(true);

    public ConnectionPool(PoolInfo poolInfo, Hashtable<?, ?> env) throws PoolingException {
        this.poolInfo = poolInfo;
        this.setPoolConfiguration(env);
        this.initializePoolDataStructure();
        this.initializeResourceSelectionStrategy();
        this.initializePoolWaitQueue();
        this.poolTxHelper = new PoolTxHelper(this.poolInfo);
        this.gateway = ResourceGateway.getInstance(this.resourceGatewayClass);
        LOG.log(Level.FINE, "Connection Pool: {0}", this.poolInfo);
    }

    protected void initializePoolWaitQueue() throws PoolingException {
        this.waitQueue = PoolWaitQueueFactory.createPoolWaitQueue(this.poolWaitQueueClass);
        this.reconfigWaitQueue = PoolWaitQueueFactory.createPoolWaitQueue(this.poolWaitQueueClass);
    }

    protected void initializePoolDataStructure() throws PoolingException {
        this.dataStructure = DataStructureFactory.getDataStructure(this.dataStructureType, this.dataStructureParameters, this.maxPoolSize, this);
    }

    protected void initializeResourceSelectionStrategy() {
    }

    private void setPoolConfiguration(Hashtable<?, ?> env) throws PoolingException {
        ConnectorConnectionPool poolResource = this.getPoolConfigurationFromJndi(env);
        this.idletime = (long)Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000L;
        this.maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        if (this.maxPoolSize < this.steadyPoolSize) {
            this.maxPoolSize = this.steadyPoolSize;
        }
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.failAllConnections = poolResource.isFailAllConnections();
        this.connectionValidationRequired = poolResource.isIsConnectionValidationRequired();
        this.validateAtmostEveryIdleSecs = poolResource.isValidateAtmostEveryIdleSecs();
        this.dataStructureType = poolResource.getPoolDataStructureType();
        this.dataStructureParameters = poolResource.getDataStructureParameters();
        this.poolWaitQueueClass = poolResource.getPoolWaitQueue();
        this.resourceGatewayClass = poolResource.getResourceGatewayClass();
        this.reconfigWaitTime = poolResource.getDynamicReconfigWaitTimeout();
        this.setAdvancedPoolConfiguration(poolResource);
    }

    protected ConnectorConnectionPool getPoolConfigurationFromJndi(Hashtable<?, ?> env) throws PoolingException {
        try {
            return (ConnectorConnectionPool)ConnectorRuntime.getRuntime().getResourceNamingService().lookup((GenericResourceInfo)this.poolInfo, ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(this.poolInfo), env);
        }
        catch (NamingException ex) {
            throw new PoolingException((Exception)ex);
        }
    }

    protected synchronized void initPool(ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.allocator = allocator;
        this.createResources(this.allocator, this.steadyPoolSize - this.dataStructure.getResourcesSize());
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionsFreed(this.steadyPoolSize);
        }
        this.poolInitialized = true;
    }

    protected void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
            this.resizerTask = null;
        }
        this.resizerTask = this.initializeResizer();
        if (this.resizerTaskTimer == null) {
            this.resizerTaskTimer = ConnectorRuntime.getRuntime().getTimer();
        }
        this.resizerTaskTimer.scheduleAtFixedRate((TimerTask)this.resizerTask, this.idletime, this.idletime);
        LOG.log(Level.FINE, "Scheduled resizer task with the idle time {0} ms", this.idletime);
    }

    protected Resizer initializeResizer() {
        return new Resizer(this.poolInfo, this.dataStructure, this, this, this.preferValidateOverRecreate);
    }

    private void addResource(ResourceAllocator alloc) throws PoolingException {
        int numResCreated = this.dataStructure.addResource(alloc, 1);
        if (numResCreated > 0) {
            for (int i = 0; i < numResCreated; ++i) {
                if (this.poolLifeCycleListener == null) continue;
                this.poolLifeCycleListener.incrementNumConnFree(false, this.steadyPoolSize);
            }
        }
        LOG.log(Level.FINE, "Pool: resource added");
    }

    protected void setResourceStateToFree(ResourceHandle resourceHandle) {
        resourceHandle.getResourceState().setBusy(false);
        this.leakDetector.stopConnectionLeakTracing(resourceHandle, this);
    }

    protected void setResourceStateToBusy(ResourceHandle resourceHandle) {
        resourceHandle.getResourceState().setBusy(true);
        this.leakDetector.startConnectionLeakTracing(resourceHandle, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandle getResource(ResourceSpec spec, ResourceAllocator alloc, Transaction transaction) throws PoolingException, RetryableUnavailableException {
        ResourceHandle result;
        block27: {
            Object reconfigWaitMonitor;
            Object object;
            result = null;
            long startTime = System.currentTimeMillis();
            long remainingWaitTime = 0L;
            while (true) {
                long elapsedWaitTime;
                if (this.gateway.allowed()) {
                    Set resourcesSet;
                    JavaEETransaction javaEETransaction = (JavaEETransaction)transaction;
                    Set set = resourcesSet = javaEETransaction == null ? null : javaEETransaction.getResources((Object)this.poolInfo);
                    if (!this.blocked || resourcesSet != null && !resourcesSet.isEmpty()) {
                        try {
                            result = this.internalGetResource(spec, alloc, transaction);
                        }
                        finally {
                            this.gateway.acquiredResource();
                        }
                    }
                }
                if (result != null) {
                    if (this.poolLifeCycleListener != null) {
                        this.poolLifeCycleListener.connectionAcquired(result.getId());
                        elapsedWaitTime = System.currentTimeMillis() - startTime;
                        this.poolLifeCycleListener.connectionRequestServed(elapsedWaitTime);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Resource Pool: elapsed time (ms) to get connection for [" + String.valueOf(spec) + "] : " + elapsedWaitTime);
                        }
                    }
                    break block27;
                }
                if (this.maxWaitTime > 0) {
                    elapsedWaitTime = System.currentTimeMillis() - startTime;
                    if (elapsedWaitTime < (long)this.maxWaitTime) {
                        remainingWaitTime = (long)this.maxWaitTime - elapsedWaitTime;
                    } else if (!this.blocked) {
                        if (this.poolLifeCycleListener != null) {
                            this.poolLifeCycleListener.connectionTimedOut();
                        }
                        throw new PoolingException("No available resources and wait time " + this.maxWaitTime + " ms expired.");
                    }
                }
                if (this.blocked) break;
                Object waitMonitor = new Object();
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionRequestQueued();
                }
                object = waitMonitor;
                synchronized (object) {
                    this.waitQueue.addToQueue(waitMonitor);
                    try {
                        LOG.log(Level.FINE, "Resource Pool: getting on wait queue");
                        waitMonitor.wait(remainingWaitTime);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        break block27;
                    }
                    LOG.log(Level.FINE, "removing wait monitor from queue: {0}", waitMonitor);
                    if (this.waitQueue.removeFromQueue(waitMonitor) && this.poolLifeCycleListener != null) {
                        this.poolLifeCycleListener.connectionRequestDequeued();
                    }
                }
            }
            object = reconfigWaitMonitor = new Object();
            synchronized (object) {
                block28: {
                    this.reconfigWaitQueue.addToQueue(reconfigWaitMonitor);
                    try {
                        if (this.reconfigWaitTime <= 0L) break block28;
                        LOG.log(Level.FINEST, "[DRC] getting into reconfig wait queue for time [{0}]", this.reconfigWaitTime);
                        reconfigWaitMonitor.wait(this.reconfigWaitTime);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        break block27;
                    }
                }
                LOG.log(Level.FINEST, "[DRC] removing wait monitor from reconfig-wait-queue: {0}", reconfigWaitMonitor);
                this.reconfigWaitQueue.removeFromQueue(reconfigWaitMonitor);
                LOG.log(Level.FINEST, "[DRC] throwing Retryable-Unavailable-Exception");
                RetryableUnavailableException rue = new RetryableUnavailableException("Pool Reconfigured, Connection Factory can retry the lookup");
                rue.setErrorCode("POOL-RECONFIGURED-1");
                throw rue;
            }
        }
        alloc.fillInResourceObjects(result);
        return result;
    }

    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc) {
        return null;
    }

    protected ResourceHandle internalGetResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, Transaction transaction) throws PoolingException {
        ResourceHandle resourceHandle;
        if (!this.poolInitialized) {
            this.initPool(resourceAllocator);
        }
        if ((resourceHandle = this.getResourceFromTransaction(transaction, resourceAllocator, resourceSpec)) != null) {
            return resourceHandle;
        }
        resourceHandle = this.prefetch(resourceSpec, resourceAllocator);
        if (resourceHandle != null) {
            return resourceHandle;
        }
        resourceHandle = this.getUnenlistedResource(resourceSpec, resourceAllocator);
        if (resourceHandle != null) {
            resourceHandle.getResourceState().incrementUsageCount();
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionUsed(resourceHandle.getId());
                this.poolLifeCycleListener.decrementNumConnFree();
            }
        }
        return resourceHandle;
    }

    private ResourceHandle getResourceFromTransaction(Transaction transaction, ResourceAllocator resourceAllocator, ResourceSpec resourceSpec) {
        JavaEETransaction javaEETransaction;
        if (transaction == null || !resourceAllocator.shareableWithinComponent()) {
            return null;
        }
        try {
            javaEETransaction = (JavaEETransaction)transaction;
        }
        catch (ClassCastException e) {
            LOG.log(Level.SEVERE, "Pool: getResource : transaction is not JavaEETransaction but a " + transaction.getClass().getName(), e);
            return null;
        }
        Set set = javaEETransaction.getResources((Object)this.poolInfo);
        if (set == null) {
            return null;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ResourceHandle resourceHandle = (ResourceHandle)iter.next();
            if (resourceHandle.hasConnectionErrorOccurred()) {
                iter.remove();
                continue;
            }
            ResourceState state = resourceHandle.getResourceState();
            if (!resourceHandle.getResourceAllocator().shareableWithinComponent() || !resourceSpec.isXA() && !this.poolTxHelper.isNonXAResourceAndFree(javaEETransaction, resourceHandle)) continue;
            if (this.matchConnections) {
                if (!resourceAllocator.matchConnection(resourceHandle)) {
                    if (this.poolLifeCycleListener == null) continue;
                    this.poolLifeCycleListener.connectionNotMatched();
                    continue;
                }
                if (resourceHandle.hasConnectionErrorOccurred()) {
                    if (this.failAllConnections) break;
                    iter.remove();
                    continue;
                }
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionMatched();
                }
            }
            if (!state.isBusy()) {
                this.setResourceStateToBusy(resourceHandle);
            }
            return resourceHandle;
        }
        return null;
    }

    protected ResourceHandle getUnenlistedResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        return this.getUnenlistedResource(resourceAllocator);
    }

    protected boolean isConnectionValid(ResourceHandle resourceHandle, ResourceAllocator resourceAllocator) {
        boolean validationRequired;
        if (!this.connectionValidationRequired && !this.validateAtmostEveryIdleSecs) {
            return true;
        }
        long validationPeriod = this.connectionValidationRequired ? this.validateAtmostPeriodInMilliSeconds_ : this.idletime;
        long currentTime = System.currentTimeMillis();
        ResourceState state = resourceHandle.getResourceState();
        if (validationPeriod <= 0L) {
            validationRequired = true;
        } else {
            boolean bl = validationRequired = currentTime - state.getLastValidated() >= validationPeriod;
        }
        if (validationRequired) {
            if (resourceAllocator.isConnectionValid(resourceHandle)) {
                state.setLastValidated(currentTime);
            } else {
                this.incrementNumConnFailedValidation();
                return false;
            }
        }
        return true;
    }

    protected boolean matchConnection(ResourceHandle resource, ResourceAllocator resourceAllocator) {
        if (!this.matchConnections) {
            return true;
        }
        boolean matched = resourceAllocator.matchConnection(resource);
        if (this.poolLifeCycleListener != null) {
            if (matched) {
                this.poolLifeCycleListener.connectionMatched();
            } else {
                this.poolLifeCycleListener.connectionNotMatched();
            }
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandle getUnenlistedResource(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle resourceFromPool = null;
        ArrayList<ResourceHandle> freeResources = new ArrayList<ResourceHandle>();
        try {
            ResourceHandle resourceHandle;
            this.getResourceFromPoolAndFreeResourceMethodsLock.lock();
            try {
                while ((resourceHandle = this.dataStructure.getResource()) != null) {
                    this.makeSureResourceIsNotBusy(resourceHandle);
                    if (resourceHandle.isEnlisted()) {
                        freeResources.add(resourceHandle);
                        continue;
                    }
                    if (resourceHandle.hasConnectionErrorOccurred()) {
                        this.dataStructure.removeResource(resourceHandle);
                        continue;
                    }
                    if (this.matchConnection(resourceHandle, resourceAllocator)) {
                        boolean isValid = this.isConnectionValid(resourceHandle, resourceAllocator);
                        if (!isValid) {
                            if (this.failAllConnections) {
                                resourceFromPool = this.createSingleResourceAndAdjustPool(resourceAllocator);
                                break;
                            }
                            this.dataStructure.removeResource(resourceHandle);
                            continue;
                        }
                        if (resourceHandle.isShareable() == resourceAllocator.shareableWithinComponent()) {
                            resourceFromPool = resourceHandle;
                            break;
                        }
                        freeResources.add(resourceHandle);
                        continue;
                    }
                    freeResources.add(resourceHandle);
                }
            }
            finally {
                for (ResourceHandle freeResource : freeResources) {
                    if (freeResource.isEnlisted()) {
                        this.dataStructure.returnResource(freeResource);
                        continue;
                    }
                    this.returnResourceToPool(freeResource);
                }
                freeResources.clear();
            }
            if (resourceFromPool != null) {
                this.setResourceStateToBusy(resourceFromPool);
            } else {
                resourceFromPool = this.resizePoolAndGetNewResource(resourceAllocator);
            }
            if (resourceHandle != null) {
                this.makeSureResourceIsBusy(resourceHandle);
            }
            if (resourceHandle != null) {
                this.makeSureResourceIsNotEnlisted(resourceHandle);
            }
        }
        finally {
            this.getResourceFromPoolAndFreeResourceMethodsLock.unlock();
        }
        return resourceFromPool;
    }

    private void makeSureResourceIsBusy(ResourceHandle resourceHandle) {
        if (!resourceHandle.getResourceState().isBusy()) {
            throw new IllegalStateException("Resource must be marked busy! handle: " + String.valueOf(resourceHandle));
        }
    }

    private void makeSureResourceIsNotBusy(ResourceHandle resourceHandle) {
        if (resourceHandle.getResourceState().isBusy()) {
            throw new IllegalStateException("Resource may not be marked busy! handle: " + String.valueOf(resourceHandle));
        }
    }

    protected void makeSureResourceIsNotEnlisted(ResourceHandle resourceHandle) {
        if (resourceHandle.getResourceState().isEnlisted()) {
            throw new IllegalStateException("Resource may not be marked enlisted! handle: " + String.valueOf(resourceHandle));
        }
    }

    private ResourceHandle resizePoolAndGetNewResource(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle newResource = null;
        int numOfConnsToCreate = 0;
        int dataStructureSize = this.dataStructure.getResourcesSize();
        if (dataStructureSize < this.steadyPoolSize) {
            numOfConnsToCreate = this.steadyPoolSize - dataStructureSize;
        } else if (dataStructureSize + this.resizeQuantity <= this.maxPoolSize) {
            numOfConnsToCreate = this.resizeQuantity;
        } else if (dataStructureSize < this.maxPoolSize) {
            numOfConnsToCreate = this.maxPoolSize - dataStructureSize;
        }
        if (numOfConnsToCreate > 0) {
            this.createResources(resourceAllocator, numOfConnsToCreate);
            newResource = this.getMatchedResourceFromPool(resourceAllocator);
        } else if (this.dataStructure.getFreeListSize() > 0 && this.purgeResources(this.resizeQuantity) > 0) {
            newResource = this.resizePoolAndGetNewResource(resourceAllocator);
        }
        if (newResource != null) {
            this.makeSureResourceIsBusy(newResource);
            this.makeSureResourceIsNotEnlisted(newResource);
        }
        return newResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandle getMatchedResourceFromPool(ResourceAllocator alloc) {
        ResourceHandle matchedResourceFromPool = null;
        ArrayList<ResourceHandle> activeResources = new ArrayList<ResourceHandle>();
        try {
            ResourceHandle handle;
            while ((handle = this.dataStructure.getResource()) != null) {
                if (!handle.isEnlisted() && this.matchConnection(handle, alloc)) {
                    matchedResourceFromPool = handle;
                    this.setResourceStateToBusy(matchedResourceFromPool);
                    break;
                }
                activeResources.add(handle);
            }
        }
        finally {
            for (ResourceHandle activeResource : activeResources) {
                this.dataStructure.returnResource(activeResource);
            }
            activeResources.clear();
        }
        return matchedResourceFromPool;
    }

    private int purgeResources(int quantity) {
        int totalResourcesRemoved = 0;
        int freeResourcesCount = this.dataStructure.getFreeListSize();
        int resourcesCount = freeResourcesCount >= quantity ? quantity : freeResourcesCount;
        LOG.log(Level.FINE, "Purging resources of size: {0}", resourcesCount);
        for (int i = resourcesCount - 1; i >= 0; --i) {
            ResourceHandle resource = this.dataStructure.getResource();
            if (resource == null) continue;
            this.dataStructure.removeResource(resource);
            ++totalResourcesRemoved;
        }
        return totalResourcesRemoved;
    }

    private ResourceHandle createSingleResourceAndAdjustPool(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle handle = this.dataStructure.getResource();
        if (handle != null) {
            this.dataStructure.removeResource(handle);
        }
        this.addResource(resourceAllocator);
        return this.dataStructure.getResource();
    }

    protected ResourceHandle createSingleResource(ResourceAllocator resourceAllocator) throws PoolingException {
        int count = 0;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                ++count;
                ResourceHandle resourceHandle = resourceAllocator.createResource();
                long now = System.currentTimeMillis();
                LOG.log(Level.FINE, () -> "Time taken to create a single resource: " + resourceHandle.getResourceSpec().getResourceId() + " and adding to the pool: " + (now - startTime) + " ms.");
                if (this.connectionValidationRequired || this.validateAtmostEveryIdleSecs) {
                    resourceHandle.getResourceState().setLastValidated(now);
                }
                return resourceHandle;
            }
            catch (Exception ex) {
                if (!this.connectionCreationRetry_ || count > this.connectionCreationRetryAttempts_) {
                    throw new PoolingException("Connection creation failed for " + count + " times.", ex);
                }
                LOG.log(Level.WARNING, "Connection creation failed for " + count + " times. It will be retried in " + this.conCreationRetryInterval_ + " ms.", ex);
                try {
                    Thread.sleep(this.conCreationRetryInterval_);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    private void createResources(ResourceAllocator alloc, int size) throws PoolingException {
        for (int i = 0; i < size; ++i) {
            this.addResource(alloc);
        }
    }

    @Override
    public void setPoolLifeCycleListener(PoolLifeCycleListener listener) {
        this.poolLifeCycleListener = listener;
    }

    @Override
    public void removePoolLifeCycleListener() {
        this.poolLifeCycleListener = null;
    }

    @Override
    public void deleteResource(ResourceHandle resourceHandle) {
        try {
            resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unexpected exception while destroying resource from pool " + String.valueOf(this.poolInfo), e);
        }
        finally {
            if (resourceHandle.getResourceState().isBusy()) {
                this.leakDetector.stopConnectionLeakTracing(resourceHandle, this);
            }
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionDestroyed(resourceHandle.getId());
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolLifeCycleListener.decrementConnectionUsed(resourceHandle.getId());
                    if (!resourceHandle.isMarkedForReclaim()) {
                        this.poolLifeCycleListener.incrementNumConnFree(true, this.steadyPoolSize);
                    }
                } else {
                    this.poolLifeCycleListener.decrementNumConnFree();
                }
            }
        }
    }

    @Override
    public void resourceClosed(ResourceHandle handle) throws IllegalStateException {
        LOG.log(Level.FINE, "Resource was closed, processing handle: {0}", handle);
        ResourceState state = handle.getResourceState();
        if (!state.isBusy()) {
            LOG.log(Level.WARNING, "resourceClosed - Expecting 'state.isBusy(): true', but was false for handle: {0}", handle);
        }
        this.setResourceStateToFree(handle);
        state.setLastUsage(System.currentTimeMillis());
        if (!state.isEnlisted() || this.poolTxHelper.isNonXAResource(handle) && this.poolTxHelper.isLocalTransactionInProgress() && this.poolTxHelper.isLocalResourceEligibleForReuse(handle)) {
            this.freeUnenlistedResource(handle);
        }
        if (this.poolLifeCycleListener != null && !handle.getDestroyByLeakTimeOut()) {
            this.poolLifeCycleListener.connectionReleased(handle.getId());
        }
        LOG.log(Level.FINE, "Resource was freed after its closure: {0}", handle);
    }

    protected void performMaxConnectionUsageOperation(ResourceHandle handle) {
        this.dataStructure.removeResource(handle);
        LOG.log(Level.INFO, "Destroying connection {0} since it has reached the maximum usage of: {1}", new Object[]{handle.getId(), handle.getResourceState().getUsageCount()});
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.decrementConnectionUsed(handle.getId());
        }
        if (this.dataStructure.getResourcesSize() < this.steadyPoolSize) {
            try {
                this.addResource(handle.getResourceAllocator());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to create a new resource.", e);
            }
        }
    }

    protected void freeUnenlistedResource(ResourceHandle resourceHandle) {
        LOG.log(Level.FINE, "freeUnenlistedResource handle: {0}", resourceHandle);
        try {
            this.getResourceFromPoolAndFreeResourceMethodsLock.lock();
            if (this.cleanupResource(resourceHandle)) {
                if (this.maxConnectionUsage > 0 && resourceHandle.getResourceState().getUsageCount() >= this.maxConnectionUsage) {
                    this.performMaxConnectionUsageOperation(resourceHandle);
                } else {
                    this.returnResourceToPool(resourceHandle);
                    if (this.poolLifeCycleListener != null && !resourceHandle.getDestroyByLeakTimeOut()) {
                        this.poolLifeCycleListener.decrementConnectionUsed(resourceHandle.getId());
                        this.poolLifeCycleListener.incrementNumConnFree(false, this.steadyPoolSize);
                    }
                }
                this.notifyWaitingThreads();
            }
        }
        finally {
            this.getResourceFromPoolAndFreeResourceMethodsLock.unlock();
        }
    }

    protected void returnResourceToPool(ResourceHandle resourceHandle) {
        this.makeSureResourceIsNotBusy(resourceHandle);
        this.makeSureResourceIsNotEnlisted(resourceHandle);
        this.dataStructure.returnResource(resourceHandle);
    }

    protected boolean cleanupResource(ResourceHandle resource) {
        boolean cleanupSuccessful = true;
        try {
            ResourceAllocator alloc = resource.getResourceAllocator();
            alloc.cleanup(resource);
        }
        catch (PoolingException ex) {
            LOG.log(Level.WARNING, "Cleanup of a resource from pool [" + String.valueOf(this.poolInfo.getName()) + "] failed.", ex);
            cleanupSuccessful = false;
            this.resourceErrorOccurred(resource);
        }
        return cleanupSuccessful;
    }

    @Override
    public void resourceErrorOccurred(ResourceHandle resourceHandle) throws IllegalStateException {
        LOG.log(Level.FINE, "Resource error occured: {0}", resourceHandle);
        if (this.failAllConnections) {
            this.doFailAllConnectionsProcessing();
            return;
        }
        ResourceState state = resourceHandle.getResourceState();
        if (state == null) {
            throw new IllegalStateException("Resource handle state is null, but cannot!");
        }
        this.setResourceStateToFree(resourceHandle);
        state.setLastUsage(System.currentTimeMillis());
        this.dataStructure.removeResource(resourceHandle);
        this.notifyWaitingThreads();
    }

    private void doFailAllConnectionsProcessing() {
        LOG.log(Level.FINE, "doFailAllConnectionsProcessing()");
        this.cancelResizerTask();
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionValidationFailed(this.dataStructure.getResourcesSize());
        }
        this.emptyPool();
        try {
            this.createResources(this.allocator, this.steadyPoolSize);
            LOG.log(Level.FINE, "Successfully created new resources.");
        }
        catch (PoolingException pe) {
            LOG.log(Level.FINE, "Could not create " + this.steadyPoolSize + " resources.", pe);
        }
        this.scheduleResizerTask();
    }

    @Override
    public void resourceEnlisted(Transaction tran, ResourceHandle resource) throws IllegalStateException {
        this.poolTxHelper.resourceEnlisted(tran, resource);
    }

    @Override
    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        List<ResourceHandle> delistedResources = this.poolTxHelper.transactionCompleted(tran, status, this.poolInfo);
        for (ResourceHandle resource : delistedResources) {
            if (!this.isResourceUnused(resource)) continue;
            this.freeUnenlistedResource(resource);
        }
    }

    protected boolean isResourceUnused(ResourceHandle h) {
        return !h.getResourceState().isBusy();
    }

    @Override
    public ResourceHandle createResource(ResourceAllocator alloc) throws PoolingException {
        ResourceHandle result = this.createSingleResource(alloc);
        result.getResourceState().reset();
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionCreated();
        }
        return result;
    }

    @Override
    public void createResourceAndAddToPool() throws PoolingException {
        this.addResource(this.allocator);
    }

    @Override
    public Set<ManagedConnection> getInvalidConnections(Set<ManagedConnection> connections) throws ResourceException {
        return this.allocator.getInvalidConnections(connections);
    }

    @Override
    public void invalidConnectionDetected(ResourceHandle h) {
        this.incrementNumConnFailedValidation();
    }

    @Override
    public void resizePool(boolean forced) {
        this.resizerTask.resizePool(forced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThreads() {
        Object waitMonitor = null;
        Object object = this.waitQueue;
        synchronized (object) {
            if (this.waitQueue.getQueueLength() > 0) {
                waitMonitor = this.waitQueue.remove();
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionRequestDequeued();
                }
            }
        }
        if (waitMonitor == null) {
            LOG.log(Level.FINE, "Wait monitor is null");
        } else {
            object = waitMonitor;
            synchronized (object) {
                LOG.log(Level.FINE, "Notifying wait monitor: {0}", waitMonitor);
                waitMonitor.notifyAll();
            }
        }
    }

    private void incrementNumConnFailedValidation() {
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionValidationFailed(1);
        }
    }

    @Override
    public void emptyPool() {
        LOG.log(Level.FINE, "Emptying pool {0}", this.poolInfo.getName());
        this.dataStructure.removeAll();
    }

    @Override
    public void emptyFreeConnectionsInPool() {
        ResourceHandle h;
        LOG.log(Level.FINE, "Emptying free connections in the pool {0}", this.poolInfo.getName());
        while ((h = this.dataStructure.getResource()) != null) {
            this.dataStructure.removeResource(h);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pool [");
        sb.append(this.poolInfo);
        sb.append("] PoolSize=");
        sb.append(this.dataStructure.getResourcesSize());
        sb.append("  FreeResources=");
        sb.append(this.dataStructure.getFreeListSize());
        sb.append("  QueueSize=");
        sb.append(this.waitQueue.getQueueLength());
        sb.append(" matching=");
        sb.append(this.matchConnections ? "on" : "off");
        sb.append(" validation=");
        sb.append(this.connectionValidationRequired ? "on" : "off");
        return sb.toString();
    }

    @Override
    public void blockRequests(long waitTimeout) {
        this.blocked = true;
        this.reconfigWaitTime = waitTimeout;
    }

    @Override
    public PoolWaitQueue getPoolWaitQueue() {
        return this.waitQueue;
    }

    @Override
    public PoolWaitQueue getReconfigWaitQueue() {
        return this.reconfigWaitQueue;
    }

    @Override
    public long getReconfigWaitTime() {
        return this.reconfigWaitTime;
    }

    @Override
    public synchronized boolean flushConnectionPool() throws PoolingException {
        LOG.log(Level.FINE, "Flushing Connection Pool {0}", this.poolInfo);
        if (!this.poolInitialized) {
            throw new PoolingException("Flush Connection Pool did not happen as pool " + String.valueOf(this.poolInfo) + " is not initialized");
        }
        this.cancelResizerTask();
        this.dataStructure.removeAll();
        this.scheduleResizerTask();
        this.increaseSteadyPoolSize(this.steadyPoolSize);
        LOG.log(Level.FINE, "Flush Connection Pool done");
        return true;
    }

    @Override
    public synchronized void reconfigurePool(ConnectorConnectionPool poolResource) throws PoolingException {
        int toKill;
        int _idleTime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        if (this.poolInitialized) {
            if ((long)_idleTime != this.idletime && _idleTime != 0) {
                this.idletime = _idleTime;
                this.scheduleResizerTask();
            }
            if (_idleTime == 0) {
                this.cancelResizerTask();
            }
        }
        this.idletime = _idleTime;
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.connectionValidationRequired = poolResource.isIsConnectionValidationRequired();
        this.failAllConnections = poolResource.isFailAllConnections();
        this.setAdvancedPoolConfiguration(poolResource);
        int _maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        int oldMaxPoolSize = this.maxPoolSize;
        this.maxPoolSize = _maxPoolSize < this.steadyPoolSize ? this.steadyPoolSize : _maxPoolSize;
        if (oldMaxPoolSize != this.maxPoolSize) {
            this.dataStructure.setMaxSize(this.maxPoolSize);
        }
        int _steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        int oldSteadyPoolSize = this.steadyPoolSize;
        this.steadyPoolSize = _steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : _steadyPoolSize;
        if (this.poolInitialized && (toKill = this.dataStructure.getResourcesSize() - this.maxPoolSize) > 0) {
            this.killExtraResources(toKill);
        }
        this.reconfigureSteadyPoolSize(oldSteadyPoolSize, _steadyPoolSize);
    }

    protected void reconfigureSteadyPoolSize(int oldSteadyPoolSize, int newSteadyPoolSize) throws PoolingException {
        if (oldSteadyPoolSize != this.steadyPoolSize && this.poolInitialized && oldSteadyPoolSize < this.steadyPoolSize) {
            this.increaseSteadyPoolSize(newSteadyPoolSize);
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionsFreed(this.steadyPoolSize);
            }
        }
    }

    private void setAdvancedPoolConfiguration(ConnectorConnectionPool poolResource) {
        boolean connectionLeakTracing_;
        this.matchConnections = poolResource.matchConnections();
        this.preferValidateOverRecreate = poolResource.isPreferValidateOverRecreate();
        this.maxConnectionUsage = Integer.parseInt(poolResource.getMaxConnectionUsage());
        this.connectionCreationRetryAttempts_ = Integer.parseInt(poolResource.getConCreationRetryAttempts());
        this.conCreationRetryInterval_ = (long)Integer.parseInt(poolResource.getConCreationRetryInterval()) * 1000L;
        this.connectionCreationRetry_ = this.connectionCreationRetryAttempts_ > 0;
        this.validateAtmostPeriodInMilliSeconds_ = (long)Integer.parseInt(poolResource.getValidateAtmostOncePeriod()) * 1000L;
        boolean connectionLeakReclaim_ = poolResource.isConnectionReclaim();
        long connectionLeakTimeoutInMilliSeconds_ = (long)Integer.parseInt(poolResource.getConnectionLeakTracingTimeout()) * 1000L;
        boolean bl = connectionLeakTracing_ = connectionLeakTimeoutInMilliSeconds_ > 0L;
        if (this.leakDetector == null) {
            this.leakDetector = new ConnectionLeakDetector(this.poolInfo, connectionLeakTracing_, connectionLeakTimeoutInMilliSeconds_, connectionLeakReclaim_);
        } else {
            this.leakDetector.reset(connectionLeakTracing_, connectionLeakTimeoutInMilliSeconds_, connectionLeakReclaim_);
        }
    }

    private void killExtraResources(int numToKill) {
        ResourceHandle h;
        this.cancelResizerTask();
        for (int i = 0; i < numToKill && (h = this.dataStructure.getResource()) != null; ++i) {
            this.dataStructure.removeResource(h);
        }
        this.scheduleResizerTask();
    }

    private void increaseSteadyPoolSize(int newSteadyPoolSize) throws PoolingException {
        this.cancelResizerTask();
        for (int i = this.dataStructure.getResourcesSize(); i < newSteadyPoolSize; ++i) {
            this.addResource(this.allocator);
        }
        this.scheduleResizerTask();
    }

    @Override
    public void switchOnMatching() {
        this.matchConnections = true;
    }

    @Override
    public final PoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    @Override
    public synchronized void cancelResizerTask() {
        LOG.log(Level.FINE, "Cancelling resizer task.");
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
        }
        this.resizerTask = null;
        if (this.resizerTaskTimer != null) {
            this.resizerTaskTimer.purge();
        }
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getResizeQuantity() {
        return this.resizeQuantity;
    }

    @Override
    public long getIdleTimeout() {
        return this.idletime;
    }

    @Override
    public int getWaitQueueLength() {
        return this.waitQueue.getQueueLength();
    }

    @Override
    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxPoolSize(int size) {
        if (size < this.dataStructure.getResourcesSize()) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                int toKill = this.dataStructure.getResourcesSize() - size;
                if (toKill > 0) {
                    try {
                        this.killExtraResources(toKill);
                    }
                    catch (Exception re) {
                        LOG.log(Level.FINE, "setMaxPoolSize:: killExtraResources throws exception!", re);
                    }
                }
            }
        }
        this.maxPoolSize = size;
    }

    @Override
    public void setSteadyPoolSize(int size) {
        this.steadyPoolSize = size;
    }

    @Override
    public void potentialConnectionLeakFound() {
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.foundPotentialConnectionLeak();
        }
    }

    @Override
    public void printConnectionLeakTrace(StringBuffer stackTrace) {
        if (this.poolLifeCycleListener != null) {
            stackTrace.append('\n');
            stackTrace.append("Monitoring Statistics: ");
            stackTrace.append('\n');
            this.poolLifeCycleListener.toString(stackTrace);
        }
    }

    @Override
    public void reclaimConnection(ResourceHandle handle) {
        LOG.log(Level.INFO, "Reclaiming the leaked connection of pool [{0}] and destroying it so as to avoid both the application that leaked the connection and any other request that can potentially acquire the same connection from the pool end up using the connection at the same time", this.poolInfo.getName());
        this.dataStructure.removeResource(handle);
        handle.setDestroyByLeakTimeOut(true);
        this.notifyWaitingThreads();
    }

    @Override
    public PoolStatus getPoolStatus() {
        PoolStatus poolStatus = new PoolStatus(this.poolInfo);
        int numFree = this.poolInitialized ? this.dataStructure.getFreeListSize() : 0;
        int numUsed = this.poolInitialized ? this.dataStructure.getResourcesSize() - this.dataStructure.getFreeListSize() : 0;
        poolStatus.setNumConnFree(numFree);
        poolStatus.setNumConnUsed(numUsed);
        return poolStatus;
    }
}

