/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.StartupContext;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigurationCleanup;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.DasReaderFilter;
import org.glassfish.config.support.DomainXmlPreParser;
import org.glassfish.config.support.InstanceReaderFilter;
import org.glassfish.config.support.ServerReaderFilter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigPopulatorException;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.Populator;

public abstract class DomainXml
implements Populator {
    private static final Logger LOG = ConfigApiLoggerInfo.getLogger();
    @Inject
    StartupContext context;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    @Optional
    private ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;

    protected abstract DomDocument getDomDocument();

    public void run(ConfigParser parser) throws ConfigPopulatorException {
        ClassLoader parentClassLoader;
        LOG.log(Level.FINE, "NCLS-CFGAPI-00083", this.getClass().getName());
        ClassLoader classLoader = parentClassLoader = this.registry == null ? this.getClass().getClassLoader() : this.registry.getParentClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.habitat, (Object)parentClassLoader, null, (Type[])new Type[]{ClassLoader.class});
        String instance = this.env.getInstanceName();
        URL domainURL = null;
        try {
            domainURL = this.getDomainXml(this.env);
            this.parseDomainXml(parser, domainURL, instance);
        }
        catch (NoBackupException ex) {
            throw new ConfigPopulatorException("Failed to parse domain.xml", (Throwable)ex);
        }
        catch (Throwable ex) {
            if (domainURL == null || this.isBackupFile(domainURL)) {
                throw new ConfigPopulatorException("Failed to parse domain.xml", ex);
            }
            try {
                domainURL = this.getAlternativeDomainXml(this.env);
                this.parseDomainXml(parser, this.getAlternativeDomainXml(this.env), instance);
            }
            catch (Throwable e) {
                e.addSuppressed(ex);
                throw new ConfigPopulatorException("Failed to parse domain.xml", e);
            }
        }
        if (this.isBackupFile(domainURL)) {
            Path destination = this.env.getConfigDirPath().toPath().resolve("domain.xml");
            Path backup = this.env.getConfigDirPath().toPath().resolve("domain.xml.bak");
            try {
                Files.move(backup, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Restoring backup failed!", e);
            }
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        for (ServiceHandle cc : this.habitat.getAllServiceHandles(ConfigurationCleanup.class, new Annotation[0])) {
            try {
                cc.getService();
                LOG.log(Level.FINE, "NCLS-CFGAPI-00084", cc.getClass());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "NCLS-CFGAPI-00085", new Object[]{cc.getClass(), e});
                LOG.log(Level.FINE, "Cleaning the domain.xml failed!", e);
            }
        }
        this.decorate();
    }

    protected boolean isBackupFile(URL url) {
        return url.getPath().endsWith("domain.xml.bak");
    }

    protected void decorate() {
        Server server = (Server)this.habitat.getService(Server.class, this.env.getInstanceName(), new Annotation[0]);
        if (server == null) {
            LOG.log(Level.SEVERE, "NCLS-CFGAPI-00086", this.env.getInstanceName());
            return;
        }
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.habitat, (Object)server, (String)"default-instance-name", (Type[])new Type[]{Server.class});
        server.getConfig().addIndex(this.habitat, "default-instance-name");
        Cluster c = server.getCluster();
        if (c != null) {
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.habitat, (Object)c, (String)"default-instance-name", (Type[])new Type[]{Cluster.class});
        }
    }

    protected void upgrade() {
        for (ServiceHandle cu : this.habitat.getAllServiceHandles(ConfigurationUpgrade.class, new Annotation[0])) {
            try {
                cu.getService();
                LOG.log(Level.FINE, "NCLS-CFGAPI-00087", cu.getClass());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "NCLS-CFGAPI-00088", new Object[]{cu.getClass(), e});
                LOG.log(Level.FINE, "Upgrade of the domain.xml failed!", e);
            }
        }
    }

    private boolean checkDomainFile(File domainFile, Supplier<String> errorMessage) {
        if (domainFile.exists() && domainFile.length() > 0L) {
            return true;
        }
        LOG.log(Level.SEVERE, errorMessage.get());
        return false;
    }

    protected URL getAlternativeDomainXml(ServerEnvironmentImpl env) throws IOException {
        File domainXml = new File(env.getConfigDirPath(), "domain.xml.bak");
        if (this.checkDomainFile(domainXml, () -> "NCLS-CFGAPI-00090")) {
            return domainXml.toURI().toURL();
        }
        throw new NoBackupException(env.getConfigDirPath());
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        File domainXml = new File(env.getConfigDirPath(), "domain.xml");
        if (this.checkDomainFile(domainXml, () -> "NCLS-CFGAPI-00089")) {
            return domainXml.toURI().toURL();
        }
        return this.getAlternativeDomainXml(env);
    }

    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        long startNano = System.nanoTime();
        try {
            this.xif.setXMLResolver(new XMLResolver(){

                @Override
                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return new ByteArrayInputStream(new byte[0]);
                }
            });
            try (ServerReaderFilter readerFilter = this.createReaderFilter(domainXml);){
                parser.parse((XMLStreamReader)readerFilter, this.getDomDocument());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse " + String.valueOf(domainXml), e);
        }
        LOG.log(Level.CONFIG, "NCLS-CFGAPI-00092", System.nanoTime() - startNano);
    }

    private ServerReaderFilter createReaderFilter(URL domainXml) throws XMLStreamException, DomainXmlPreParser.DomainXmlPreParserException {
        if (this.env.getRuntimeType() == RuntimeType.DAS || this.env.getRuntimeType() == RuntimeType.EMBEDDED) {
            return new DasReaderFilter(domainXml, this.xif);
        }
        if (this.env.getRuntimeType() == RuntimeType.INSTANCE) {
            return new InstanceReaderFilter(this.env.getInstanceName(), domainXml, this.xif);
        }
        throw new RuntimeException("Unknown server type: " + String.valueOf(this.env.getRuntimeType()));
    }

    private static class NoBackupException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private NoBackupException(File configDirectory) {
            super("No usable configuration file at " + configDirectory.getAbsolutePath());
        }
    }
}

