/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;

public class RecordInstantiationPolicy<T extends Record>
extends InstantiationPolicy {
    private Class<T> clazz;
    private List<?> values;

    public RecordInstantiationPolicy() {
    }

    public RecordInstantiationPolicy(Class<T> clazz) {
        this();
        this.clazz = clazz;
    }

    @Override
    public Object buildNewInstance() throws DescriptorException {
        try {
            if (this.values == null) {
                Object var1_1 = null;
                return var1_1;
            }
            T t = this.newRecord(this.clazz, this.values);
            return t;
        }
        finally {
            this.values = null;
        }
    }

    @Override
    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        throw new UnsupportedOperationException();
    }

    private T newRecord(Class<T> clazz, List<?> values) {
        RecordComponent[] recordComponents;
        ArrayList types = new ArrayList();
        for (RecordComponent recordComponent : recordComponents = clazz.getRecordComponents()) {
            types.add(recordComponent.getType());
        }
        try {
            Constructor<T> canonical = clazz.getDeclaredConstructor((Class[])types.toArray(Class[]::new));
            Record result = (Record)canonical.newInstance(values.toArray(Object[]::new));
            return (T)result;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("New Record creation failed: " + String.valueOf(e), e);
        }
    }

    public void setValues(List<?> values) {
        this.values = values;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }
}

