/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public final class Utility {
    private static final Logger LOG = CULoggerInfo.getLogger();
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(Utility.class);

    public static void checkJVMVersion() {
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value instanceof Optional) {
            return !((Optional)value).isPresent();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return value.toString() == null || value.toString().isEmpty();
    }

    public static boolean isAllEmpty(Object ... values) {
        for (Object value : values) {
            if (Utility.isEmpty(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(Object ... values) {
        for (Object value : values) {
            if (!Utility.isEmpty(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyNull(Object ... values) {
        for (Object value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!(object == null ? other == null : object.equals(other))) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(String file) throws IOException {
        InputStream is = ClassLoader.getSystemResourceAsStream(file);
        InputStream is2 = null;
        if (is != null) {
            Properties config = new Properties();
            config.load(is);
            Properties properties = config;
            return properties;
        }
        String remoteclient = "/" + file;
        is2 = Utility.class.getResourceAsStream(remoteclient);
        Properties config = new Properties();
        config.load(is2);
        Properties properties = config;
        return properties;
        finally {
            try {
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getLocalHost() {
        String hostname = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostname = ia.getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
        return hostname;
    }

    public static String getLocalAddress() {
        String address = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            address = ia.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
        return address;
    }

    public static Remote lookupObject(String publishedName, Class anInterface) throws NamingException {
        InitialContext ic = new InitialContext();
        Object objRef = ic.lookup(publishedName);
        return (Remote)PortableRemoteObject.narrow((Object)objRef, (Class)anInterface);
    }

    public static char[] toCharArray(CharBuffer cb) {
        return cb.toString().toCharArray();
    }

    public static byte[] toByteArray(ByteBuffer bb) {
        byte[] result = new byte[bb.limit() - bb.position()];
        bb.get(result);
        return result;
    }

    public static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset++] << 24 & 0xFF000000;
        int b2 = array[offset++] << 16 & 0xFF0000;
        int b3 = array[offset++] << 8 & 0xFF00;
        int b4 = array[offset++] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    public static void intToBytes(int value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 24 & 0xFF);
        array[offset++] = (byte)(value >>> 16 & 0xFF);
        array[offset++] = (byte)(value >>> 8 & 0xFF);
        array[offset++] = (byte)(value >>> 0 & 0xFF);
    }

    public static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)Utility.bytesToInt(array, offset) << 32;
        long l2 = (long)Utility.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    public static void longToBytes(long value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 56 & 0xFFL);
        array[offset++] = (byte)(value >>> 48 & 0xFFL);
        array[offset++] = (byte)(value >>> 40 & 0xFFL);
        array[offset++] = (byte)(value >>> 32 & 0xFFL);
        array[offset++] = (byte)(value >>> 24 & 0xFFL);
        array[offset++] = (byte)(value >>> 16 & 0xFFL);
        array[offset++] = (byte)(value >>> 8 & 0xFFL);
        array[offset++] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void invokeApplicationMain(Class mainClass, String[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String err = I18N.getLocalString("utility.no.main", "", mainClass);
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException msme) {
            LOG.log(Level.SEVERE, "NCLS-COMUTIL-00025", msme);
            throw new ClassNotFoundException(err);
        }
        int modifiers = mainMethod.getModifiers();
        if (!(Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && mainMethod.getReturnType().equals(Void.TYPE))) {
            err = I18N.getLocalString("utility.main.invalid", "The main method signature is invalid");
            LOG.log(Level.SEVERE, "NCLS-COMUTIL-00026");
            throw new ClassNotFoundException(err);
        }
        Object[] params = new Object[]{args};
        mainMethod.invoke(null, params);
    }

    public static void invokeSetMethod(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cl = obj.getClass();
        String setMeth = "set" + prop.substring(0, 1).toUpperCase(Locale.US) + prop.substring(1);
        try {
            Class[] cldef = new Class[]{String.class};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = new Object[]{value};
            meth.invoke(obj, params);
            return;
        }
        catch (NoSuchMethodException ex) {
            try {
                Class[] cldef = new Class[]{Integer.TYPE};
                Method meth = cl.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Integer.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
            catch (NoSuchMethodException nsmex) {
                Class[] cldef = new Class[]{Boolean.TYPE};
                Method meth = cl.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Boolean.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
        }
    }

    public static void invokeSetMethodCaseInsensitive(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String alternateMethodName = null;
        Class<?> cl = obj.getClass();
        String setMeth = "set" + prop;
        Method[] methodsList = cl.getMethods();
        boolean methodFound = false;
        int i = 0;
        for (i = 0; i < methodsList.length; ++i) {
            Class<?>[] parameterTypes;
            if (!methodsList[i].getName().equalsIgnoreCase(setMeth) || (parameterTypes = methodsList[i].getParameterTypes()).length != 1) continue;
            if (parameterTypes[0].getName().equals("java.lang.String")) {
                methodFound = true;
                break;
            }
            alternateMethodName = methodsList[i].getName();
        }
        if (methodFound) {
            Object[] params = new Object[]{value};
            methodsList[i].invoke(obj, params);
            return;
        }
        if (alternateMethodName != null) {
            try {
                Class[] cldef = new Class[]{Integer.TYPE};
                Method meth = cl.getMethod(alternateMethodName, cldef);
                Object[] params = new Object[]{Integer.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
            catch (NoSuchMethodException nsmex) {
                Class[] cldef = new Class[]{Boolean.TYPE};
                Method meth = cl.getMethod(alternateMethodName, cldef);
                Object[] params = new Object[]{Boolean.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
        }
        throw new NoSuchMethodException(setMeth);
    }

    public static short intToShort(int value) {
        if (value > Short.MAX_VALUE) {
            return (short)(value - 65536);
        }
        return (short)value;
    }

    public static int shortToInt(short value) {
        if (value < 0) {
            return value + 65536;
        }
        return value;
    }

    public static ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return Utility.getClassLoader().loadClass(className);
    }

    public static ClassLoader setContextClassLoader(ClassLoader classLoader) {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        if (classLoader == original) {
            return classLoader;
        }
        LOG.log(Level.FINER, "setContextClassLoader(classLoader={0}; original: {1})", new Object[]{classLoader, original});
        currentThread.setContextClassLoader(classLoader);
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithContextClassLoader(ClassLoader contextClassLoader, Supplier<T> action) {
        ClassLoader originalClassLoader = null;
        try {
            originalClassLoader = Utility.setContextClassLoader(contextClassLoader, originalClassLoader);
            T t = action.get();
            return t;
        }
        finally {
            Utility.resetContextClassLoder(originalClassLoader);
        }
    }

    public static <E extends Exception> void runWithContextClassLoader(ClassLoader contextClassLoader, RunnableWithException<E> action) throws E {
        ClassLoader originalClassLoader = null;
        try {
            originalClassLoader = Utility.setContextClassLoader(contextClassLoader, originalClassLoader);
            action.run();
        }
        finally {
            Utility.resetContextClassLoder(originalClassLoader);
        }
    }

    private static ClassLoader setContextClassLoader(ClassLoader contextClassLoader, ClassLoader originalClassLoader) {
        if (contextClassLoader != null) {
            originalClassLoader = Utility.setContextClassLoader(contextClassLoader);
        }
        return originalClassLoader;
    }

    private static void resetContextClassLoder(ClassLoader originalClassLoader) {
        if (originalClassLoader != null) {
            Utility.setContextClassLoader(originalClassLoader);
        }
    }

    public static String getEnvOrProp(String name) {
        String envVal = System.getenv(name);
        String sysPropVal = System.getProperty(name);
        if (sysPropVal != null) {
            return sysPropVal;
        }
        return envVal;
    }

    public static char[] convertByteArrayToCharArray(byte[] byteArray, Charset charset) throws CharacterCodingException {
        if (byteArray == null) {
            return null;
        }
        byte[] bArray = (byte[])byteArray.clone();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bArray);
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = null;
        try {
            charBuffer = decoder.decode(byteBuffer);
        }
        catch (CharacterCodingException cce) {
            throw cce;
        }
        catch (Throwable t) {
            CharacterCodingException e = new CharacterCodingException();
            e.initCause(t);
            throw e;
        }
        char[] result = Utility.toCharArray(charBuffer);
        Utility.clear(byteBuffer);
        Utility.clear(charBuffer);
        return result;
    }

    public static byte[] convertCharArrayToByteArray(char[] charArray, Charset charset) throws CharacterCodingException {
        if (charArray == null) {
            return null;
        }
        char[] cArray = (char[])charArray.clone();
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CharsetEncoder encoder = charset.newEncoder();
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = encoder.encode(charBuffer);
        }
        catch (CharacterCodingException cce) {
            throw cce;
        }
        catch (Exception e) {
            CharacterCodingException cce = new CharacterCodingException();
            cce.initCause(e);
            throw cce;
        }
        byte[] result = new byte[byteBuffer.remaining()];
        byteBuffer.get(result);
        Utility.clear(byteBuffer);
        Utility.clear(charBuffer);
        return (byte[])result.clone();
    }

    private static void clear(ByteBuffer byteBuffer) {
        byte[] bytes = byteBuffer.array();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
    }

    private static void clear(CharBuffer charBuffer) {
        char[] chars = charBuffer.array();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 48;
        }
    }

    public static interface RunnableWithException<E extends Exception> {
        public void run() throws E;
    }
}

