/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.scoping;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.mwe2.language.scoping.IInjectableFeatureLookup;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectableFeatureLookup
implements IInjectableFeatureLookup {
    @Override
    public Map<QualifiedName, JvmFeature> getInjectableFeatures(JvmType type) {
        HashMap result = Maps.newHashMap();
        this.collectFeatures(type, result);
        return ImmutableMap.copyOf((Map)result);
    }

    public void collectFeatures(JvmType containerType, Map<QualifiedName, JvmFeature> result) {
        if (containerType == null || containerType.eIsProxy()) {
            return;
        }
        if (containerType instanceof JvmDeclaredType) {
            EList superTypes = ((JvmDeclaredType)containerType).getSuperTypes();
            for (JvmTypeReference superType : superTypes) {
                if (superType.getType() == null) continue;
                this.collectFeatures(superType.getType(), result);
            }
            EList members = ((JvmDeclaredType)containerType).getMembers();
            for (JvmMember member : members) {
                JvmOperation op;
                String simpleName;
                if (!(member instanceof JvmOperation) || (simpleName = (op = (JvmOperation)member).getSimpleName()) == null || simpleName.length() <= 3 || !simpleName.startsWith("add") && !simpleName.startsWith("set") || op.getParameters().size() != 1) continue;
                String name = Strings.toFirstLower((String)op.getSimpleName().substring(3));
                result.put(QualifiedName.create((String)name), (JvmFeature)op);
            }
        }
    }
}

