/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.refactor.metrics.uml24.est;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

public class AAEATKL
implements IMetricCalculator {
    private List<EObject> context;

    public void setContext(List<EObject> context) {
        this.context = context;
    }

    public double calculate() {
        Class cl = (Class)this.context.get(0);
        double result = 0.0;
        EList<Class> otherClasses = this.getOtherClassses(cl);
        if (otherClasses.isEmpty()) {
            return result;
        }
        Double[] maxEqualAttributes = new Double[otherClasses.size()];
        int i = 0;
        while (i < maxEqualAttributes.length) {
            maxEqualAttributes[i] = 0.0;
            ++i;
        }
        for (Property attr : cl.getOwnedAttributes()) {
            int i2 = 0;
            while (i2 < otherClasses.size()) {
                if (this.containsEqualAttribute((Class)otherClasses.get(i2), attr)) {
                    int n = i2;
                    maxEqualAttributes[n] = maxEqualAttributes[n] + 1.0;
                }
                ++i2;
            }
        }
        result = this.max(maxEqualAttributes);
        return result;
    }

    private double max(Double[] doubleArray) {
        Double result = 0.0;
        int i = 0;
        while (i < doubleArray.length) {
            if (doubleArray[i] > result) {
                result = doubleArray[i];
            }
            ++i;
        }
        return result;
    }

    private boolean containsEqualAttribute(Class c, Property attr) {
        boolean contains = false;
        for (Property att : c.getOwnedAttributes()) {
            if (!this.haveEqualNames(attr, att) || !this.haveEqualTypes(attr, att) || !this.haveEqualVisibility(attr, att) || !this.haveEqualMultiplicities(attr, att)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private boolean haveEqualMultiplicities(Property attr, Property att) {
        return attr.getLower() == att.getLower() && attr.getUpper() == att.getUpper();
    }

    private boolean haveEqualVisibility(Property attr, Property att) {
        return attr.getVisibility().equals((Object)att.getVisibility());
    }

    private boolean haveEqualTypes(Property attr, Property att) {
        return att.getType() == null && attr.getType() == null || att.getType() != null && attr.getType() != null && att.getType().equals(attr.getType());
    }

    private boolean haveEqualNames(Property attr, Property att) {
        if (attr == null || att == null) {
            return false;
        }
        if (attr.getName() == null || att.getName() == null) {
            return false;
        }
        return att.getName().equals(attr.getName());
    }

    private EList<Class> getOtherClassses(Class cl) {
        BasicEList otherClasses = new BasicEList();
        TreeIterator iter = this.context.get(0).eResource().getAllContents();
        while (iter.hasNext()) {
            Class otherClass;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof Class) || (otherClass = (Class)eObject).equals(cl)) continue;
            otherClasses.add((Object)otherClass);
        }
        return otherClasses;
    }
}

