/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.refactor.metrics.uml24.est;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;

public class AVHM
implements IMetricCalculator {
    private List<EObject> context;

    public void setContext(List<EObject> context) {
        this.context = context;
    }

    public double calculate() {
        Model in = (Model)this.context.get(0);
        double ret = 0.0;
        ArrayList<Class> classes = this.getAllClasses(in);
        for (Class cl : classes) {
            if (!this.isSuperclass(cl) || !cl.getGeneralizations().isEmpty()) continue;
            ret += 1.0;
        }
        return ret;
    }

    private boolean isSuperclass(Class clazz) {
        ArrayList<Class> classes = this.getAllClasses(clazz.getModel());
        for (Class cl : classes) {
            if (!cl.getSuperClasses().contains((Object)clazz)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Class> getAllClasses(Model model) {
        ArrayList<Class> classes = new ArrayList<Class>();
        TreeIterator iter = model.eResource().getAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof Class)) continue;
            classes.add((Class)eObject);
        }
        return classes;
    }
}

