package pum.simuref.modeltocode.participant.java;

import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.refactor.refactorings.uml24.createclasswithattributesfromparameterlist.UmlParameterList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceParameterObjectDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.uml2.uml.Operation;

import pum.simuref.configuration.managers.MappingManager;
import pum.simuref.matching.Measurement;
import pum.simuref.modeltocode.RefactoringArgumentsMapUtil;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.utils.InformationsGui;
import pum.simuref.utils.Preferences;

public class IntroduceParameterObjectParticipant extends EmfJavaRefactoringParticipant {

	private static final String JAVAREFACTORINGID = IJavaRefactorings.INTRODUCE_PARAMETER_OBJECT;
	private IntroduceParameterObjectDescriptor refactoringDescriptor;
	
	private Operation fOperation;
	private UmlParameterList fUmlParameterList;
	private IMethod fIMethod;
	
	@Override
	protected boolean initialize(Object element) {
		fUmlParameterList = (UmlParameterList) fArguments.getEmfRefactoringArguments().getInPortByName(SELECTEDEOBJECT).getValue();
		fOperation = fUmlParameterList.getUmlParameters().get(0).getOperation();
		refactoringContribution = RefactoringCore.getRefactoringContribution(JAVAREFACTORINGID);
		setEmfToJavaMatching(Preferences.MATCHING_M2C_ALGO);
		
		Measurement.start();
		List<IMethod> candidates = matching.getMatchingIMethodsForEmfElement(fOperation);
		Measurement.stop();
		
		fIMethod = (IMethod) InformationsGui.checkCandidates(InformationsGui.INFORM_MODEL_TO_CODE, candidates);
		if (fIMethod == null) 
			return false;
			
		// M�glichkeit den Namen herzuleiten.
		String project = MappingManager.getInstance().getJavaProjectNameForEmfElement(fUmlParameterList.getEObject());
		String description = fArguments.toString();
		String comment = "Comment: " + fArguments.toString();
		int flags = 0;
		String input = fIMethod.getHandleIdentifier().replace("="+project, "");
	
		Map <String, String> arguments = RefactoringArgumentsMapUtil.getDefaultMap(JAVAREFACTORINGID);
		try {
			arguments = RefactoringArgumentsMapUtil.customizeMapIntroduceParameterObject(arguments, JAVAREFACTORINGID, input, 
					fIMethod.getCompilationUnit().getTypes()[0].getPackageFragment().getElementName() , 
					(String) fArguments.getEmfRefactoringArguments().getInPortByName("className").getValue(), 
					(String) fArguments.getEmfRefactoringArguments().getInPortByName("paramName").getValue());
			arguments = RefactoringArgumentsMapUtil.setParameterForIntroduceParameterObjectEnd(arguments, fUmlParameterList, fIMethod);
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
		refactoringDescriptor = (IntroduceParameterObjectDescriptor) refactoringContribution.createDescriptor(JAVAREFACTORINGID, project, description, comment, arguments, flags);

		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus = refactoringDescriptor.validateDescriptor();
		if (refactoringStatus.isOK()) {
			try {
				refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}

	@Override
	public String getName() {
		return "IntroduceParameterObjectParticipant";
	}

}
