package pum.simuref.modeltocode.participant.java;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.uml2.uml.Property;

import pum.simuref.matching.Measurement;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.utils.InformationsGui;
import pum.simuref.utils.Preferences;


public class RenameAttributeParticipant extends EmfJavaRefactoringParticipant {


	private static final String JAVAREFACTORINGID = IJavaRefactorings.RENAME_FIELD;
	private RenameJavaElementDescriptor refactoringDescriptor;

	private Property fProperty;
	private IField fIField;
	@Override
	protected boolean initialize(Object element) {
		fProperty = (Property) contextElement;
		refactoringContribution = RefactoringCore.getRefactoringContribution(JAVAREFACTORINGID);
		setEmfToJavaMatching(Preferences.MATCHING_M2C_ALGO);

		Measurement.start();
		List<IField> candidates = matching.getMatchingIFieldsForEmfElement(fProperty);
		Measurement.stop();
		
		fIField = (IField) InformationsGui.checkCandidates(InformationsGui.INFORM_MODEL_TO_CODE, candidates);
		
		if (fIField == null) 
			return false;
		
		refactoringDescriptor = (RenameJavaElementDescriptor) refactoringContribution.createDescriptor();
		refactoringDescriptor.setJavaElement(fIField);
		refactoringDescriptor.setUpdateReferences(true);
		refactoringDescriptor.setNewName((String) fArguments.getEmfRefactoringArguments().getInPortByName("newName").getValue());
		
		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus = refactoringDescriptor.validateDescriptor();
		if (refactoringStatus.isOK()) {
			try {
				refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}

	@Override
	public String getName() {
		return "RenameAttributeParticipant";
	}
}
