package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.examples.simpleWebModel.DataPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Entity;
import org.eclipse.emf.refactor.examples.simpleWebModel.IndexPage;
import org.eclipse.emf.refactor.examples.swm.xtext.techniques.SWMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

public class MissingDataPage implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// start custom code
		List<IndexPage> indexPages = SWMHelper.getAllIndexPages(root);
		List<DataPage> dataPages = SWMHelper.getAllDataPages(root);
		for (IndexPage indexPage : indexPages) {
			Entity entity = indexPage.getEntity();
			boolean referenced = false;
			for (DataPage dataPage : dataPages) {
				if (dataPage.getEntity() == entity) {
					referenced = true;
				}
			}
			if (! referenced) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(indexPage);
				result.add(entity);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
