package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.examples.simpleWebModel.IndexPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Link;
import org.eclipse.emf.refactor.examples.simpleWebModel.StaticPage;
import org.eclipse.emf.refactor.examples.swm.xtext.techniques.SWMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

public final class MissingLink implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// start custom code
		StaticPage startPage = SWMHelper.getStartPage(root);
		if (startPage == null) return results;
		List<IndexPage> indexPages = SWMHelper.getAllIndexPages(root);
		for (Link link : startPage.getLinks()) {
			indexPages.remove(link.getTarget());
		}
		for (IndexPage indexPage : indexPages) {
			LinkedList<EObject> result = new LinkedList<EObject>();
			result.add(indexPage);
			results.add(result);
		}
		// end custom code
		return results;
	}	
}