package org.eclipse.emf.refactor.examples.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.examples.services.SimpleWebModelGrammarAccess;
import org.eclipse.emf.refactor.examples.simpleWebModel.Attribute;
import org.eclipse.emf.refactor.examples.simpleWebModel.DataLayer;
import org.eclipse.emf.refactor.examples.simpleWebModel.DataPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Entity;
import org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer;
import org.eclipse.emf.refactor.examples.simpleWebModel.IndexPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Link;
import org.eclipse.emf.refactor.examples.simpleWebModel.Reference;
import org.eclipse.emf.refactor.examples.simpleWebModel.SimpleWebModelPackage;
import org.eclipse.emf.refactor.examples.simpleWebModel.StaticPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.WebModel;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class SimpleWebModelSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private SimpleWebModelGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == SimpleWebModelPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case SimpleWebModelPackage.ATTRIBUTE:
				if(context == grammarAccess.getAttributeRule()) {
					sequence_Attribute(context, (Attribute) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.DATA_LAYER:
				if(context == grammarAccess.getDataLayerRule()) {
					sequence_DataLayer(context, (DataLayer) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.DATA_PAGE:
				if(context == grammarAccess.getDataPageRule() ||
				   context == grammarAccess.getDynamicPageRule() ||
				   context == grammarAccess.getPageRule()) {
					sequence_DataPage(context, (DataPage) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.ENTITY:
				if(context == grammarAccess.getEntityRule()) {
					sequence_Entity(context, (Entity) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.HYPERTEXT_LAYER:
				if(context == grammarAccess.getHypertextLayerRule()) {
					sequence_HypertextLayer(context, (HypertextLayer) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.INDEX_PAGE:
				if(context == grammarAccess.getDynamicPageRule() ||
				   context == grammarAccess.getIndexPageRule() ||
				   context == grammarAccess.getPageRule()) {
					sequence_IndexPage(context, (IndexPage) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.LINK:
				if(context == grammarAccess.getLinkRule()) {
					sequence_Link(context, (Link) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.REFERENCE:
				if(context == grammarAccess.getReferenceRule()) {
					sequence_Reference(context, (Reference) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.STATIC_PAGE:
				if(context == grammarAccess.getPageRule() ||
				   context == grammarAccess.getStaticPageRule()) {
					sequence_StaticPage(context, (StaticPage) semanticObject); 
					return; 
				}
				else break;
			case SimpleWebModelPackage.WEB_MODEL:
				if(context == grammarAccess.getWebModelRule()) {
					sequence_WebModel(context, (WebModel) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (name=ID type=SimpleType)
	 */
	protected void sequence_Attribute(EObject context, Attribute semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.ATTRIBUTE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.ATTRIBUTE__NAME));
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.ATTRIBUTE__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.ATTRIBUTE__TYPE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getAttributeAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getAttributeAccess().getTypeSimpleTypeEnumRuleCall_3_0(), semanticObject.getType());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (entities+=Entity*)
	 */
	protected void sequence_DataLayer(EObject context, DataLayer semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID entity=[Entity|ID]? links+=Link*)
	 */
	protected void sequence_DataPage(EObject context, DataPage semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID attributes+=Attribute* references+=Reference*)
	 */
	protected void sequence_Entity(EObject context, Entity semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (pages+=Page+ startPage=[StaticPage|ID])
	 */
	protected void sequence_HypertextLayer(EObject context, HypertextLayer semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID entity=[Entity|ID]? links+=Link*)
	 */
	protected void sequence_IndexPage(EObject context, IndexPage semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     target=[Page|ID]
	 */
	protected void sequence_Link(EObject context, Link semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.LINK__TARGET) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.LINK__TARGET));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getLinkAccess().getTargetPageIDTerminalRuleCall_1_0_1(), semanticObject.getTarget());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID type=[Entity|ID])
	 */
	protected void sequence_Reference(EObject context, Reference semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.REFERENCE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.REFERENCE__NAME));
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.REFERENCE__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.REFERENCE__TYPE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getReferenceAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getReferenceAccess().getTypeEntityIDTerminalRuleCall_3_0_1(), semanticObject.getType());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID links+=Link*)
	 */
	protected void sequence_StaticPage(EObject context, StaticPage semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID dataLayer=DataLayer hypertextLayer=HypertextLayer)
	 */
	protected void sequence_WebModel(EObject context, WebModel semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.WEB_MODEL__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.WEB_MODEL__NAME));
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.WEB_MODEL__DATA_LAYER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.WEB_MODEL__DATA_LAYER));
			if(transientValues.isValueTransient(semanticObject, SimpleWebModelPackage.Literals.WEB_MODEL__HYPERTEXT_LAYER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, SimpleWebModelPackage.Literals.WEB_MODEL__HYPERTEXT_LAYER));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getWebModelAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getWebModelAccess().getDataLayerDataLayerParserRuleCall_3_0(), semanticObject.getDataLayer());
		feeder.accept(grammarAccess.getWebModelAccess().getHypertextLayerHypertextLayerParserRuleCall_4_0(), semanticObject.getHypertextLayer());
		feeder.finish();
	}
}
