/*
 * 
 */
package simplewebmodel.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

import simplewebmodel.diagram.edit.parts.AttributeEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerDataLayerEntitiesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerEditPart;
import simplewebmodel.diagram.edit.parts.DataPageEditPart;
import simplewebmodel.diagram.edit.parts.DynamicPageEntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEntityAttributesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.EntityEntityReferencesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerHypertextLayerPagesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageEditPart;
import simplewebmodel.diagram.edit.parts.LinkEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageEditPart;
import simplewebmodel.diagram.edit.parts.WebModelEditPart;
import simplewebmodel.diagram.part.Messages;
import simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry;

/**
 * @generated
 */
public class SimplewebmodelNavigatorContentProvider implements
		ICommonContentProvider {

	/**
	 * @generated
	 */
	private static final Object[] EMPTY_ARRAY = new Object[0];

	/**
	 * @generated
	 */
	private Viewer myViewer;

	/**
	 * @generated
	 */
	private AdapterFactoryEditingDomain myEditingDomain;

	/**
	 * @generated
	 */
	private WorkspaceSynchronizer myWorkspaceSynchronizer;

	/**
	 * @generated
	 */
	private Runnable myViewerRefreshRunnable;

	/**
	 * @generated
	 */
	@SuppressWarnings({ "unchecked", "serial", "rawtypes" })
	public SimplewebmodelNavigatorContentProvider() {
		TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE
				.createEditingDomain();
		myEditingDomain = (AdapterFactoryEditingDomain) editingDomain;
		myEditingDomain.setResourceToReadOnlyMap(new HashMap() {
			public Object get(Object key) {
				if (!containsKey(key)) {
					put(key, Boolean.TRUE);
				}
				return super.get(key);
			}
		});
		myViewerRefreshRunnable = new Runnable() {
			public void run() {
				if (myViewer != null) {
					myViewer.refresh();
				}
			}
		};
		myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain,
				new WorkspaceSynchronizer.Delegate() {
					public void dispose() {
					}

					public boolean handleResourceChanged(final Resource resource) {
						unloadAllResources();
						asyncRefresh();
						return true;
					}

					public boolean handleResourceDeleted(Resource resource) {
						unloadAllResources();
						asyncRefresh();
						return true;
					}

					public boolean handleResourceMoved(Resource resource,
							final URI newURI) {
						unloadAllResources();
						asyncRefresh();
						return true;
					}
				});
	}

	/**
	 * @generated
	 */
	public void dispose() {
		myWorkspaceSynchronizer.dispose();
		myWorkspaceSynchronizer = null;
		myViewerRefreshRunnable = null;
		myViewer = null;
		unloadAllResources();
		((TransactionalEditingDomain) myEditingDomain).dispose();
		myEditingDomain = null;
	}

	/**
	 * @generated
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		myViewer = viewer;
	}

	/**
	 * @generated
	 */
	void unloadAllResources() {
		for (Resource nextResource : myEditingDomain.getResourceSet()
				.getResources()) {
			nextResource.unload();
		}
	}

	/**
	 * @generated
	 */
	void asyncRefresh() {
		if (myViewer != null && !myViewer.getControl().isDisposed()) {
			myViewer.getControl().getDisplay()
					.asyncExec(myViewerRefreshRunnable);
		}
	}

	/**
	 * @generated
	 */
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	/**
	 * @generated
	 */
	public void restoreState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void saveState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void init(ICommonContentExtensionSite aConfig) {
	}

	/**
	 * @generated
	 */
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IFile) {
			IFile file = (IFile) parentElement;
			URI fileURI = URI.createPlatformResourceURI(file.getFullPath()
					.toString(), true);
			Resource resource = myEditingDomain.getResourceSet().getResource(
					fileURI, true);
			ArrayList<SimplewebmodelNavigatorItem> result = new ArrayList<SimplewebmodelNavigatorItem>();
			ArrayList<View> topViews = new ArrayList<View>(resource
					.getContents().size());
			for (EObject o : resource.getContents()) {
				if (o instanceof View) {
					topViews.add((View) o);
				}
			}
			result.addAll(createNavigatorItems(
					selectViewsByType(topViews, WebModelEditPart.MODEL_ID),
					file, false));
			return result.toArray();
		}

		if (parentElement instanceof SimplewebmodelNavigatorGroup) {
			SimplewebmodelNavigatorGroup group = (SimplewebmodelNavigatorGroup) parentElement;
			return group.getChildren();
		}

		if (parentElement instanceof SimplewebmodelNavigatorItem) {
			SimplewebmodelNavigatorItem navigatorItem = (SimplewebmodelNavigatorItem) parentElement;
			if (navigatorItem.isLeaf() || !isOwnView(navigatorItem.getView())) {
				return EMPTY_ARRAY;
			}
			return getViewChildren(navigatorItem.getView(), parentElement);
		}

		/*
		 * Due to plugin.xml restrictions this code will be called only for views representing
		 * shortcuts to this diagram elements created on other diagrams. 
		 */
		if (parentElement instanceof IAdaptable) {
			View view = (View) ((IAdaptable) parentElement)
					.getAdapter(View.class);
			if (view != null) {
				return getViewChildren(view, parentElement);
			}
		}

		return EMPTY_ARRAY;
	}

	/**
	 * @generated
	 */
	private Object[] getViewChildren(View view, Object parentElement) {
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {

		case DynamicPageEntityEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Edge sv = (Edge) view;
			SimplewebmodelNavigatorGroup target = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_DynamicPageEntity_4002_target,
					"icons/linkTargetNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SimplewebmodelNavigatorGroup source = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_DynamicPageEntity_4002_source,
					"icons/linkSourceNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(EntityEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(IndexPageEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DataPageEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			if (!target.isEmpty()) {
				result.add(target);
			}
			if (!source.isEmpty()) {
				result.add(source);
			}
			return result.toArray();
		}

		case HypertextLayerEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Node sv = (Node) view;
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(
					Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					SimplewebmodelVisualIDRegistry
							.getType(IndexPageEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(
					Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					SimplewebmodelVisualIDRegistry
							.getType(DataPageEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(
					Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					SimplewebmodelVisualIDRegistry
							.getType(StaticPageEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			return result.toArray();
		}

		case DataPageEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Node sv = (Node) view;
			SimplewebmodelNavigatorGroup incominglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_DataPage_3005_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SimplewebmodelNavigatorGroup outgoinglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_DataPage_3005_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DynamicPageEntityEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case WebModelEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			result.addAll(getForeignShortcuts((Diagram) view, parentElement));
			Diagram sv = (Diagram) view;
			SimplewebmodelNavigatorGroup links = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_WebModel_1000_links,
					"icons/linksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DataLayerEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(HypertextLayerEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getDiagramLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			links.addChildren(createNavigatorItems(connectedViews, links, false));
			connectedViews = getDiagramLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DynamicPageEntityEditPart.VISUAL_ID));
			links.addChildren(createNavigatorItems(connectedViews, links, false));
			if (!links.isEmpty()) {
				result.add(links);
			}
			return result.toArray();
		}

		case EntityEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Node sv = (Node) view;
			SimplewebmodelNavigatorGroup incominglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_Entity_3001_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(
					Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(EntityEntityAttributesCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					SimplewebmodelVisualIDRegistry
							.getType(AttributeEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(
					Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(EntityEntityReferencesCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					SimplewebmodelVisualIDRegistry
							.getType(ReferenceEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DynamicPageEntityEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			return result.toArray();
		}

		case IndexPageEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Node sv = (Node) view;
			SimplewebmodelNavigatorGroup incominglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_IndexPage_3004_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SimplewebmodelNavigatorGroup outgoinglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_IndexPage_3004_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DynamicPageEntityEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case DataLayerEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Node sv = (Node) view;
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(
					Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DataLayerDataLayerEntitiesCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					SimplewebmodelVisualIDRegistry
							.getType(EntityEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			return result.toArray();
		}

		case StaticPageEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Node sv = (Node) view;
			SimplewebmodelNavigatorGroup incominglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_StaticPage_3006_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SimplewebmodelNavigatorGroup outgoinglinks = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_StaticPage_3006_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(LinkEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case LinkEditPart.VISUAL_ID: {
			LinkedList<SimplewebmodelAbstractNavigatorItem> result = new LinkedList<SimplewebmodelAbstractNavigatorItem>();
			Edge sv = (Edge) view;
			SimplewebmodelNavigatorGroup target = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_Link_4001_target,
					"icons/linkTargetNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SimplewebmodelNavigatorGroup source = new SimplewebmodelNavigatorGroup(
					Messages.NavigatorGroupName_Link_4001_source,
					"icons/linkSourceNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(IndexPageEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DataPageEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(StaticPageEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(IndexPageEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(DataPageEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					SimplewebmodelVisualIDRegistry
							.getType(StaticPageEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			if (!target.isEmpty()) {
				result.add(target);
			}
			if (!source.isEmpty()) {
				result.add(source);
			}
			return result.toArray();
		}
		}
		return EMPTY_ARRAY;
	}

	/**
	 * @generated
	 */
	private Collection<View> getLinksSourceByType(Collection<Edge> edges,
			String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (Edge nextEdge : edges) {
			View nextEdgeSource = nextEdge.getSource();
			if (type.equals(nextEdgeSource.getType())
					&& isOwnView(nextEdgeSource)) {
				result.add(nextEdgeSource);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getLinksTargetByType(Collection<Edge> edges,
			String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (Edge nextEdge : edges) {
			View nextEdgeTarget = nextEdge.getTarget();
			if (type.equals(nextEdgeTarget.getType())
					&& isOwnView(nextEdgeTarget)) {
				result.add(nextEdgeTarget);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getOutgoingLinksByType(
			Collection<? extends View> nodes, String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (View nextNode : nodes) {
			result.addAll(selectViewsByType(nextNode.getSourceEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getIncomingLinksByType(
			Collection<? extends View> nodes, String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (View nextNode : nodes) {
			result.addAll(selectViewsByType(nextNode.getTargetEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getChildrenByType(
			Collection<? extends View> nodes, String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (View nextNode : nodes) {
			result.addAll(selectViewsByType(nextNode.getChildren(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getDiagramLinksByType(
			Collection<Diagram> diagrams, String type) {
		ArrayList<View> result = new ArrayList<View>();
		for (Diagram nextDiagram : diagrams) {
			result.addAll(selectViewsByType(nextDiagram.getEdges(), type));
		}
		return result;
	}

	// TODO refactor as static method
	/**
	 * @generated
	 */
	private Collection<View> selectViewsByType(Collection<View> views,
			String type) {
		ArrayList<View> result = new ArrayList<View>();
		for (View nextView : views) {
			if (type.equals(nextView.getType()) && isOwnView(nextView)) {
				result.add(nextView);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private boolean isOwnView(View view) {
		return WebModelEditPart.MODEL_ID.equals(SimplewebmodelVisualIDRegistry
				.getModelID(view));
	}

	/**
	 * @generated
	 */
	private Collection<SimplewebmodelNavigatorItem> createNavigatorItems(
			Collection<View> views, Object parent, boolean isLeafs) {
		ArrayList<SimplewebmodelNavigatorItem> result = new ArrayList<SimplewebmodelNavigatorItem>(
				views.size());
		for (View nextView : views) {
			result.add(new SimplewebmodelNavigatorItem(nextView, parent,
					isLeafs));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<SimplewebmodelNavigatorItem> getForeignShortcuts(
			Diagram diagram, Object parent) {
		LinkedList<View> result = new LinkedList<View>();
		for (Iterator<View> it = diagram.getChildren().iterator(); it.hasNext();) {
			View nextView = it.next();
			if (!isOwnView(nextView)
					&& nextView.getEAnnotation("Shortcut") != null) { //$NON-NLS-1$
				result.add(nextView);
			}
		}
		return createNavigatorItems(result, parent, false);
	}

	/**
	 * @generated
	 */
	public Object getParent(Object element) {
		if (element instanceof SimplewebmodelAbstractNavigatorItem) {
			SimplewebmodelAbstractNavigatorItem abstractNavigatorItem = (SimplewebmodelAbstractNavigatorItem) element;
			return abstractNavigatorItem.getParent();
		}
		return null;
	}

	/**
	 * @generated
	 */
	public boolean hasChildren(Object element) {
		return element instanceof IFile || getChildren(element).length > 0;
	}

}
