/*
 * 
 */
package simplewebmodel.diagram.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.ui.services.parser.CommonParserHint;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

import simplewebmodel.WebModel;
import simplewebmodel.diagram.edit.parts.AttributeEditPart;
import simplewebmodel.diagram.edit.parts.AttributeNameEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerNameEditPart;
import simplewebmodel.diagram.edit.parts.DataPageEditPart;
import simplewebmodel.diagram.edit.parts.DataPageNameEditPart;
import simplewebmodel.diagram.edit.parts.DynamicPageEntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityNameEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerNameEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageNameEditPart;
import simplewebmodel.diagram.edit.parts.LinkEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceNameEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageNameEditPart;
import simplewebmodel.diagram.edit.parts.WebModelEditPart;
import simplewebmodel.diagram.part.SimplewebmodelDiagramEditorPlugin;
import simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry;
import simplewebmodel.diagram.providers.SimplewebmodelElementTypes;
import simplewebmodel.diagram.providers.SimplewebmodelParserProvider;

/**
 * @generated
 */
public class SimplewebmodelNavigatorLabelProvider extends LabelProvider
		implements ICommonLabelProvider, ITreePathLabelProvider {

	/**
	 * @generated
	 */
	static {
		SimplewebmodelDiagramEditorPlugin
				.getInstance()
				.getImageRegistry()
				.put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor()); //$NON-NLS-1$
		SimplewebmodelDiagramEditorPlugin
				.getInstance()
				.getImageRegistry()
				.put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor()); //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	public void updateLabel(ViewerLabel label, TreePath elementPath) {
		Object element = elementPath.getLastSegment();
		if (element instanceof SimplewebmodelNavigatorItem
				&& !isOwnView(((SimplewebmodelNavigatorItem) element).getView())) {
			return;
		}
		label.setText(getText(element));
		label.setImage(getImage(element));
	}

	/**
	 * @generated
	 */
	public Image getImage(Object element) {
		if (element instanceof SimplewebmodelNavigatorGroup) {
			SimplewebmodelNavigatorGroup group = (SimplewebmodelNavigatorGroup) element;
			return SimplewebmodelDiagramEditorPlugin.getInstance()
					.getBundledImage(group.getIcon());
		}

		if (element instanceof SimplewebmodelNavigatorItem) {
			SimplewebmodelNavigatorItem navigatorItem = (SimplewebmodelNavigatorItem) element;
			if (!isOwnView(navigatorItem.getView())) {
				return super.getImage(element);
			}
			return getImage(navigatorItem.getView());
		}

		// Due to plugin.xml content will be called only for "own" views
		if (element instanceof IAdaptable) {
			View view = (View) ((IAdaptable) element).getAdapter(View.class);
			if (view != null && isOwnView(view)) {
				return getImage(view);
			}
		}

		return super.getImage(element);
	}

	/**
	 * @generated
	 */
	public Image getImage(View view) {
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {
		case DynamicPageEntityEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://www.eclipse.org/simplewebmodel/1.0?DynamicPage?entity", SimplewebmodelElementTypes.DynamicPageEntity_4002); //$NON-NLS-1$
		case HypertextLayerEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://www.eclipse.org/simplewebmodel/1.0?HypertextLayer", SimplewebmodelElementTypes.HypertextLayer_2002); //$NON-NLS-1$
		case DataPageEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://www.eclipse.org/simplewebmodel/1.0?DataPage", SimplewebmodelElementTypes.DataPage_3005); //$NON-NLS-1$
		case WebModelEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Diagram?http://www.eclipse.org/simplewebmodel/1.0?WebModel", SimplewebmodelElementTypes.WebModel_1000); //$NON-NLS-1$
		case EntityEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://www.eclipse.org/simplewebmodel/1.0?Entity", SimplewebmodelElementTypes.Entity_3001); //$NON-NLS-1$
		case AttributeEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://www.eclipse.org/simplewebmodel/1.0?Attribute", SimplewebmodelElementTypes.Attribute_3002); //$NON-NLS-1$
		case IndexPageEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://www.eclipse.org/simplewebmodel/1.0?IndexPage", SimplewebmodelElementTypes.IndexPage_3004); //$NON-NLS-1$
		case ReferenceEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://www.eclipse.org/simplewebmodel/1.0?Reference", SimplewebmodelElementTypes.Reference_3003); //$NON-NLS-1$
		case DataLayerEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://www.eclipse.org/simplewebmodel/1.0?DataLayer", SimplewebmodelElementTypes.DataLayer_2001); //$NON-NLS-1$
		case StaticPageEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://www.eclipse.org/simplewebmodel/1.0?StaticPage", SimplewebmodelElementTypes.StaticPage_3006); //$NON-NLS-1$
		case LinkEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://www.eclipse.org/simplewebmodel/1.0?Link", SimplewebmodelElementTypes.Link_4001); //$NON-NLS-1$
		}
		return getImage("Navigator?UnknownElement", null); //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	private Image getImage(String key, IElementType elementType) {
		ImageRegistry imageRegistry = SimplewebmodelDiagramEditorPlugin
				.getInstance().getImageRegistry();
		Image image = imageRegistry.get(key);
		if (image == null && elementType != null
				&& SimplewebmodelElementTypes.isKnownElementType(elementType)) {
			image = SimplewebmodelElementTypes.getImage(elementType);
			imageRegistry.put(key, image);
		}

		if (image == null) {
			image = imageRegistry.get("Navigator?ImageNotFound"); //$NON-NLS-1$
			imageRegistry.put(key, image);
		}
		return image;
	}

	/**
	 * @generated
	 */
	public String getText(Object element) {
		if (element instanceof SimplewebmodelNavigatorGroup) {
			SimplewebmodelNavigatorGroup group = (SimplewebmodelNavigatorGroup) element;
			return group.getGroupName();
		}

		if (element instanceof SimplewebmodelNavigatorItem) {
			SimplewebmodelNavigatorItem navigatorItem = (SimplewebmodelNavigatorItem) element;
			if (!isOwnView(navigatorItem.getView())) {
				return null;
			}
			return getText(navigatorItem.getView());
		}

		// Due to plugin.xml content will be called only for "own" views
		if (element instanceof IAdaptable) {
			View view = (View) ((IAdaptable) element).getAdapter(View.class);
			if (view != null && isOwnView(view)) {
				return getText(view);
			}
		}

		return super.getText(element);
	}

	/**
	 * @generated
	 */
	public String getText(View view) {
		if (view.getElement() != null && view.getElement().eIsProxy()) {
			return getUnresolvedDomainElementProxyText(view);
		}
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {
		case DynamicPageEntityEditPart.VISUAL_ID:
			return getDynamicPageEntity_4002Text(view);
		case HypertextLayerEditPart.VISUAL_ID:
			return getHypertextLayer_2002Text(view);
		case DataPageEditPart.VISUAL_ID:
			return getDataPage_3005Text(view);
		case WebModelEditPart.VISUAL_ID:
			return getWebModel_1000Text(view);
		case EntityEditPart.VISUAL_ID:
			return getEntity_3001Text(view);
		case AttributeEditPart.VISUAL_ID:
			return getAttribute_3002Text(view);
		case IndexPageEditPart.VISUAL_ID:
			return getIndexPage_3004Text(view);
		case ReferenceEditPart.VISUAL_ID:
			return getReference_3003Text(view);
		case DataLayerEditPart.VISUAL_ID:
			return getDataLayer_2001Text(view);
		case StaticPageEditPart.VISUAL_ID:
			return getStaticPage_3006Text(view);
		case LinkEditPart.VISUAL_ID:
			return getLink_4001Text(view);
		}
		return getUnknownElementText(view);
	}

	/**
	 * @generated
	 */
	private String getDynamicPageEntity_4002Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.DynamicPageEntity_4002,
				view.getElement() != null ? view.getElement() : view,
				CommonParserHint.DESCRIPTION);
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 6001); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getHypertextLayer_2002Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.HypertextLayer_2002, view
						.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(HypertextLayerNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5008); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getDataPage_3005Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.DataPage_3005,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(DataPageNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5006); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getWebModel_1000Text(View view) {
		WebModel domainModelElement = (WebModel) view.getElement();
		if (domainModelElement != null) {
			return domainModelElement.getName();
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"No domain element for view with visualID = " + 1000); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEntity_3001Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.Entity_3001,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(EntityNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5003); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getAttribute_3002Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.Attribute_3002,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(AttributeNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5001); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getIndexPage_3004Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.IndexPage_3004,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(IndexPageNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5005); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getReference_3003Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.Reference_3003,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(ReferenceNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5002); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getDataLayer_2001Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.DataLayer_2001,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(DataLayerNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5004); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getStaticPage_3006Text(View view) {
		IParser parser = SimplewebmodelParserProvider.getParser(
				SimplewebmodelElementTypes.StaticPage_3006,
				view.getElement() != null ? view.getElement() : view,
				SimplewebmodelVisualIDRegistry
						.getType(StaticPageNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(
					view.getElement() != null ? view.getElement() : view),
					ParserOptions.NONE.intValue());
		} else {
			SimplewebmodelDiagramEditorPlugin.getInstance().logError(
					"Parser was not found for label " + 5007); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getLink_4001Text(View view) {
		return ""; //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	private String getUnknownElementText(View view) {
		return "<UnknownElement Visual_ID = " + view.getType() + ">"; //$NON-NLS-1$  //$NON-NLS-2$
	}

	/**
	 * @generated
	 */
	private String getUnresolvedDomainElementProxyText(View view) {
		return "<Unresolved domain element Visual_ID = " + view.getType() + ">"; //$NON-NLS-1$  //$NON-NLS-2$
	}

	/**
	 * @generated
	 */
	public void init(ICommonContentExtensionSite aConfig) {
	}

	/**
	 * @generated
	 */
	public void restoreState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void saveState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public String getDescription(Object anElement) {
		return null;
	}

	/**
	 * @generated
	 */
	private boolean isOwnView(View view) {
		return WebModelEditPart.MODEL_ID.equals(SimplewebmodelVisualIDRegistry
				.getModelID(view));
	}

}
