/*
 * 
 */
package simplewebmodel.diagram.providers;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;

import simplewebmodel.diagram.edit.parts.WebModelEditPart;
import simplewebmodel.diagram.part.SimplewebmodelDiagramEditorPlugin;
import simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry;

/**
 * @generated
 */
public class SimplewebmodelValidationProvider {

	/**
	 * @generated
	 */
	private static boolean constraintsActive = false;

	/**
	 * @generated
	 */
	public static boolean shouldConstraintsBePrivate() {
		return false;
	}

	/**
	 * @generated
	 */
	public static void runWithConstraints(
			TransactionalEditingDomain editingDomain, Runnable operation) {
		final Runnable op = operation;
		Runnable task = new Runnable() {
			public void run() {
				try {
					constraintsActive = true;
					op.run();
				} finally {
					constraintsActive = false;
				}
			}
		};
		if (editingDomain != null) {
			try {
				editingDomain.runExclusive(task);
			} catch (Exception e) {
				SimplewebmodelDiagramEditorPlugin.getInstance().logError(
						"Validation failed", e); //$NON-NLS-1$
			}
		} else {
			task.run();
		}
	}

	/**
	 * @generated
	 */
	static boolean isInDefaultEditorContext(Object object) {
		if (shouldConstraintsBePrivate() && !constraintsActive) {
			return false;
		}
		if (object instanceof View) {
			return constraintsActive
					&& WebModelEditPart.MODEL_ID
							.equals(SimplewebmodelVisualIDRegistry
									.getModelID((View) object));
		}
		return true;
	}

}
