package simplewebmodel.smells;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.Entity;
import simplewebmodel.IndexPage;

public class EntityWithoutIndexPage implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Entity> entities = getAllEntities(root);
		List<IndexPage> indexPages = getAllIndexPages(root);
		for (Entity entity : entities) {
			boolean isReferenced = false;
			for (IndexPage indexPage : indexPages) {
				if (indexPage.getEntity() == entity) {
					isReferenced = true;
				}
			}
			if (! isReferenced) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(entity);
				results.add(result);
			}
		}
		return results;
	}
	
	private List<Entity> getAllEntities(EObject root) {
		List<Entity> entities = new ArrayList<Entity>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Entity) {
				entities.add((Entity) eObject);
			}
		}
		return entities;
	}
	
	private List<IndexPage> getAllIndexPages(EObject root) {
		List<IndexPage> indexPages = new ArrayList<IndexPage>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof IndexPage) {
				indexPages.add((IndexPage) eObject);
			}
		}
		return indexPages;
	}

}
