package simplewebmodel.smells;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.Link;
import simplewebmodel.Page;

public class MultipleLinkDefinitions implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Page> pages = getAllPages(root);
		for (Page page : pages) {
			Set<Page> referencedPages = new HashSet<Page>();
			for (Link link : page.getLinks()) {
				referencedPages.add(link.getTarget());
			}
			if (page.getLinks().size() > referencedPages.size()) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(page);
				results.add(result);
			}
		}
		return results;
	}

	private List<Page> getAllPages(EObject root) {
		List<Page> pages = new ArrayList<Page>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Page) {
				pages.add((Page) eObject);
			}
		}
		return pages;
	}

}
