/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.RendererMessages;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.model.reporting.ReportService;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class SimpleControlSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private SWTGridDescription rendererGridDescription;

    public SimpleControlSWTRenderer() {
    }

    SimpleControlSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    public final SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE ? 2 : 3, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected final Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createLabel(parent);
            }
            case 1: {
                return this.createValidationIcon(parent);
            }
            case 2: {
                if (this.isUnsettable()) {
                    return this.createUnsettableControl(parent);
                }
                return this.createControl(parent);
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", gridCell.toString(), ((Object)((Object)this)).toString()));
    }

    protected boolean isUnsettable() {
        return ((EStructuralFeature)((VControl)this.getVElement()).getDomainModelReference().getEStructuralFeatureIterator().next()).isUnsettable();
    }

    private Control createUnsettableControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        Composite controlComposite = new Composite(composite, 0);
        controlComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)controlComposite);
        final StackLayout sl = new StackLayout();
        controlComposite.setLayout((Layout)sl);
        final Control baseControl = this.createControl(controlComposite);
        final Control createUnsetLabel = this.createUnsetLabel(controlComposite);
        final Button unsetButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)unsetButton);
        unsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VControl)SimpleControlSWTRenderer.this.getVElement()).getDomainModelReference().getIterator().next();
                Object value = null;
                if (!setting.isSet()) {
                    sl.topControl = baseControl;
                    unsetButton.setText(RendererMessages.SimpleControlSWTRenderer_Unset);
                    value = setting.getEStructuralFeature().getDefaultValue();
                } else {
                    sl.topControl = createUnsetLabel;
                    unsetButton.setText(RendererMessages.SimpleControlSWTRenderer_Set);
                    value = SetCommand.UNSET_VALUE;
                }
                EditingDomain editingDomain = SimpleControlSWTRenderer.this.getEditingDomain(setting);
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature(), (Object)value));
                composite.layout();
            }
        });
        if (((EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next()).isSet()) {
            sl.topControl = baseControl;
            unsetButton.setText(RendererMessages.SimpleControlSWTRenderer_Unset);
        } else {
            sl.topControl = createUnsetLabel;
            unsetButton.setText(RendererMessages.SimpleControlSWTRenderer_Set);
        }
        return composite;
    }

    private Control createUnsetLabel(Composite parent) {
        Label unsetLabel = new Label(parent, 0);
        unsetLabel.setBackground(parent.getBackground());
        unsetLabel.setText(this.getUnsetText());
        return unsetLabel;
    }

    protected abstract String getUnsetText();

    protected void setValidationColor(Control control, Color validationColor) {
        control.setBackground(validationColor);
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                control.setEnabled(enabled);
            }
        }
    }

    protected final void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SimpleControlSWTRenderer.this.getControls().size() == 0 || ((Control)SimpleControlSWTRenderer.this.getControls().values().iterator().next()).isDisposed()) {
                    return;
                }
                SimpleControlSWTRenderer.this.applyInnerValidation();
            }
        });
    }

    private void applyInnerValidation() {
        Control editControl;
        Label validationIcon;
        switch (this.getControls().size()) {
            case 2: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 0, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this));
                break;
            }
            case 3: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 2, (AbstractSWTRenderer)this));
                break;
            }
            default: {
                if (ViewModelUtil.isDebugMode()) {
                    ReportService reportService = Activator.getDefault().getReportService();
                    reportService.report(new AbstractReport("Wrong number of controls!"));
                }
                return;
            }
        }
        if (validationIcon == null || editControl == null) {
            return;
        }
        if (validationIcon.isDisposed()) {
            return;
        }
        int highestSeverity = 0;
        if (((VControl)this.getVElement()).getDiagnostic() != null) {
            highestSeverity = ((VControl)this.getVElement()).getDiagnostic().getHighestSeverity();
        }
        validationIcon.setImage(this.getValidationIcon(highestSeverity));
        this.setValidationColor(editControl, this.getValidationBackgroundColor(highestSeverity));
        if (((VControl)this.getVElement()).getDiagnostic() == null) {
            validationIcon.setToolTipText(null);
        } else {
            validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VControl)this.getVElement()).getDiagnostic().getMessage(), null));
        }
    }

    protected abstract Control createControl(Composite var1);

    @Override
    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }
}

